/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BImport;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;

public class EvaluationImportResolver
extends NodeVisitor {
    private final SuspendedContext context;
    private final Map<String, BImport> capturedImports = new HashMap<String, BImport>();
    private final Map<String, BImport> visibleImports = new HashMap<String, BImport>();
    private final List<ModuleSymbol> visibleModuleSymbols = new ArrayList<ModuleSymbol>();
    private final List<EvaluationException> capturedErrors = new ArrayList<EvaluationException>();

    public EvaluationImportResolver(SuspendedContext context) {
        this.context = context;
    }

    public Map<String, BImport> getAllImports() {
        this.resolveVisibleImports();
        return Map.copyOf(this.visibleImports);
    }

    public Map<String, BImport> detectUsedImports(NonTerminalNode syntaxNode) throws EvaluationException {
        return this.detectUsedImports(syntaxNode, null);
    }

    public Map<String, BImport> detectUsedImports(NonTerminalNode syntaxNode, Map<String, BImport> resolvedImports) throws EvaluationException {
        if (resolvedImports == null) {
            this.resolveVisibleImports();
        } else {
            this.visibleImports.clear();
            this.visibleImports.putAll(resolvedImports);
        }
        syntaxNode.accept((NodeVisitor)this);
        if (!this.capturedErrors.isEmpty()) {
            throw this.capturedErrors.get(0);
        }
        return Map.copyOf(this.capturedImports);
    }

    public void visit(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
        String modulePrefix = qualifiedNameReferenceNode.modulePrefix().text().trim();
        if (!this.visibleImports.containsKey(modulePrefix)) {
            this.capturedErrors.add(EvaluationException.createEvaluationException(EvaluationExceptionKind.IMPORT_RESOLVING_ERROR, modulePrefix));
            return;
        }
        BImport bImport = this.visibleImports.get(modulePrefix);
        this.capturedImports.put(bImport.alias(), bImport);
    }

    private void resolveVisibleImports() {
        this.loadVisibleModuleSymbols();
        if (!this.visibleImports.isEmpty()) {
            return;
        }
        SyntaxTree documentTree = this.context.getDocument().syntaxTree();
        if (!documentTree.containsModulePart()) {
            return;
        }
        NodeList imports = ((ModulePartNode)documentTree.rootNode()).imports();
        for (ImportDeclarationNode importNode : imports) {
            Optional<String> orgName = this.resolveImportOrgName(importNode);
            Optional<String> moduleName = importNode.moduleName().stream().map(identifierToken -> IdentifierModifier.encodeIdentifier(identifierToken.text().trim(), IdentifierModifier.IdentifierType.OTHER)).reduce((s1, s2) -> s1 + "." + s2);
            if (!orgName.isPresent() || !moduleName.isPresent()) continue;
            String importAlias = this.resolveImportAlias(importNode, moduleName.get());
            BImport bImport = new BImport(orgName.get(), moduleName.get(), importAlias);
            List<ModuleSymbol> matchingModuleSymbols = this.visibleModuleSymbols.stream().filter(moduleSymbol -> moduleSymbol.id().orgName().equals(bImport.orgName()) && moduleSymbol.id().moduleName().equals(bImport.moduleName())).toList();
            if (matchingModuleSymbols.isEmpty()) {
                this.capturedErrors.add(EvaluationException.createEvaluationException(EvaluationExceptionKind.IMPORT_RESOLVING_ERROR, importAlias));
                return;
            }
            if (matchingModuleSymbols.size() > 1) {
                this.capturedErrors.add(EvaluationException.createEvaluationException(String.format("Multiple modules found for import '%s'", importAlias)));
                return;
            }
            bImport.setResolvedSymbol(matchingModuleSymbols.get(0));
            this.visibleImports.put(importAlias, bImport);
        }
    }

    private void loadVisibleModuleSymbols() {
        if (!this.visibleModuleSymbols.isEmpty()) {
            return;
        }
        this.visibleModuleSymbols.addAll(this.context.getSemanticInfo().visibleSymbols(this.context.getDocument(), LinePosition.from((int)this.context.getLineNumber(), (int)0)).stream().filter(symbol -> symbol.kind() == SymbolKind.MODULE).map(symbol -> (ModuleSymbol)symbol).toList());
    }

    private Optional<String> resolveImportOrgName(ImportDeclarationNode importNode) {
        if (importNode.orgName().isPresent()) {
            return Optional.of(((ImportOrgNameNode)importNode.orgName().get()).orgName().text().trim());
        }
        return this.context.getPackageOrg();
    }

    private String resolveImportAlias(ImportDeclarationNode importNode, String moduleName) {
        if (importNode.prefix().isPresent()) {
            return ((ImportPrefixNode)importNode.prefix().get()).prefix().text().trim();
        }
        String[] moduleNameParts = moduleName.split("\\.");
        return moduleNameParts[moduleNameParts.length - 1];
    }
}

