/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation;

import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.InterpolationNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RestArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.action.RemoteMethodCallActionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.AnnotationAccessExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.AnonFunctionExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.BasicLiteralEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.BinaryExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.BuiltinSimpleNameReferenceEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.ConditionalExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.ErrorConstructorExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.FieldAccessExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.FunctionInvocationExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.LetExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.MemberAccessExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.MethodCallExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.NewExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.OptionalFieldAccessExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.QualifiedNameReferenceEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.QueryExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.RangeExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.SimpleNameReferenceEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.StringTemplateEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.TrapExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.TypeCastExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.TypeOfExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.TypeTestExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.UnaryExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.XMLFilterExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.XMLStepExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.expression.XMLTemplateExpressionEvaluator;

public class EvaluatorBuilder
extends NodeVisitor {
    private final Set<SyntaxKind> supportedSyntax = new HashSet<SyntaxKind>();
    private final Set<SyntaxKind> capturedSyntax = new HashSet<SyntaxKind>();
    private final List<Node> unsupportedNodes = new ArrayList<Node>();
    private final EvaluationContext context;
    private Evaluator result = null;
    private EvaluationException builderException = null;

    public EvaluatorBuilder(EvaluationContext context) {
        this.context = context;
        this.prepareForEvaluation();
    }

    public Evaluator build(ExpressionNode parsedExpr) throws EvaluationException {
        this.clearState();
        parsedExpr.accept((NodeVisitor)this);
        if (this.unsupportedSyntaxDetected()) {
            StringJoiner errors = new StringJoiner(System.lineSeparator());
            this.unsupportedNodes.forEach(node -> errors.add(String.format("'%s' - %s", node.toString(), node.kind())));
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.UNSUPPORTED_EXPRESSION, errors);
        }
        if (this.result == null) {
            throw this.builderException;
        }
        return this.result;
    }

    public void visit(BracedExpressionNode bracedExpressionNode) {
        this.visitSyntaxNode((Node)bracedExpressionNode);
        bracedExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(BinaryExpressionNode binaryExpressionNode) {
        this.visitSyntaxNode((Node)binaryExpressionNode);
        binaryExpressionNode.lhsExpr().accept((NodeVisitor)this);
        Evaluator lhsEvaluator = this.result;
        binaryExpressionNode.rhsExpr().accept((NodeVisitor)this);
        Evaluator rhsEvaluator = this.result;
        switch (binaryExpressionNode.operator().kind()) {
            case ELLIPSIS_TOKEN: 
            case DOUBLE_DOT_LT_TOKEN: {
                this.result = new RangeExpressionEvaluator(this.context, binaryExpressionNode, lhsEvaluator, rhsEvaluator);
                return;
            }
        }
        this.result = new BinaryExpressionEvaluator(this.context, binaryExpressionNode, lhsEvaluator, rhsEvaluator);
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        this.visitSyntaxNode((Node)functionCallExpressionNode);
        try {
            List<Map.Entry<String, Evaluator>> argEvaluators = this.processArgs((SeparatedNodeList<FunctionArgumentNode>)functionCallExpressionNode.arguments());
            this.result = new FunctionInvocationExpressionEvaluator(this.context, functionCallExpressionNode, argEvaluators);
        }
        catch (EvaluationException e) {
            this.builderException = e;
        }
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        this.visitSyntaxNode((Node)methodCallExpressionNode);
        try {
            methodCallExpressionNode.expression().accept((NodeVisitor)this);
            Evaluator expression = this.result;
            List<Map.Entry<String, Evaluator>> argEvaluators = this.processArgs((SeparatedNodeList<FunctionArgumentNode>)methodCallExpressionNode.arguments());
            this.result = new MethodCallExpressionEvaluator(this.context, (ExpressionNode)methodCallExpressionNode, expression, argEvaluators);
        }
        catch (EvaluationException e) {
            this.builderException = e;
        }
    }

    public void visit(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        this.visitSyntaxNode((Node)errorConstructorExpressionNode);
        try {
            List<Map.Entry<String, Evaluator>> argEvaluators = this.processArgs((SeparatedNodeList<FunctionArgumentNode>)errorConstructorExpressionNode.arguments());
            this.result = new ErrorConstructorExpressionEvaluator(this.context, errorConstructorExpressionNode, argEvaluators);
        }
        catch (EvaluationException e) {
            this.builderException = e;
        }
    }

    public void visit(FieldAccessExpressionNode fieldAccessExpressionNode) {
        this.visitSyntaxNode((Node)fieldAccessExpressionNode);
        fieldAccessExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator expression = this.result;
        this.result = new FieldAccessExpressionEvaluator(this.context, expression, (ExpressionNode)fieldAccessExpressionNode);
    }

    public void visit(OptionalFieldAccessExpressionNode optionalFieldAccessExpressionNode) {
        this.visitSyntaxNode((Node)optionalFieldAccessExpressionNode);
        optionalFieldAccessExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator expression = this.result;
        this.result = new OptionalFieldAccessExpressionEvaluator(this.context, expression, optionalFieldAccessExpressionNode);
    }

    public void visit(ConditionalExpressionNode conditionalExpressionNode) {
        this.visitSyntaxNode((Node)conditionalExpressionNode);
        conditionalExpressionNode.lhsExpression().accept((NodeVisitor)this);
        Evaluator lhsExprEvaluator = this.result;
        conditionalExpressionNode.middleExpression().accept((NodeVisitor)this);
        Evaluator middleExprEvaluator = this.result;
        conditionalExpressionNode.endExpression().accept((NodeVisitor)this);
        Evaluator endExprEvaluator = this.result;
        this.result = new ConditionalExpressionEvaluator(this.context, conditionalExpressionNode, lhsExprEvaluator, middleExprEvaluator, endExprEvaluator);
    }

    public void visit(TypeofExpressionNode typeofExpressionNode) {
        this.visitSyntaxNode((Node)typeofExpressionNode);
        typeofExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator subExprEvaluator = this.result;
        this.result = new TypeOfExpressionEvaluator(this.context, typeofExpressionNode, subExprEvaluator);
    }

    public void visit(IndexedExpressionNode indexedExpressionNode) {
        this.visitSyntaxNode((Node)indexedExpressionNode);
        indexedExpressionNode.containerExpression().accept((NodeVisitor)this);
        Evaluator containerEvaluator = this.result;
        SeparatedNodeList keyNodes = indexedExpressionNode.keyExpression();
        for (int index = keyNodes.size() - 2; index > 0; index -= 2) {
            keyNodes.remove(index);
        }
        ArrayList<Evaluator> keyEvaluators = new ArrayList<Evaluator>();
        for (int idx = 0; idx < keyNodes.size(); ++idx) {
            ExpressionNode keyExprNode = (ExpressionNode)keyNodes.get(idx);
            keyExprNode.accept((NodeVisitor)this);
            if (this.result == null) {
                this.builderException = EvaluationException.createEvaluationException(EvaluationExceptionKind.INVALID_ARGUMENT, keyExprNode.toSourceCode().trim());
                return;
            }
            keyEvaluators.add(this.result);
        }
        this.result = new MemberAccessExpressionEvaluator(this.context, indexedExpressionNode, containerEvaluator, keyEvaluators);
    }

    public void visit(PositionalArgumentNode positionalArgumentNode) {
        this.visitSyntaxNode((Node)positionalArgumentNode);
        positionalArgumentNode.expression().accept((NodeVisitor)this);
    }

    public void visit(NamedArgumentNode namedArgumentNode) {
        this.visitSyntaxNode((Node)namedArgumentNode);
        namedArgumentNode.expression().accept((NodeVisitor)this);
    }

    public void visit(RestArgumentNode restArgumentNode) {
        this.visitSyntaxNode((Node)restArgumentNode);
        restArgumentNode.expression().accept((NodeVisitor)this);
    }

    public void visit(TypeTestExpressionNode typeTestExpressionNode) {
        this.visitSyntaxNode((Node)typeTestExpressionNode);
        this.result = new TypeTestExpressionEvaluator(this.context, typeTestExpressionNode);
    }

    public void visit(TypeCastExpressionNode typeCastExpressionNode) {
        this.visitSyntaxNode((Node)typeCastExpressionNode);
        typeCastExpressionNode.expression().accept((NodeVisitor)this);
        if (typeCastExpressionNode.expression().kind() == SyntaxKind.QUERY_EXPRESSION) {
            return;
        }
        Evaluator subExprEvaluator = this.result;
        this.result = new TypeCastExpressionEvaluator(this.context, typeCastExpressionNode, subExprEvaluator);
    }

    public void visit(AnnotAccessExpressionNode annotAccessExpressionNode) {
        this.visitSyntaxNode((Node)annotAccessExpressionNode);
        annotAccessExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator exprEvaluator = this.result;
        this.result = new AnnotationAccessExpressionEvaluator(this.context, annotAccessExpressionNode, exprEvaluator);
    }

    public void visit(TemplateExpressionNode templateExpressionNode) {
        this.visitSyntaxNode((Node)templateExpressionNode);
        Optional typeOp = templateExpressionNode.type();
        if (typeOp.isEmpty()) {
            return;
        }
        SyntaxKind type = ((Token)typeOp.get()).kind();
        if (type == SyntaxKind.STRING_KEYWORD) {
            ArrayList<Evaluator> templateMemberEvaluators = new ArrayList<Evaluator>();
            for (int i = 0; i < templateExpressionNode.content().size(); ++i) {
                Node templateMemberNode = templateExpressionNode.content().get(i);
                templateMemberNode.accept((NodeVisitor)this);
                templateMemberEvaluators.add(this.result);
            }
            this.result = new StringTemplateEvaluator(this.context, templateExpressionNode, templateMemberEvaluators);
        } else if (type == SyntaxKind.XML_KEYWORD) {
            this.result = new XMLTemplateExpressionEvaluator(this.context, templateExpressionNode);
        }
    }

    public void visit(InterpolationNode interpolationNode) {
        this.visitSyntaxNode((Node)interpolationNode);
        interpolationNode.expression().accept((NodeVisitor)this);
    }

    public void visit(XMLStepExpressionNode xmlStepExpressionNode) {
        this.visitSyntaxNode((Node)xmlStepExpressionNode);
        xmlStepExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator subExprEvaluator = this.result;
        this.result = new XMLStepExpressionEvaluator(this.context, xmlStepExpressionNode, subExprEvaluator);
    }

    public void visit(XMLFilterExpressionNode xmlFilterExpressionNode) {
        this.visitSyntaxNode((Node)xmlFilterExpressionNode);
        xmlFilterExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator subExprEvaluator = this.result;
        this.result = new XMLFilterExpressionEvaluator(this.context, xmlFilterExpressionNode, subExprEvaluator);
    }

    public void visit(TrapExpressionNode trapExpressionNode) {
        this.visitSyntaxNode((Node)trapExpressionNode);
        trapExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator subExprEvaluator = this.result;
        this.result = new TrapExpressionEvaluator(this.context, trapExpressionNode, subExprEvaluator);
    }

    public void visit(UnaryExpressionNode unaryExpressionNode) {
        this.visitSyntaxNode((Node)unaryExpressionNode);
        unaryExpressionNode.expression().accept((NodeVisitor)this);
        Evaluator subExprEvaluator = this.result;
        this.result = new UnaryExpressionEvaluator(this.context, unaryExpressionNode, subExprEvaluator);
    }

    public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
        this.visitSyntaxNode((Node)explicitNewExpressionNode);
        try {
            List<Map.Entry<String, Evaluator>> argEvaluators = this.processArgs((SeparatedNodeList<FunctionArgumentNode>)explicitNewExpressionNode.parenthesizedArgList().arguments());
            this.result = new NewExpressionEvaluator(this.context, (ExpressionNode)explicitNewExpressionNode, argEvaluators);
        }
        catch (EvaluationException e) {
            this.builderException = e;
        }
    }

    public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
        this.visitSyntaxNode((Node)implicitNewExpressionNode);
        this.result = new NewExpressionEvaluator(this.context, (ExpressionNode)implicitNewExpressionNode, null);
    }

    public void visit(ExplicitAnonymousFunctionExpressionNode explicitAnonFunctionNode) {
        this.visitSyntaxNode((Node)explicitAnonFunctionNode);
        this.result = new AnonFunctionExpressionEvaluator(this.context, (ExpressionNode)explicitAnonFunctionNode);
    }

    public void visit(ImplicitAnonymousFunctionExpressionNode implicitAnonFunctionNode) {
        this.visitSyntaxNode((Node)implicitAnonFunctionNode);
        this.result = new AnonFunctionExpressionEvaluator(this.context, (ExpressionNode)implicitAnonFunctionNode);
    }

    public void visit(QueryExpressionNode queryExpressionNode) {
        this.visitSyntaxNode((Node)queryExpressionNode);
        this.result = new QueryExpressionEvaluator(this.context, queryExpressionNode);
    }

    public void visit(LetExpressionNode letExpressionNode) {
        this.visitSyntaxNode((Node)letExpressionNode);
        this.result = new LetExpressionEvaluator(this.context, letExpressionNode);
    }

    public void visit(RemoteMethodCallActionNode methodCallActionNode) {
        this.visitSyntaxNode((Node)methodCallActionNode);
        try {
            methodCallActionNode.expression().accept((NodeVisitor)this);
            Evaluator expression = this.result;
            List<Map.Entry<String, Evaluator>> argEvaluators = this.processArgs((SeparatedNodeList<FunctionArgumentNode>)methodCallActionNode.arguments());
            this.result = new RemoteMethodCallActionEvaluator(this.context, methodCallActionNode, expression, argEvaluators);
        }
        catch (EvaluationException e) {
            this.builderException = e;
        }
    }

    public void visit(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
        this.visitSyntaxNode((Node)qualifiedNameReferenceNode);
        this.result = new QualifiedNameReferenceEvaluator(this.context, qualifiedNameReferenceNode);
    }

    public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
        this.visitSyntaxNode((Node)simpleNameReferenceNode);
        this.result = new SimpleNameReferenceEvaluator(this.context, simpleNameReferenceNode);
    }

    public void visit(BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode) {
        this.visitSyntaxNode((Node)builtinSimpleNameReferenceNode);
        this.result = new BuiltinSimpleNameReferenceEvaluator(this.context, builtinSimpleNameReferenceNode);
    }

    public void visit(BasicLiteralNode basicLiteralNode) {
        this.visitSyntaxNode((Node)basicLiteralNode);
        this.result = new BasicLiteralEvaluator(this.context, basicLiteralNode);
    }

    public void visit(NilLiteralNode nilLiteralNode) {
        this.visitSyntaxNode((Node)nilLiteralNode);
        this.result = new BasicLiteralEvaluator(this.context, nilLiteralNode);
    }

    protected void visitSyntaxNode(Node node) {
        this.capturedSyntax.add(node.kind());
        if (!this.supportedSyntax.contains(node.kind())) {
            this.unsupportedNodes.add(node);
        }
    }

    public void visit(Token token) {
        if (token.kind() == SyntaxKind.TEMPLATE_STRING) {
            this.result = new BasicLiteralEvaluator(this.context, token);
        }
    }

    private boolean unsupportedSyntaxDetected() {
        return !this.unsupportedNodes.isEmpty();
    }

    private void prepareForEvaluation() {
        this.addLiteralExpressionSyntax();
        this.addStringTemplateExpressionSyntax();
        this.addXmlTemplateExpressionSyntax();
        this.addNewExpressionSyntax();
        this.addVariableReferenceExpressionSyntax();
        this.addFieldAccessExpressionSyntax();
        this.addOptionalFieldAccessExpressionSyntax();
        this.addXmlAttributeAccessExpressionSyntax();
        this.addAnnotationAccessExpressionSyntax();
        this.addMemberAccessExpressionSyntax();
        this.addFunctionCallExpressionSyntax();
        this.addMethodCallExpressionSyntax();
        this.addErrorConstructorExpressionSyntax();
        this.addAnonymousFunctionExpressionSyntax();
        this.addLetExpressionSyntax();
        this.addTypeCastExpressionSyntax();
        this.addTypeOfExpressionSyntax();
        this.addUnaryExpressionSyntax();
        this.addMultiplicativeExpressionSyntax();
        this.addAdditiveExpressionSyntax();
        this.addShiftExpressionSyntax();
        this.addRangeExpressionSyntax();
        this.addNumericalComparisonExpressionSyntax();
        this.addTypeTestExpressionSyntax();
        this.addEqualityExpressionSyntax();
        this.addBinaryBitwiseExpressionSyntax();
        this.addLogicalExpressionSyntax();
        this.addConditionalExpressionSyntax();
        this.addCheckingExpressionSyntax();
        this.addTrapExpressionSyntax();
        this.addQueryExpressionSyntax();
        this.addXmlNavigationExpressionSyntax();
        this.addMiscellaneousSyntax();
        this.addRemoteMethodCallActionSyntax();
    }

    private void addLiteralExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.NIL_LITERAL);
        this.supportedSyntax.add(SyntaxKind.BOOLEAN_LITERAL);
        this.supportedSyntax.add(SyntaxKind.TRUE_KEYWORD);
        this.supportedSyntax.add(SyntaxKind.FALSE_KEYWORD);
        this.supportedSyntax.add(SyntaxKind.NUMERIC_LITERAL);
        this.supportedSyntax.add(SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN);
        this.supportedSyntax.add(SyntaxKind.DECIMAL_FLOATING_POINT_LITERAL_TOKEN);
        this.supportedSyntax.add(SyntaxKind.STRING_LITERAL);
    }

    private void addStringTemplateExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.STRING_TEMPLATE_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.INTERPOLATION);
    }

    private void addXmlTemplateExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.XML_TEMPLATE_EXPRESSION);
    }

    private void addNewExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.IMPLICIT_NEW_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.EXPLICIT_NEW_EXPRESSION);
    }

    private void addVariableReferenceExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.SIMPLE_NAME_REFERENCE);
        this.supportedSyntax.add(SyntaxKind.QUALIFIED_NAME_REFERENCE);
    }

    private void addFieldAccessExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.FIELD_ACCESS);
    }

    private void addOptionalFieldAccessExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.OPTIONAL_FIELD_ACCESS);
    }

    private void addXmlAttributeAccessExpressionSyntax() {
    }

    private void addAnnotationAccessExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.ANNOT_ACCESS);
    }

    private void addMemberAccessExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.INDEXED_EXPRESSION);
    }

    private void addFunctionCallExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.FUNCTION_CALL);
        this.supportedSyntax.add(SyntaxKind.POSITIONAL_ARG);
        this.supportedSyntax.add(SyntaxKind.NAMED_ARG);
        this.supportedSyntax.add(SyntaxKind.REST_ARG);
        this.supportedSyntax.add(SyntaxKind.OPEN_PAREN_TOKEN);
        this.supportedSyntax.add(SyntaxKind.CLOSE_PAREN_TOKEN);
    }

    private void addMethodCallExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.METHOD_CALL);
        this.supportedSyntax.add(SyntaxKind.POSITIONAL_ARG);
        this.supportedSyntax.add(SyntaxKind.NAMED_ARG);
        this.supportedSyntax.add(SyntaxKind.REST_ARG);
        this.supportedSyntax.add(SyntaxKind.OPEN_PAREN_TOKEN);
        this.supportedSyntax.add(SyntaxKind.CLOSE_PAREN_TOKEN);
    }

    private void addErrorConstructorExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.ERROR_CONSTRUCTOR);
    }

    private void addAnonymousFunctionExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.IMPLICIT_ANONYMOUS_FUNCTION_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.EXPLICIT_ANONYMOUS_FUNCTION_EXPRESSION);
    }

    private void addLetExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.LET_EXPRESSION);
    }

    private void addTypeCastExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.TYPE_CAST_EXPRESSION);
    }

    private void addTypeOfExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.TYPEOF_EXPRESSION);
    }

    private void addUnaryExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.UNARY_EXPRESSION);
    }

    private void addMultiplicativeExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.BINARY_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.ASTERISK_TOKEN);
        this.supportedSyntax.add(SyntaxKind.SLASH_TOKEN);
        this.supportedSyntax.add(SyntaxKind.PERCENT_TOKEN);
    }

    private void addAdditiveExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.BINARY_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.PLUS_TOKEN);
        this.supportedSyntax.add(SyntaxKind.MINUS_TOKEN);
    }

    private void addShiftExpressionSyntax() {
    }

    private void addRangeExpressionSyntax() {
    }

    private void addNumericalComparisonExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.BINARY_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.LT_TOKEN);
        this.supportedSyntax.add(SyntaxKind.LT_EQUAL_TOKEN);
        this.supportedSyntax.add(SyntaxKind.GT_TOKEN);
        this.supportedSyntax.add(SyntaxKind.GT_EQUAL_TOKEN);
    }

    private void addTypeTestExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.TYPE_TEST_EXPRESSION);
    }

    private void addEqualityExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.DOUBLE_EQUAL_TOKEN);
        this.supportedSyntax.add(SyntaxKind.NOT_EQUAL_TOKEN);
        this.supportedSyntax.add(SyntaxKind.TRIPPLE_EQUAL_TOKEN);
        this.supportedSyntax.add(SyntaxKind.NOT_DOUBLE_EQUAL_TOKEN);
    }

    private void addBinaryBitwiseExpressionSyntax() {
    }

    private void addLogicalExpressionSyntax() {
    }

    private void addConditionalExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.CONDITIONAL_EXPRESSION);
    }

    private void addCheckingExpressionSyntax() {
    }

    private void addTrapExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.TRAP_EXPRESSION);
    }

    private void addQueryExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.QUERY_EXPRESSION);
    }

    private void addXmlNavigationExpressionSyntax() {
        this.supportedSyntax.add(SyntaxKind.XML_FILTER_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.XML_STEP_EXPRESSION);
    }

    private void addRemoteMethodCallActionSyntax() {
        this.supportedSyntax.add(SyntaxKind.REMOTE_METHOD_CALL_ACTION);
    }

    private void addMiscellaneousSyntax() {
        this.supportedSyntax.add(SyntaxKind.RECORD_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.OBJECT_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.NIL_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.OPTIONAL_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.ARRAY_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.INT_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.BYTE_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.FLOAT_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.DECIMAL_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.STRING_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.BOOLEAN_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.XML_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.JSON_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.HANDLE_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.ANY_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.ANYDATA_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.NEVER_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.VAR_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.SERVICE_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.MAP_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.UNION_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.ERROR_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.STREAM_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.TABLE_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.FUNCTION_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.TUPLE_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.PARENTHESISED_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.READONLY_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.DISTINCT_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.INTERSECTION_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.SINGLETON_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.TYPE_REFERENCE_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.TYPEDESC_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.FUTURE_TYPE_DESC);
        this.supportedSyntax.add(SyntaxKind.BRACED_EXPRESSION);
        this.supportedSyntax.add(SyntaxKind.OPEN_PAREN_TOKEN);
        this.supportedSyntax.add(SyntaxKind.CLOSE_PAREN_TOKEN);
        this.supportedSyntax.add(SyntaxKind.IDENTIFIER_TOKEN);
        this.supportedSyntax.add(SyntaxKind.NONE);
        this.supportedSyntax.add(SyntaxKind.EOF_TOKEN);
    }

    private void clearState() {
        this.capturedSyntax.clear();
        this.unsupportedNodes.clear();
        this.result = null;
        this.builderException = null;
    }

    private List<Map.Entry<String, Evaluator>> processArgs(SeparatedNodeList<FunctionArgumentNode> args) throws EvaluationException {
        ArrayList<Map.Entry<String, Evaluator>> argEvaluators = new ArrayList<Map.Entry<String, Evaluator>>();
        block5: for (FunctionArgumentNode argExprNode : args) {
            argExprNode.accept((NodeVisitor)this);
            if (this.result == null) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INVALID_ARGUMENT, argExprNode);
            }
            switch (argExprNode.kind()) {
                case POSITIONAL_ARG: {
                    argEvaluators.add(new AbstractMap.SimpleEntry<String, Evaluator>("", this.result));
                    continue block5;
                }
                case NAMED_ARG: {
                    String namedArg = ((NamedArgumentNode)argExprNode).argumentName().name().toSourceCode();
                    argEvaluators.add(new AbstractMap.SimpleEntry<String, Evaluator>(namedArg.trim(), this.result));
                    continue block5;
                }
                case REST_ARG: {
                    argEvaluators.add(new AbstractMap.SimpleEntry<String, Evaluator>("...", this.result));
                    continue block5;
                }
            }
            this.builderException = EvaluationException.createEvaluationException(EvaluationExceptionKind.INVALID_ARGUMENT, argExprNode);
        }
        return argEvaluators;
    }
}

