/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation;

import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TreeModifier;
import io.ballerina.identifier.Utils;

public class IdentifierModifier
extends TreeModifier {
    public static final String QUOTED_IDENTIFIER_PREFIX = "'";

    public IdentifierToken transform(IdentifierToken identifier) {
        String identifierText = identifier.text();
        if (identifierText.startsWith(QUOTED_IDENTIFIER_PREFIX)) {
            identifierText = identifierText.substring(1);
        }
        String unescapedIdentifier = Utils.unescapeUnicodeCodepoints((String)identifierText);
        NonTerminalNode parent = identifier.parent();
        boolean isFunctionName = parent != null && (parent.kind() == SyntaxKind.FUNCTION_DEFINITION || parent.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION);
        return isFunctionName ? identifier.modify(IdentifierModifier.encodeIdentifier(unescapedIdentifier, IdentifierType.METHOD_NAME)) : identifier.modify(IdentifierModifier.encodeIdentifier(unescapedIdentifier, IdentifierType.OTHER));
    }

    public static String encodeModuleName(String identifier) {
        return IdentifierModifier.encodeIdentifier(identifier, IdentifierType.OTHER);
    }

    public static String encodeIdentifier(String identifier, IdentifierType type) {
        if (identifier.startsWith(QUOTED_IDENTIFIER_PREFIX)) {
            identifier = identifier.substring(1);
        }
        identifier = Utils.unescapeUnicodeCodepoints((String)identifier);
        return type == IdentifierType.METHOD_NAME ? Utils.encodeFunctionIdentifier((String)identifier) : Utils.encodeNonFunctionIdentifier((String)identifier);
    }

    public static String decodeIdentifier(String encodedIdentifier) {
        return Utils.decodeIdentifier((String)encodedIdentifier);
    }

    public static String decodeAndEscapeIdentifier(String encodedIdentifier) {
        Object decodedIdentifier = IdentifierModifier.decodeIdentifier(encodedIdentifier);
        if (!((String)(decodedIdentifier = Utils.escapeSpecialCharacters((String)decodedIdentifier))).startsWith(QUOTED_IDENTIFIER_PREFIX)) {
            decodedIdentifier = QUOTED_IDENTIFIER_PREFIX + (String)decodedIdentifier;
        }
        return decodedIdentifier;
    }

    public static enum IdentifierType {
        METHOD_NAME,
        OTHER;

    }
}

