/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import io.ballerina.compiler.syntax.tree.AnnotAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BracedExpressionNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ErrorBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ErrorConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternFullNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternVarnameNode;
import io.ballerina.compiler.syntax.tree.FromClauseNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.IndexedExpressionNode;
import io.ballerina.compiler.syntax.tree.InterpolationNode;
import io.ballerina.compiler.syntax.tree.JoinClauseNode;
import io.ballerina.compiler.syntax.tree.LetClauseNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.LimitClauseNode;
import io.ballerina.compiler.syntax.tree.ListBindingPatternNode;
import io.ballerina.compiler.syntax.tree.MappingBindingPatternNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.OnConflictClauseNode;
import io.ballerina.compiler.syntax.tree.OptionalFieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QueryExpressionNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestArgumentNode;
import io.ballerina.compiler.syntax.tree.RestBindingPatternNode;
import io.ballerina.compiler.syntax.tree.RestParameterNode;
import io.ballerina.compiler.syntax.tree.SelectClauseNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TrapExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.TypeofExpressionNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.WhereClauseNode;
import io.ballerina.compiler.syntax.tree.XMLFilterExpressionNode;
import io.ballerina.compiler.syntax.tree.XMLStepExpressionNode;
import java.util.HashSet;
import java.util.Set;

public class ExternalVariableReferenceFinder
extends NodeVisitor {
    private final ExpressionNode expressionNode;
    private final Set<String> internalVariables = new HashSet<String>();
    private final Set<String> capturedVariables = new HashSet<String>();

    public ExternalVariableReferenceFinder(ExpressionNode node) {
        this.expressionNode = node;
    }

    public Set<String> getCapturedVariables() {
        this.expressionNode.accept((NodeVisitor)this);
        return this.capturedVariables;
    }

    public void visit(FromClauseNode fromClauseNode) {
        fromClauseNode.typedBindingPattern().accept((NodeVisitor)this);
        fromClauseNode.expression().accept((NodeVisitor)this);
    }

    public void visit(WhereClauseNode whereClauseNode) {
        whereClauseNode.expression().accept((NodeVisitor)this);
    }

    public void visit(JoinClauseNode joinClauseNode) {
        joinClauseNode.typedBindingPattern().accept((NodeVisitor)this);
        joinClauseNode.expression().accept((NodeVisitor)this);
    }

    public void visit(LetClauseNode letClauseNode) {
        letClauseNode.letVarDeclarations().forEach(declaration -> {
            declaration.typedBindingPattern().accept((NodeVisitor)this);
            declaration.expression().accept((NodeVisitor)this);
        });
    }

    public void visit(LimitClauseNode limitClauseNode) {
        limitClauseNode.expression().accept((NodeVisitor)this);
    }

    public void visit(SelectClauseNode selectClauseNode) {
        selectClauseNode.expression().accept((NodeVisitor)this);
    }

    public void visit(OnConflictClauseNode onConflictClauseNode) {
        onConflictClauseNode.expression().accept((NodeVisitor)this);
    }

    public void visit(BracedExpressionNode bracedExpressionNode) {
        bracedExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(BinaryExpressionNode binaryExpressionNode) {
        binaryExpressionNode.lhsExpr().accept((NodeVisitor)this);
        binaryExpressionNode.rhsExpr().accept((NodeVisitor)this);
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        functionCallExpressionNode.arguments().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        methodCallExpressionNode.expression().accept((NodeVisitor)this);
        methodCallExpressionNode.arguments().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(ErrorConstructorExpressionNode errorConstructorExpressionNode) {
        errorConstructorExpressionNode.arguments().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(FieldAccessExpressionNode fieldAccessExpressionNode) {
        fieldAccessExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(OptionalFieldAccessExpressionNode optionalFieldAccessExpressionNode) {
        optionalFieldAccessExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(ConditionalExpressionNode conditionalExpressionNode) {
        conditionalExpressionNode.lhsExpression().accept((NodeVisitor)this);
        conditionalExpressionNode.middleExpression().accept((NodeVisitor)this);
        conditionalExpressionNode.endExpression().accept((NodeVisitor)this);
    }

    public void visit(TypeofExpressionNode typeofExpressionNode) {
        typeofExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(IndexedExpressionNode indexedExpressionNode) {
        indexedExpressionNode.containerExpression().accept((NodeVisitor)this);
        indexedExpressionNode.keyExpression().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(TypeTestExpressionNode typeTestExpressionNode) {
        typeTestExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(TypeCastExpressionNode typeCastExpressionNode) {
        typeCastExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(AnnotAccessExpressionNode annotAccessExpressionNode) {
        annotAccessExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(TemplateExpressionNode templateExpressionNode) {
        this.visitSyntaxNode((Node)templateExpressionNode);
    }

    public void visit(InterpolationNode interpolationNode) {
        interpolationNode.expression().accept((NodeVisitor)this);
    }

    public void visit(XMLStepExpressionNode xmlStepExpressionNode) {
        xmlStepExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(XMLFilterExpressionNode xmlFilterExpressionNode) {
        xmlFilterExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(TrapExpressionNode trapExpressionNode) {
        trapExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(UnaryExpressionNode unaryExpressionNode) {
        unaryExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
        explicitNewExpressionNode.parenthesizedArgList().arguments().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
        implicitNewExpressionNode.parenthesizedArgList().ifPresent(parenthesizedArgList -> parenthesizedArgList.arguments().forEach(node -> node.accept((NodeVisitor)this)));
    }

    public void visit(QueryExpressionNode queryExpressionNode) {
        this.visitSyntaxNode((Node)queryExpressionNode);
    }

    public void visit(LetExpressionNode letExpressionNode) {
        letExpressionNode.letVarDeclarations().forEach(declarationNode -> declarationNode.accept((NodeVisitor)this));
        letExpressionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(ImplicitAnonymousFunctionExpressionNode anonFunctionNode) {
        anonFunctionNode.params().accept((NodeVisitor)this);
        anonFunctionNode.expression().accept((NodeVisitor)this);
    }

    public void visit(ExplicitAnonymousFunctionExpressionNode anonFunctionNode) {
        anonFunctionNode.functionSignature().parameters().forEach(parameterNode -> parameterNode.accept((NodeVisitor)this));
        anonFunctionNode.functionBody().accept((NodeVisitor)this);
    }

    public void visit(PositionalArgumentNode positionalArgumentNode) {
        positionalArgumentNode.expression().accept((NodeVisitor)this);
    }

    public void visit(NamedArgumentNode namedArgumentNode) {
        namedArgumentNode.expression().accept((NodeVisitor)this);
    }

    public void visit(RestArgumentNode restArgumentNode) {
        restArgumentNode.expression().accept((NodeVisitor)this);
    }

    public void visit(DefaultableParameterNode defaultableParameterNode) {
        if (defaultableParameterNode.paramName().isPresent()) {
            this.internalVariables.add(((Token)defaultableParameterNode.paramName().get()).text().trim());
        }
    }

    public void visit(RequiredParameterNode requiredParameterNode) {
        if (requiredParameterNode.paramName().isPresent()) {
            this.internalVariables.add(((Token)requiredParameterNode.paramName().get()).text().trim());
        }
    }

    public void visit(IncludedRecordParameterNode includedRecordParameterNode) {
        if (includedRecordParameterNode.paramName().isPresent()) {
            this.internalVariables.add(((Token)includedRecordParameterNode.paramName().get()).text().trim());
        }
    }

    public void visit(RestParameterNode restParameterNode) {
        if (restParameterNode.paramName().isPresent()) {
            this.internalVariables.add(((Token)restParameterNode.paramName().get()).text().trim());
        }
    }

    public void visit(TypedBindingPatternNode typedBindingPatternNode) {
        typedBindingPatternNode.bindingPattern().accept((NodeVisitor)this);
    }

    public void visit(CaptureBindingPatternNode captureBindingPatternNode) {
        this.internalVariables.add(captureBindingPatternNode.variableName().text().trim());
    }

    public void visit(ListBindingPatternNode listBindingPatternNode) {
        listBindingPatternNode.bindingPatterns().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(MappingBindingPatternNode mappingBindingPatternNode) {
        mappingBindingPatternNode.fieldBindingPatterns().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(FieldBindingPatternFullNode fieldBindingPatternFullNode) {
        fieldBindingPatternFullNode.bindingPattern().accept((NodeVisitor)this);
    }

    public void visit(FieldBindingPatternVarnameNode fieldBindingPatternVarnameNode) {
        this.internalVariables.add(fieldBindingPatternVarnameNode.variableName().name().text().trim());
    }

    public void visit(RestBindingPatternNode restBindingPatternNode) {
        this.internalVariables.add(restBindingPatternNode.variableName().name().text().trim());
    }

    public void visit(ErrorBindingPatternNode errorBindingPatternNode) {
        errorBindingPatternNode.argListBindingPatterns().forEach(node -> node.accept((NodeVisitor)this));
    }

    public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
        String variableRef = simpleNameReferenceNode.name().text().trim();
        if (!this.internalVariables.contains(variableRef)) {
            this.capturedVariables.add(variableRef);
        }
    }
}

