/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.debugadapter.SuspendedContext;

public class ModuleLevelDefinitionFinder
extends NodeVisitor {
    private final SuspendedContext context;
    private final Set<SyntaxKind> filters = new HashSet<SyntaxKind>();
    private final List<NonTerminalNode> result = new ArrayList<NonTerminalNode>();
    private static final String ANNOTATION_BUILTINSUBTYPE = "builtinSubtype";

    public ModuleLevelDefinitionFinder(SuspendedContext context) {
        this.context = context;
    }

    public void addInclusiveFilter(SyntaxKind topLevelNodeKind) {
        this.filters.add(topLevelNodeKind);
    }

    public List<NonTerminalNode> getCurrentModuleDeclarations() {
        return this.getModuleDeclarations(this.context.getModule());
    }

    public List<NonTerminalNode> getModuleDeclarations(Module module) {
        for (DocumentId documentId : module.documentIds()) {
            this.searchInFile(module.document(documentId));
        }
        return this.result;
    }

    private void searchInFile(Document document) {
        if (!document.syntaxTree().containsModulePart()) {
            return;
        }
        ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
        modulePartNode.imports().forEach(this::visitSyntaxNode);
        modulePartNode.members().forEach(this::visitSyntaxNode);
    }

    protected void visitSyntaxNode(Node node) {
        TypeDefinitionNode typeDefinitionNode;
        FunctionDefinitionNode functionDefinitionNode;
        if (!this.filters.contains(node.kind()) || node instanceof Token) {
            return;
        }
        if (!(node instanceof ImportDeclarationNode) && !(node instanceof ModuleMemberDeclarationNode)) {
            return;
        }
        if (node instanceof FunctionDefinitionNode && (functionDefinitionNode = (FunctionDefinitionNode)node).functionName().toSourceCode().equals("main")) {
            return;
        }
        if (node instanceof FunctionDefinitionNode && (functionDefinitionNode = (FunctionDefinitionNode)node).functionBody().kind() == SyntaxKind.EXTERNAL_FUNCTION_BODY) {
            return;
        }
        if (node instanceof TypeDefinitionNode && (typeDefinitionNode = (TypeDefinitionNode)node).metadata().isPresent() && ((MetadataNode)typeDefinitionNode.metadata().get()).annotations().stream().anyMatch(annotationNode -> annotationNode.annotReference().toSourceCode().trim().equalsIgnoreCase(ANNOTATION_BUILTINSUBTYPE))) {
            return;
        }
        this.result.add((NonTerminalNode)node);
    }
}

