/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine;

import com.sun.jdi.Method;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.InvocationArgProcessor;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;
import org.ballerinalang.debugadapter.variable.BVariableType;

public class SymbolBasedArgProcessor
extends InvocationArgProcessor {
    private final FunctionSymbol definitionSymbol;
    private final FunctionTypeSymbol definitionTypeSymbol;

    public SymbolBasedArgProcessor(SuspendedContext context, String functionName, Method jdiMethodReference, FunctionSymbol definitionSymbol) {
        super(context, functionName, jdiMethodReference);
        this.definitionSymbol = definitionSymbol;
        this.definitionTypeSymbol = definitionSymbol.typeDescriptor();
    }

    @Override
    public List<Value> process(List<Map.Entry<String, Evaluator>> argEvaluators) throws EvaluationException {
        Optional restParamSymbol;
        boolean namedArgsFound = false;
        boolean restArgsFound = false;
        boolean restArgsProcessed = false;
        Value restArrayType = null;
        String restParamName = null;
        String restParamTypeName = null;
        ArrayList<Value> restValues = new ArrayList<Value>();
        ArrayList<ParameterSymbol> params = new ArrayList<ParameterSymbol>();
        LinkedHashMap<String, ParameterSymbol> remainingParams = new LinkedHashMap<String, ParameterSymbol>();
        Optional parameterSymbols = this.definitionTypeSymbol.params();
        if (parameterSymbols.isPresent()) {
            for (ParameterSymbol parameterSymbol : (List)parameterSymbols.get()) {
                params.add(parameterSymbol);
                remainingParams.put(parameterSymbol.getName().orElse("unknown"), parameterSymbol);
            }
        }
        if ((restParamSymbol = this.definitionTypeSymbol.restParam()).isPresent()) {
            ParameterSymbol restParam = (ParameterSymbol)restParamSymbol.get();
            params.add(restParam);
            remainingParams.put(restParam.getName().orElse("unknown"), restParam);
        }
        HashMap<String, Value> argValues = new HashMap<String, Value>();
        int paramIndex = 0;
        for (int argIndex = 0; argIndex < argEvaluators.size(); ++argIndex) {
            Map.Entry<String, Evaluator> arg = argEvaluators.get(argIndex);
            InvocationArgProcessor.ArgType argType = SymbolBasedArgProcessor.getArgType(arg);
            if (argType == InvocationArgProcessor.ArgType.POSITIONAL) {
                if (namedArgsFound) {
                    throw EvaluationException.createEvaluationException("positional args are not allowed after named args.");
                }
                if (remainingParams.isEmpty() && !restArgsFound) {
                    throw EvaluationException.createEvaluationException("too many arguments in call to '" + this.functionName + "'.");
                }
                BExpressionValue argValue = arg.getValue().evaluate();
                Value jdiArgValue = argValue.getJdiValue();
                if (((ParameterSymbol)params.get(paramIndex)).typeDescriptor().signature().equals(BVariableType.ANY.getString())) {
                    jdiArgValue = EvaluationUtils.getValueAsObject(this.context, jdiArgValue);
                }
                if (((ParameterSymbol)params.get(paramIndex)).paramKind() == ParameterKind.REST) {
                    Value elementType;
                    for (Map.Entry entry : remainingParams.entrySet()) {
                        ParameterKind parameterType = ((ParameterSymbol)entry.getValue()).paramKind();
                        if (parameterType != ParameterKind.REST) continue;
                        restParamName = (String)entry.getKey();
                        restParamTypeName = ((ParameterSymbol)entry.getValue()).typeDescriptor().signature();
                        break;
                    }
                    if (restParamName == null) {
                        throw EvaluationException.createEvaluationException("undefined rest parameter.");
                    }
                    if (!restArgsFound) {
                        restArrayType = SymbolBasedArgProcessor.resolveType(this.context, restParamTypeName);
                        restArgsFound = true;
                    }
                    if (!EvaluationUtils.checkIsType(this.context, jdiArgValue, elementType = SymbolBasedArgProcessor.getElementType(this.context, restArrayType))) {
                        throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_MISMATCH, restParamTypeName.replaceAll("\\[]$", ""), argValue.getType().getString(), restParamName);
                    }
                    restValues.add(jdiArgValue);
                    remainingParams.remove(restParamName);
                    continue;
                }
                String parameterName = ((ParameterSymbol)params.get(paramIndex)).getName().orElse("unknown");
                argValues.put(parameterName, jdiArgValue);
                remainingParams.remove(parameterName);
                ++paramIndex;
                continue;
            }
            if (argType == InvocationArgProcessor.ArgType.NAMED) {
                if (restArgsFound) {
                    throw EvaluationException.createEvaluationException("named args are not allowed after rest args.");
                }
                String argName = arg.getKey();
                if (!remainingParams.containsKey(argName)) {
                    throw EvaluationException.createEvaluationException("undefined parameter '" + argName + "'.");
                }
                namedArgsFound = true;
                Value argValue = arg.getValue().evaluate().getJdiValue();
                if (((ParameterSymbol)params.get(paramIndex)).typeDescriptor().signature().equals(BVariableType.ANY.getString())) {
                    argValue = EvaluationUtils.getValueAsObject(this.context, argValue);
                }
                argValues.put(argName, argValue);
                remainingParams.remove(argName);
                ++paramIndex;
                continue;
            }
            if (argType != InvocationArgProcessor.ArgType.REST) continue;
            if (namedArgsFound) {
                throw EvaluationException.createEvaluationException("rest args are not allowed after named args.");
            }
            for (Map.Entry entry : remainingParams.entrySet()) {
                ParameterKind parameterType = ((ParameterSymbol)entry.getValue()).paramKind();
                if (parameterType != ParameterKind.REST) continue;
                restParamName = (String)entry.getKey();
                restParamTypeName = ((ParameterSymbol)entry.getValue()).typeDescriptor().signature();
                break;
            }
            if (restParamName == null) {
                throw EvaluationException.createEvaluationException("undefined rest parameter.");
            }
            restArgsFound = true;
            argValues.put(restParamName, arg.getValue().evaluate().getJdiValue());
            remainingParams.remove(restParamName);
            restArgsProcessed = true;
            ++paramIndex;
        }
        for (Map.Entry entry : remainingParams.entrySet()) {
            String paramName = (String)entry.getKey();
            ParameterKind parameterType = ((ParameterSymbol)entry.getValue()).paramKind();
            if (parameterType == ParameterKind.REQUIRED) {
                throw EvaluationException.createEvaluationException("missing required parameter '" + paramName + "'.");
            }
            if (parameterType == ParameterKind.DEFAULTABLE) {
                argValues.put(paramName + "[Defaultable]", VMUtils.make(this.context, 0).getJdiValue());
                continue;
            }
            if (parameterType != ParameterKind.REST) continue;
            restParamTypeName = ((ParameterSymbol)entry.getValue()).typeDescriptor().signature();
            restArrayType = SymbolBasedArgProcessor.resolveType(this.context, restParamTypeName);
            argValues.put(paramName, SymbolBasedArgProcessor.getRestArgArray(this.context, SymbolBasedArgProcessor.getElementType(this.context, restArrayType), new Value[0]));
            restArgsProcessed = true;
        }
        if (restArgsFound && !restArgsProcessed) {
            argValues.put(restParamName, SymbolBasedArgProcessor.getRestArgArray(this.context, restArrayType, restValues.toArray(new Value[0])));
        }
        return this.getOrderedArgList(argValues, this.definitionSymbol, null);
    }
}

