/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.action;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.ClassDefinitionResolver;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.SymbolBasedArgProcessor;
import org.ballerinalang.debugadapter.evaluation.engine.expression.MethodCallExpressionEvaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedInstanceMethod;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.VariableFactory;

public class RemoteMethodCallActionEvaluator
extends MethodCallExpressionEvaluator {
    private final RemoteMethodCallActionNode syntaxNode;
    private final String methodName;
    private final Evaluator subExpressionEvaluator;
    private final List<Map.Entry<String, Evaluator>> argEvaluators;

    public RemoteMethodCallActionEvaluator(EvaluationContext context, RemoteMethodCallActionNode remoteMethodActionNode, Evaluator expression, List<Map.Entry<String, Evaluator>> argEvaluators) {
        super(context, null, expression, argEvaluators);
        this.syntaxNode = remoteMethodActionNode;
        this.subExpressionEvaluator = expression;
        this.argEvaluators = argEvaluators;
        this.methodName = this.syntaxNode.methodName().toSourceCode().trim();
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue subExprResult = this.subExpressionEvaluator.evaluate();
            BVariable resultVar = VariableFactory.getVariable(this.context, subExprResult.getJdiValue());
            if (subExprResult.getType() != BVariableType.CLIENT_OBJECT) {
                throw EvaluationException.createEvaluationException("invalid remote method call: expected a client object, but found 'other'");
            }
            Value invocationResult = this.invokeRemoteMethod(resultVar);
            return new BExpressionValue(this.context, invocationResult);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private Value invokeRemoteMethod(BVariable resultVar) throws EvaluationException {
        ClassDefinitionResolver classDefResolver = new ClassDefinitionResolver(this.context);
        String className = resultVar.getDapVariable().getValue();
        Optional<ClassSymbol> classDef = classDefResolver.findBalClassDefWithinModule(className);
        if (classDef.isEmpty()) {
            String signature = resultVar.getJvmValue().type().signature();
            if (!signature.startsWith("L")) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_NOT_FOUND, className);
            }
            String[] signatureParts = signature.substring(1).split("/");
            if (signatureParts.length < 2) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_NOT_FOUND, className);
            }
            String orgName = signatureParts[0];
            String packageName = signatureParts[1];
            classDef = classDefResolver.findBalClassDefWithinDependencies(orgName, packageName, className);
        }
        if (classDef.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_NOT_FOUND, className);
        }
        Optional<MethodSymbol> objectMethodDef = this.findObjectMethodInClass(classDef.get(), this.methodName);
        if (objectMethodDef.isEmpty()) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.REMOTE_METHOD_NOT_FOUND, this.syntaxNode.methodName().toString().trim(), className);
        }
        GeneratedInstanceMethod objectMethod = this.getRemoteMethodByName(resultVar, objectMethodDef.get());
        SymbolBasedArgProcessor argProcessor = new SymbolBasedArgProcessor(this.context, this.methodName, objectMethod.getJDIMethodRef(), (FunctionSymbol)objectMethodDef.get());
        List<Value> orderedArgsList = argProcessor.process(this.argEvaluators);
        objectMethod.setArgValues(orderedArgsList);
        return objectMethod.invokeSafely();
    }

    private GeneratedInstanceMethod getRemoteMethodByName(BVariable objectVar, MethodSymbol methodDefinition) throws EvaluationException {
        try {
            ReferenceType objectRef = ((ObjectReference)objectVar.getJvmValue()).referenceType();
            int argsCountInDefinition = ((List)methodDefinition.typeDescriptor().params().get()).size() + (methodDefinition.typeDescriptor().restParam().isPresent() ? 1 : 0);
            List<Method> methods = objectRef.methodsByName(this.methodName);
            for (Method method : methods) {
                int expectedArgsCountInRuntime = argsCountInDefinition + 1;
                if (method.argumentTypes().size() != expectedArgsCountInRuntime) continue;
                return new GeneratedInstanceMethod(this.context, objectVar.getJvmValue(), methods.get(0));
            }
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.REMOTE_METHOD_NOT_FOUND, this.syntaxNode.methodName().toString().trim(), objectVar.computeValue());
        }
        catch (ClassNotLoadedException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.REMOTE_METHOD_NOT_FOUND, this.syntaxNode.methodName().toString().trim(), objectVar.computeValue());
        }
    }
}

