/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;

public class BasicLiteralEvaluator
extends Evaluator {
    private final Node syntaxNode;
    private final String literalString;
    private static final String HEX_INDICATOR_PREFIX_PATTERN = "0[xX]";
    private static final String FLOAT_TYPE_SUFFIX_PATTERN = "[fF]$";
    private static final String DECIMAL_TYPE_SUFFIX_PATTERN = "[dD]$";

    public BasicLiteralEvaluator(EvaluationContext context, BasicLiteralNode node) {
        this(context, (Node)node, node.literalToken().text());
    }

    public BasicLiteralEvaluator(EvaluationContext context, NilLiteralNode node) {
        this(context, (Node)node, node.toSourceCode().trim());
    }

    public BasicLiteralEvaluator(EvaluationContext context, Token node) {
        this(context, (Node)node, node.text());
    }

    private BasicLiteralEvaluator(EvaluationContext context, Node node, String literalString) {
        super(context);
        this.syntaxNode = node;
        this.literalString = literalString;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            SyntaxKind basicLiteralKind = this.syntaxNode.kind();
            return switch (basicLiteralKind) {
                case SyntaxKind.NIL_LITERAL -> new BExpressionValue(this.context, null);
                case SyntaxKind.NUMERIC_LITERAL -> this.parseAndGetNumericValue(this.literalString.trim());
                case SyntaxKind.BOOLEAN_LITERAL -> VMUtils.make(this.context, Boolean.parseBoolean(this.literalString.trim()));
                case SyntaxKind.STRING_LITERAL, SyntaxKind.TEMPLATE_STRING -> VMUtils.make(this.context, this.literalString);
                default -> throw BasicLiteralEvaluator.createUnsupportedLiteralError(this.literalString);
            };
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private BExpressionValue parseAndGetNumericValue(String literalString) throws EvaluationException {
        switch (((BasicLiteralNode)this.syntaxNode).literalToken().kind()) {
            case DECIMAL_INTEGER_LITERAL_TOKEN: {
                return VMUtils.make(this.context, Long.parseLong(literalString));
            }
            case HEX_INTEGER_LITERAL_TOKEN: {
                String withoutHexIndicator = literalString.replaceFirst(HEX_INDICATOR_PREFIX_PATTERN, "");
                return VMUtils.make(this.context, Long.parseLong(withoutHexIndicator, 16));
            }
            case DECIMAL_FLOATING_POINT_LITERAL_TOKEN: {
                if (BasicLiteralEvaluator.isDecimalType(literalString)) {
                    String stringWithoutSuffix = literalString.replaceAll(DECIMAL_TYPE_SUFFIX_PATTERN, "");
                    return new BExpressionValue(this.context, this.createDecimalValueFrom(stringWithoutSuffix));
                }
                String stringWithoutSuffix = literalString.replaceAll(FLOAT_TYPE_SUFFIX_PATTERN, "");
                return VMUtils.make(this.context, Double.parseDouble(stringWithoutSuffix));
            }
            case HEX_FLOATING_POINT_LITERAL_TOKEN: {
                throw BasicLiteralEvaluator.createUnsupportedLiteralError(literalString);
            }
        }
        throw BasicLiteralEvaluator.createUnsupportedLiteralError(literalString);
    }

    private Value createDecimalValueFrom(String decimalValueString) throws EvaluationException {
        RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.api.creators.ValueCreator", "createDecimalValue", Collections.singletonList("java.lang.String"));
        method.setArgValues(Collections.singletonList(EvaluationUtils.getAsJString(this.context, decimalValueString)));
        return method.invokeSafely();
    }

    private static boolean isDecimalType(String literalString) {
        Pattern pattern = Pattern.compile(DECIMAL_TYPE_SUFFIX_PATTERN);
        Matcher matcher = pattern.matcher(literalString);
        return matcher.find();
    }

    private static EvaluationException createUnsupportedLiteralError(String literalString) {
        return EvaluationException.createEvaluationException("Unsupported basic literal detected: " + literalString);
    }
}

