/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedStaticMethod;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.VMUtils;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.VariableFactory;

public class BinaryExpressionEvaluator
extends Evaluator {
    protected final BinaryExpressionNode syntaxNode;
    protected final Evaluator lhsEvaluator;
    protected final Evaluator rhsEvaluator;

    public BinaryExpressionEvaluator(EvaluationContext context, BinaryExpressionNode node, Evaluator lhsEvaluator, Evaluator rhsEvaluator) {
        super(context);
        this.syntaxNode = node;
        this.lhsEvaluator = lhsEvaluator;
        this.rhsEvaluator = rhsEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue lhsResult = this.lhsEvaluator.evaluate();
            BExpressionValue rhsResult = this.rhsEvaluator.evaluate();
            return this.performOperation(lhsResult, rhsResult);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private BExpressionValue performOperation(BExpressionValue lhs, BExpressionValue rhs) throws EvaluationException {
        Value lValue = lhs.getJdiValue();
        Value rValue = rhs.getJdiValue();
        BVariable lVar = VariableFactory.getVariable(this.context, lValue);
        BVariable rVar = VariableFactory.getVariable(this.context, rValue);
        SyntaxKind operatorType = this.syntaxNode.operator().kind();
        return switch (operatorType) {
            case SyntaxKind.PLUS_TOKEN, SyntaxKind.MINUS_TOKEN, SyntaxKind.ASTERISK_TOKEN, SyntaxKind.SLASH_TOKEN, SyntaxKind.PERCENT_TOKEN -> this.performArithmeticOperation(lVar, rVar, operatorType);
            case SyntaxKind.LT_TOKEN, SyntaxKind.GT_TOKEN, SyntaxKind.LT_EQUAL_TOKEN, SyntaxKind.GT_EQUAL_TOKEN -> this.compare(lVar, rVar, operatorType);
            case SyntaxKind.BITWISE_AND_TOKEN, SyntaxKind.PIPE_TOKEN, SyntaxKind.BITWISE_XOR_TOKEN -> this.performBitwiseOperation(lVar, rVar, operatorType);
            case SyntaxKind.DOUBLE_LT_TOKEN, SyntaxKind.DOUBLE_GT_TOKEN, SyntaxKind.TRIPPLE_GT_TOKEN -> this.performShiftOperation(lVar, rVar, operatorType);
            case SyntaxKind.LOGICAL_AND_TOKEN, SyntaxKind.LOGICAL_OR_TOKEN -> this.performLogicalOperation(lVar, rVar, operatorType);
            case SyntaxKind.ELVIS_TOKEN -> this.conditionalReturn(lVar, rVar);
            case SyntaxKind.DOUBLE_EQUAL_TOKEN, SyntaxKind.NOT_EQUAL_TOKEN -> this.checkValueEquality(lVar, rVar, operatorType);
            case SyntaxKind.TRIPPLE_EQUAL_TOKEN, SyntaxKind.NOT_DOUBLE_EQUAL_TOKEN -> this.checkReferenceEquality(lVar, rVar, operatorType);
            default -> throw this.createUnsupportedOperationException(lVar, rVar, operatorType);
        };
    }

    private BExpressionValue performArithmeticOperation(BVariable lVar, BVariable rVar, SyntaxKind operator) throws EvaluationException {
        if (lVar.getBType() == BVariableType.XML && rVar.getBType() == BVariableType.XML && operator == SyntaxKind.PLUS_TOKEN) {
            ArrayList<Value> argList = new ArrayList<Value>();
            argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
            argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
            ArrayList<String> argTypeNames = new ArrayList<String>();
            argTypeNames.add("io.ballerina.runtime.internal.values.XmlValue");
            argTypeNames.add("io.ballerina.runtime.internal.values.XmlValue");
            RuntimeStaticMethod runtimeMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.internal.xml.XmlFactory", "concatenate", argTypeNames);
            runtimeMethod.setArgValues(argList);
            Value result = runtimeMethod.invokeSafely();
            return new BExpressionValue(this.context, result);
        }
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
        argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
        GeneratedStaticMethod genMethod = switch (operator) {
            case SyntaxKind.PLUS_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.arithmetic_operations", "add");
            case SyntaxKind.MINUS_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.arithmetic_operations", "subtract");
            case SyntaxKind.ASTERISK_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.arithmetic_operations", "multiply");
            case SyntaxKind.SLASH_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.arithmetic_operations", "divide");
            case SyntaxKind.PERCENT_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.arithmetic_operations", "modulus");
            default -> throw this.createUnsupportedOperationException(lVar, rVar, operator);
        };
        genMethod.setArgValues(argList);
        Value result = genMethod.invokeSafely();
        return new BExpressionValue(this.context, result);
    }

    private BExpressionValue compare(BVariable lVar, BVariable rVar, SyntaxKind operator) throws EvaluationException {
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
        argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
        GeneratedStaticMethod genMethod = switch (operator) {
            case SyntaxKind.LT_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.relational_operations", "lessThan");
            case SyntaxKind.LT_EQUAL_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.relational_operations", "lessThanOrEquals");
            case SyntaxKind.GT_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.relational_operations", "greaterThan");
            case SyntaxKind.GT_EQUAL_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.relational_operations", "greaterThanOrEquals");
            default -> throw this.createUnsupportedOperationException(lVar, rVar, operator);
        };
        genMethod.setArgValues(argList);
        Value result = genMethod.invokeSafely();
        return new BExpressionValue(this.context, result);
    }

    private BExpressionValue performBitwiseOperation(BVariable lVar, BVariable rVar, SyntaxKind operator) throws EvaluationException {
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
        argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
        GeneratedStaticMethod genMethod = switch (operator) {
            case SyntaxKind.BITWISE_AND_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.bitwise_operations", "bitwiseAND");
            case SyntaxKind.PIPE_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.bitwise_operations", "bitwiseOR");
            case SyntaxKind.BITWISE_XOR_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.bitwise_operations", "bitwiseXOR");
            default -> throw this.createUnsupportedOperationException(lVar, rVar, operator);
        };
        genMethod.setArgValues(argList);
        Value result = genMethod.invokeSafely();
        return new BExpressionValue(this.context, result);
    }

    private BExpressionValue performShiftOperation(BVariable lVar, BVariable rVar, SyntaxKind operator) throws EvaluationException {
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
        argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
        GeneratedStaticMethod genMethod = switch (operator) {
            case SyntaxKind.DOUBLE_LT_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.shift_operations", "leftShift");
            case SyntaxKind.DOUBLE_GT_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.shift_operations", "signedRightShift");
            case SyntaxKind.TRIPPLE_GT_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.shift_operations", "unsignedRightShift");
            default -> throw this.createUnsupportedOperationException(lVar, rVar, operator);
        };
        genMethod.setArgValues(argList);
        Value result = genMethod.invokeSafely();
        return new BExpressionValue(this.context, result);
    }

    private BExpressionValue performLogicalOperation(BVariable lVar, BVariable rVar, SyntaxKind operator) throws EvaluationException {
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
        argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
        GeneratedStaticMethod genMethod = switch (operator) {
            case SyntaxKind.LOGICAL_AND_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.logical_operations", "logicalAND");
            case SyntaxKind.LOGICAL_OR_TOKEN -> EvaluationUtils.getGeneratedMethod(this.context, "ballerina.debugger_helpers.1.logical_operations", "logicalOR");
            default -> throw this.createUnsupportedOperationException(lVar, rVar, operator);
        };
        genMethod.setArgValues(argList);
        Value result = genMethod.invokeSafely();
        return new BExpressionValue(this.context, result);
    }

    private BExpressionValue conditionalReturn(BVariable lVar, BVariable rVar) {
        if (lVar.getBType() != BVariableType.NIL) {
            return new BExpressionValue(this.context, lVar.getJvmValue());
        }
        return new BExpressionValue(this.context, rVar.getJvmValue());
    }

    private BExpressionValue checkValueEquality(BVariable lVar, BVariable rVar, SyntaxKind operatorType) throws EvaluationException {
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
        argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
        ArrayList<String> argTypeNames = new ArrayList<String>();
        argTypeNames.add("java.lang.Object");
        argTypeNames.add("java.lang.Object");
        RuntimeStaticMethod runtimeMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.internal.TypeChecker", "isEqual", argTypeNames);
        runtimeMethod.setArgValues(argList);
        Value result = runtimeMethod.invokeSafely();
        BVariable variable = VariableFactory.getVariable(this.context, result);
        boolean booleanValue = Boolean.parseBoolean(variable.getDapVariable().getValue());
        booleanValue = operatorType == SyntaxKind.DOUBLE_EQUAL_TOKEN ? booleanValue : !booleanValue;
        return VMUtils.make(this.context, booleanValue);
    }

    private BExpressionValue checkReferenceEquality(BVariable lVar, BVariable rVar, SyntaxKind operatorType) throws EvaluationException {
        ArrayList<Value> argList = new ArrayList<Value>();
        argList.add(EvaluationUtils.getValueAsObject(this.context, lVar));
        argList.add(EvaluationUtils.getValueAsObject(this.context, rVar));
        ArrayList<String> argTypeNames = new ArrayList<String>();
        argTypeNames.add("java.lang.Object");
        argTypeNames.add("java.lang.Object");
        RuntimeStaticMethod runtimeMethod = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.internal.TypeChecker", "isReferenceEqual", argTypeNames);
        runtimeMethod.setArgValues(argList);
        Value result = runtimeMethod.invokeSafely();
        BVariable variable = VariableFactory.getVariable(this.context, result);
        boolean booleanValue = Boolean.parseBoolean(variable.getDapVariable().getValue());
        booleanValue = operatorType == SyntaxKind.TRIPPLE_EQUAL_TOKEN ? booleanValue : !booleanValue;
        return VMUtils.make(this.context, booleanValue);
    }

    protected EvaluationException createUnsupportedOperationException(BVariable lVar, BVariable rVar, SyntaxKind operator) {
        return EvaluationException.createEvaluationException(EvaluationExceptionKind.UNSUPPORTED_OPERATION, operator.stringValue(), lVar.getBType().getString(), rVar.getBType().getString());
    }
}

