/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.variable.BVariableType;

public class ConditionalExpressionEvaluator
extends Evaluator {
    private final ConditionalExpressionNode syntaxNode;
    private final Evaluator lhsEvaluator;
    private final Evaluator middleEvaluator;
    private final Evaluator endEvaluator;

    public ConditionalExpressionEvaluator(EvaluationContext context, ConditionalExpressionNode expressionNode, Evaluator lhsExprEvaluator, Evaluator middleExprEvaluator, Evaluator endExprEvaluator) {
        super(context);
        this.syntaxNode = expressionNode;
        this.lhsEvaluator = lhsExprEvaluator;
        this.middleEvaluator = middleExprEvaluator;
        this.endEvaluator = endExprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue lhsResult = this.lhsEvaluator.evaluate();
            if (lhsResult.getType() != BVariableType.BOOLEAN) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_MISMATCH, BVariableType.BOOLEAN.getString(), lhsResult.getType().getString(), this.syntaxNode.lhsExpression().toSourceCode().trim());
            }
            return Boolean.parseBoolean(lhsResult.getStringValue()) ? this.middleEvaluator.evaluate() : this.endEvaluator.evaluate();
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }
}

