/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.projects.Package;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.ClassDefinitionResolver;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.NodeBasedArgProcessor;
import org.ballerinalang.debugadapter.evaluation.engine.SymbolBasedArgProcessor;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.GeneratedInstanceMethod;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.JvmMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;
import org.ballerinalang.debugadapter.evaluation.utils.LangLibUtils;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.VariableFactory;

public class MethodCallExpressionEvaluator
extends Evaluator {
    private final ExpressionNode syntaxNode;
    private final String methodName;
    private final Evaluator objectExpressionEvaluator;
    private final List<Map.Entry<String, Evaluator>> argEvaluators;
    protected static final String QUALIFIED_TYPE_SIGNATURE_PREFIX = "L";
    protected static final String JNI_SIGNATURE_SEPARATOR = "/";

    public MethodCallExpressionEvaluator(EvaluationContext context, ExpressionNode methodCallExpressionNode, Evaluator expression, List<Map.Entry<String, Evaluator>> argEvaluators) {
        super(context);
        this.syntaxNode = methodCallExpressionNode;
        this.objectExpressionEvaluator = expression;
        this.argEvaluators = argEvaluators;
        ExpressionNode expressionNode = this.syntaxNode;
        if (expressionNode instanceof MethodCallExpressionNode) {
            MethodCallExpressionNode methodCallExpr = (MethodCallExpressionNode)expressionNode;
            this.methodName = methodCallExpr.methodName().toSourceCode().trim();
        } else {
            expressionNode = this.syntaxNode;
            if (expressionNode instanceof RemoteMethodCallActionNode) {
                RemoteMethodCallActionNode remoteMethodCallActionNode = (RemoteMethodCallActionNode)expressionNode;
                this.methodName = remoteMethodCallActionNode.methodName().toSourceCode().trim();
            } else {
                this.methodName = "unknown";
            }
        }
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            Value invocationResult = null;
            BExpressionValue result = this.objectExpressionEvaluator.evaluate();
            BVariable resultVar = VariableFactory.getVariable(this.context, result.getJdiValue());
            if (result.getType() == BVariableType.OBJECT && (invocationResult = this.invokeObjectMethod(resultVar)) == null) {
                return new BExpressionValue(this.context, null);
            }
            if (invocationResult == null || invocationResult.virtualMachine() == null && invocationResult.type() == null) {
                invocationResult = this.invokeLangLibMethod(result);
            }
            return new BExpressionValue(this.context, invocationResult);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private Value invokeObjectMethod(BVariable resultVar) throws EvaluationException {
        boolean isFoundObjectMethod = false;
        try {
            ClassDefinitionResolver classDefResolver = new ClassDefinitionResolver(this.context);
            String className = resultVar.getDapVariable().getValue();
            Optional<ClassSymbol> classDef = classDefResolver.findBalClassDefWithinModule(className);
            if (classDef.isEmpty()) {
                String signature = resultVar.getJvmValue().type().signature();
                if (!signature.startsWith(QUALIFIED_TYPE_SIGNATURE_PREFIX)) {
                    throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_NOT_FOUND, className);
                }
                String[] signatureParts = signature.substring(1).split(JNI_SIGNATURE_SEPARATOR);
                if (signatureParts.length < 2) {
                    throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_NOT_FOUND, className);
                }
                String orgName = signatureParts[0];
                String packageName = signatureParts[1];
                classDef = classDefResolver.findBalClassDefWithinDependencies(orgName, packageName, className);
            }
            if (classDef.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.CLASS_NOT_FOUND, className);
            }
            Optional<MethodSymbol> objectMethodDef = this.findObjectMethodInClass(classDef.get(), this.methodName);
            if (objectMethodDef.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.OBJECT_METHOD_NOT_FOUND, this.methodName.trim(), className);
            }
            isFoundObjectMethod = true;
            GeneratedInstanceMethod objectMethod = this.getObjectMethodByName(resultVar, this.methodName);
            SymbolBasedArgProcessor argProcessor = new SymbolBasedArgProcessor(this.context, this.methodName, objectMethod.getJDIMethodRef(), (FunctionSymbol)objectMethodDef.get());
            List<Value> orderedArgsList = argProcessor.process(this.argEvaluators);
            objectMethod.setArgValues(orderedArgsList);
            return objectMethod.invokeSafely();
        }
        catch (EvaluationException e) {
            if (isFoundObjectMethod) {
                throw e;
            }
            return new VoidValue(this){

                @Override
                public VirtualMachine virtualMachine() {
                    return null;
                }

                @Override
                public Type type() {
                    return null;
                }
            };
        }
    }

    private Value invokeLangLibMethod(BExpressionValue resultVar) throws EvaluationException {
        Optional<FunctionDefinitionNode> functionDef;
        FunctionDefinitionNode langLibFunctionDef = null;
        JvmMethod langLibMethod = null;
        String langLibName = LangLibUtils.getAssociatedLangLibName(resultVar.getType());
        Optional<Package> langLibPkg = LangLibUtils.getLangLibPackage(this.context, langLibName);
        if (langLibPkg.isPresent() && (functionDef = LangLibUtils.getLangLibFunctionDefinition(langLibPkg.get(), this.methodName)).isPresent()) {
            String langLibCls = LangLibUtils.getQualifiedLangLibClassName(langLibPkg.get(), langLibName);
            langLibFunctionDef = functionDef.get();
            langLibMethod = LangLibUtils.loadLangLibMethod(this.context, resultVar, langLibCls, this.methodName);
        }
        if (langLibMethod == null) {
            Optional<Package> valueLibPkg = LangLibUtils.getLangLibPackage(this.context, "value");
            if (valueLibPkg.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.LANG_LIB_NOT_FOUND, "lang." + langLibName + ", lang.value");
            }
            Optional<FunctionDefinitionNode> functionDef2 = LangLibUtils.getLangLibFunctionDefinition(valueLibPkg.get(), this.methodName);
            if (functionDef2.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.LANG_LIB_METHOD_NOT_FOUND, this.methodName, langLibName);
            }
            String langLibCls = LangLibUtils.getQualifiedLangLibClassName(valueLibPkg.get(), "value");
            langLibFunctionDef = functionDef2.get();
            langLibMethod = LangLibUtils.loadLangLibMethod(this.context, resultVar, langLibCls, this.methodName);
        }
        this.argEvaluators.add(0, new AbstractMap.SimpleEntry<String, Evaluator>("", this.objectExpressionEvaluator));
        NodeBasedArgProcessor argProcessor = new NodeBasedArgProcessor(this.context, this.methodName, langLibMethod.getJDIMethodRef(), langLibFunctionDef);
        List<Value> orderedArgsList = argProcessor.process(this.argEvaluators);
        langLibMethod.setArgValues(orderedArgsList);
        return langLibMethod.invokeSafely();
    }

    protected Optional<MethodSymbol> findObjectMethodInClass(ClassSymbol classDef, String methodName) {
        return classDef.methods().values().stream().filter(methodSymbol -> EvaluationUtils.modifyName((String)methodSymbol.getName().get()).equals(methodName)).findFirst();
    }

    private GeneratedInstanceMethod getObjectMethodByName(BVariable objectVar, String methodName) throws EvaluationException {
        ReferenceType objectRef = ((ObjectReference)objectVar.getJvmValue()).referenceType();
        List<Method> methods = objectRef.methodsByName(methodName);
        if (methods == null || methods.size() != 1) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.OBJECT_METHOD_NOT_FOUND, methodName.trim(), objectVar.computeValue());
        }
        return new GeneratedInstanceMethod(this.context, objectVar.getJvmValue(), methods.get(0));
    }
}

