/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.expression;

import com.sun.jdi.Value;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.debugadapter.EvaluationContext;
import org.ballerinalang.debugadapter.evaluation.BExpressionValue;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.Evaluator;
import org.ballerinalang.debugadapter.evaluation.engine.NodeBasedTypeResolver;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeStaticMethod;
import org.ballerinalang.debugadapter.evaluation.utils.EvaluationUtils;

public class TypeCastExpressionEvaluator
extends Evaluator {
    private final TypeCastExpressionNode syntaxNode;
    private final Evaluator exprEvaluator;

    public TypeCastExpressionEvaluator(EvaluationContext context, TypeCastExpressionNode typeCastExpressionNode, Evaluator exprEvaluator) {
        super(context);
        this.syntaxNode = typeCastExpressionNode;
        this.exprEvaluator = exprEvaluator;
    }

    @Override
    public BExpressionValue evaluate() throws EvaluationException {
        try {
            BExpressionValue result = this.exprEvaluator.evaluate();
            Value valueAsObject = EvaluationUtils.getValueAsObject(this.context, result.getJdiValue());
            NodeList annotations = this.syntaxNode.typeCastParam().annotations();
            if (!annotations.isEmpty()) {
                throw EvaluationException.createEvaluationException("Type casting with annotations is not supported by the evaluator.");
            }
            NodeBasedTypeResolver bTypeResolver = new NodeBasedTypeResolver(this.evaluationContext);
            List<Value> resolvedTypes = bTypeResolver.resolve((Node)this.syntaxNode.typeCastParam().type().get());
            if (resolvedTypes.isEmpty()) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.TYPE_RESOLVING_ERROR, ((Node)this.syntaxNode.typeCastParam().type().get()).toSourceCode());
            }
            Value bTypeDescriptor = resolvedTypes.size() > 1 ? bTypeResolver.getUnionTypeFrom(resolvedTypes) : resolvedTypes.get(0);
            return this.checkCast(valueAsObject, bTypeDescriptor);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.INTERNAL_ERROR, this.syntaxNode.toSourceCode().trim());
        }
    }

    private BExpressionValue checkCast(Value lhsExpressionResult, Value type) throws EvaluationException {
        ArrayList<String> methodArgTypeNames = new ArrayList<String>();
        methodArgTypeNames.add("java.lang.Object");
        methodArgTypeNames.add("io.ballerina.runtime.api.types.Type");
        RuntimeStaticMethod method = EvaluationUtils.getRuntimeMethod(this.context, "io.ballerina.runtime.internal.TypeChecker", "checkCast", methodArgTypeNames);
        ArrayList<Value> methodArgs = new ArrayList<Value>();
        methodArgs.add(lhsExpressionResult);
        methodArgs.add(type);
        method.setArgValues(methodArgs);
        return new BExpressionValue(this.context, method.invokeSafely());
    }
}

