/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.engine.invokable;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.List;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.evaluation.EvaluationExceptionKind;
import org.ballerinalang.debugadapter.evaluation.engine.invokable.RuntimeMethod;

public class RuntimeStaticMethod
extends RuntimeMethod {
    private final ReferenceType classRef;

    public RuntimeStaticMethod(SuspendedContext context, ReferenceType classRef, Method methodRef) {
        super(context, methodRef);
        this.classRef = classRef;
    }

    @Override
    protected synchronized Value invoke() throws EvaluationException {
        try {
            ReferenceType referenceType = this.classRef;
            if (!(referenceType instanceof ClassType)) {
                throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_EXECUTION_ERROR, this.methodRef.name());
            }
            ClassType classType = (ClassType)referenceType;
            List<Value> argValueList = this.getMethodArgs(this);
            return classType.invokeMethod(this.context.getFrame().threadProxy().getThreadReference(), this.methodRef, argValueList, 0);
        }
        catch (ClassNotLoadedException e) {
            throw EvaluationException.createEvaluationException(EvaluationExceptionKind.FUNCTION_NOT_FOUND, this.methodRef.name());
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.extractBErrors(e);
        }
    }
}

