/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.evaluation.validator.impl;

import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import org.ballerinalang.debugadapter.evaluation.parser.DebugParser;
import org.ballerinalang.debugadapter.evaluation.validator.Validator;

public class InvalidInputValidator
extends Validator {
    private static final String DOCUMENTATION_START = "# ";

    public InvalidInputValidator(DebugParser parser) {
        super(parser);
    }

    @Override
    public void validate(String source) throws Exception {
        InvalidInputValidator.failIf(source.isBlank(), "Empty expressions cannot be evaluated.");
        InvalidInputValidator.failIf(source.trim().startsWith(DOCUMENTATION_START), "Documentation is not allowed.");
        SyntaxTree syntaxTree = this.debugParser.getSyntaxTreeFor(source);
        InvalidInputValidator.failIf(!syntaxTree.containsModulePart(), "Empty expressions cannot be evaluated.");
        ModulePartNode moduleNode = (ModulePartNode)syntaxTree.rootNode();
        NodeList members = moduleNode.members();
        NodeList imports = moduleNode.imports();
        InvalidInputValidator.failIf(imports.isEmpty() && members.isEmpty(), "Empty expressions cannot be evaluated.");
    }
}

