/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.jdi;

import com.sun.jdi.ReferenceType;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxyImpl;

public interface ClassesByNameProvider {
    public List<ReferenceType> get(String var1);

    public static ClassesByNameProvider createCache(List<ReferenceType> allTypes) {
        return new Cache(allTypes);
    }

    public static final class Cache
    implements ClassesByNameProvider {
        private final ConcurrentHashMap<String, ReferenceType> myCache = new ConcurrentHashMap();

        public Cache(List<ReferenceType> classes) {
            classes.forEach(t -> this.myCache.put(t.signature(), (ReferenceType)t));
        }

        @Override
        public List<ReferenceType> get(String s) {
            String signature = VirtualMachineProxyImpl.JNITypeParserReflect.typeNameToSignature(s);
            if (signature != null) {
                return (List)((Object)this.myCache.get(signature));
            }
            return Collections.emptyList();
        }
    }
}

