/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.debugadapter.jdi.JDIUtils;
import org.ballerinalang.debugadapter.jdi.JdiProxy;
import org.ballerinalang.debugadapter.jdi.JdiProxyException;
import org.ballerinalang.debugadapter.jdi.LocalVariableProxyImpl;
import org.ballerinalang.debugadapter.jdi.StackFrameProxy;
import org.ballerinalang.debugadapter.jdi.ThreadReferenceProxyImpl;
import org.ballerinalang.debugadapter.jdi.ThreeState;
import org.ballerinalang.debugadapter.jdi.VirtualMachineProxyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxy {
    private static final Logger LOG = LoggerFactory.getLogger(StackFrameProxyImpl.class);
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final int myFrameFromBottomIndex;
    private int myFrameIndex = -1;
    private StackFrame myStackFrame;
    private ObjectReference myThisReference;
    private ClassLoaderReference myClassLoader;
    private ThreeState myIsObsolete = ThreeState.UNSURE;
    private Map<LocalVariable, Value> myAllValues;
    private static final int RETRY_COUNT = 20;

    public StackFrameProxyImpl(ThreadReferenceProxyImpl threadProxy, StackFrame frame, int fromBottomIndex) {
        super(threadProxy.getVirtualMachine());
        this.myThreadProxy = threadProxy;
        this.myFrameFromBottomIndex = fromBottomIndex;
        this.myStackFrame = frame;
    }

    public boolean isObsolete() throws JdiProxyException {
        this.checkValid();
        if (this.myIsObsolete != ThreeState.UNSURE) {
            return this.myIsObsolete.toBoolean();
        }
        Throwable error = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                Method method = StackFrameProxyImpl.getMethod(this.location());
                boolean isObsolete = this.getVirtualMachine().canRedefineClasses() && (method == null || method.isObsolete());
                this.myIsObsolete = ThreeState.fromBoolean(isObsolete);
                return isObsolete;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (InternalException e) {
                if (e.errorCode() == 23) {
                    this.myIsObsolete = ThreeState.YES;
                    return true;
                }
                throw e;
            }
        }
        throw new JdiProxyException(error.getMessage(), error);
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        try {
            if (this.myStackFrame != null) {
                this.myStackFrame.location();
            }
            return true;
        }
        catch (InvalidStackFrameException e) {
            return false;
        }
    }

    @Override
    protected void clearCaches() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("caches cleared " + super.toString());
        }
        this.myFrameIndex = -1;
        this.myStackFrame = null;
        this.myIsObsolete = ThreeState.UNSURE;
        this.myThisReference = null;
        this.myClassLoader = null;
        this.myAllValues = null;
    }

    @Override
    public StackFrame getStackFrame() throws JdiProxyException {
        this.checkValid();
        if (this.myStackFrame != null) {
            return this.myStackFrame;
        }
        IncompatibleThreadStateException error = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                ThreadReference threadRef = this.myThreadProxy.getThreadReference();
                this.myStackFrame = threadRef.frame(this.getFrameIndex());
                return this.myStackFrame;
            }
            catch (IncompatibleThreadStateException e) {
                error = e;
                this.clearCaches();
                JDIUtils.sleepMillis(10L);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new JdiProxyException(e.getMessage(), e);
            }
            catch (ObjectCollectedException ignored) {
                throw new JdiProxyException("Thread has been collected");
            }
            catch (Exception e) {
                throw new JdiProxyException("Unknown error when trying to access thread reference", e);
            }
        }
        throw new JdiProxyException("Thread has become invalid", error);
    }

    @Override
    public int getFrameIndex() throws JdiProxyException {
        this.checkValid();
        if (this.myFrameIndex == -1) {
            int count = this.myThreadProxy.frameCount();
            if (this.myFrameFromBottomIndex > count) {
                throw new JdiProxyException(new IncompatibleThreadStateException());
            }
            this.myFrameIndex = count - this.myFrameFromBottomIndex;
        }
        return this.myFrameIndex;
    }

    @Override
    public VirtualMachineProxyImpl getVirtualMachine() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    @Override
    public Location location() throws JdiProxyException {
        Throwable error = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                return this.getStackFrame().location();
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        throw new JdiProxyException(error.getMessage(), error);
    }

    @Override
    public ThreadReferenceProxyImpl threadProxy() {
        return this.myThreadProxy;
    }

    public String toString() {
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (JdiProxyException e) {
            return String.format("StackFrameProxyImpl: %s; frameFromBottom = %d threadName = %s", e.getMessage(), this.myFrameFromBottomIndex, this.threadProxy().name());
        }
    }

    public ObjectReference thisObject() throws JdiProxyException {
        this.checkValid();
        try {
            for (int attempt = 0; attempt < 20; ++attempt) {
                try {
                    if (this.myThisReference == null) {
                        this.myThisReference = this.getStackFrame().thisObject();
                    }
                    break;
                }
                catch (InvalidStackFrameException ignored) {
                    this.clearCaches();
                    continue;
                }
            }
        }
        catch (InternalException e) {
            if (e.errorCode() != 23 && e.errorCode() != 35) {
                throw new JdiProxyException(e.getMessage(), e);
            }
            LOG.info("Exception while getting this object", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Exception while getting this object", (Throwable)e);
        }
        catch (Exception e) {
            if (!this.getVirtualMachine().canBeModified()) {
                LOG.debug(e.getMessage());
            }
            throw e;
        }
        return this.myThisReference;
    }

    public List<LocalVariableProxyImpl> visibleVariables() throws JdiProxyException {
        Throwable error = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                List<LocalVariable> list = this.getStackFrame().visibleVariables();
                ArrayList<LocalVariableProxyImpl> locals = new ArrayList<LocalVariableProxyImpl>(list.size());
                for (LocalVariable localVariable : list) {
                    locals.add(new LocalVariableProxyImpl(this, localVariable));
                }
                return locals;
            }
            catch (InvalidStackFrameException | IllegalArgumentException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (AbsentInformationException e) {
                throw new JdiProxyException(e);
            }
        }
        throw new JdiProxyException(error.getMessage(), error);
    }

    @Override
    public LocalVariableProxyImpl visibleVariableByName(String name) throws JdiProxyException {
        LocalVariable variable = this.visibleVariableByNameInt(name);
        return variable != null ? new LocalVariableProxyImpl(this, variable) : null;
    }

    public Value visibleValueByName(String name) throws JdiProxyException {
        LocalVariable variable = this.visibleVariableByNameInt(name);
        return variable != null ? this.getValue(new LocalVariableProxyImpl(this, variable)) : null;
    }

    protected LocalVariable visibleVariableByNameInt(String name) throws JdiProxyException {
        Throwable error = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                return this.getStackFrame().visibleVariableByName(name);
            }
            catch (InvalidStackFrameException e) {
                try {
                    error = e;
                    this.clearCaches();
                    continue;
                }
                catch (AbsentInformationException | InvalidStackFrameException e2) {
                    throw new JdiProxyException(e2);
                }
            }
        }
        throw new JdiProxyException(error.getMessage(), error);
    }

    public Value getValue(LocalVariableProxyImpl localVariable) throws JdiProxyException {
        Throwable error = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                return this.getStackFrame().getValue(localVariable.getVariable());
            }
            catch (InvalidStackFrameException | IllegalArgumentException e) {
                error = e;
                this.clearCaches();
            }
            catch (InconsistentDebugInfoException ignored) {
                this.clearCaches();
                throw new JdiProxyException("Debug information is inconsistent");
            }
            catch (InternalException e) {
                if (e.errorCode() == 35 || e.errorCode() == 101) {
                    throw new JdiProxyException("Debug info might be corrupt", e);
                }
                throw e;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug(e.getMessage());
                    throw new JdiProxyException("Debug data corrupted");
                }
                throw e;
            }
            JDIUtils.sleepMillis(1L);
        }
        throw new JdiProxyException(error.getMessage(), error);
    }

    public Map<LocalVariable, Value> getAllValues() throws JdiProxyException {
        this.checkValid();
        if (this.myAllValues == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                this.myAllValues = new HashMap<LocalVariable, Value>(stackFrame.getValues(stackFrame.visibleVariables()));
            }
            catch (AbsentInformationException e) {
                throw new JdiProxyException(e);
            }
            catch (InternalException e) {
                if (e.errorCode() == 35 || e.errorCode() == 101) {
                    LOG.info(e.getMessage());
                    this.myAllValues = new HashMap<LocalVariable, Value>();
                }
                throw e;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug(e.getMessage());
                    this.myAllValues = new HashMap<LocalVariable, Value>();
                }
                throw e;
            }
        }
        return this.myAllValues;
    }

    public void setValue(LocalVariableProxyImpl localVariable, Value value) throws JdiProxyException, ClassNotLoadedException, InvalidTypeException {
        Throwable error = null;
        for (int attempt = 0; attempt < 20; ++attempt) {
            try {
                LocalVariable variable = localVariable.getVariable();
                StackFrame stackFrame = this.getStackFrame();
                stackFrame.setValue(variable, value);
                if (this.myAllValues != null) {
                    this.myAllValues.put(variable, stackFrame.getValue(variable));
                }
                return;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        throw new JdiProxyException(error.getMessage(), error);
    }

    public int hashCode() {
        return 31 * this.myThreadProxy.hashCode() + this.myFrameFromBottomIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackFrameProxyImpl)) {
            return false;
        }
        StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)obj;
        if (frameProxy == this) {
            return true;
        }
        return this.myFrameFromBottomIndex == frameProxy.myFrameFromBottomIndex && this.myThreadProxy.equals(frameProxy.myThreadProxy);
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl var) throws JdiProxyException {
        try {
            return var.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Override
    public ClassLoaderReference getClassLoader() throws JdiProxyException {
        if (this.myClassLoader == null) {
            this.myClassLoader = this.location().declaringType().classLoader();
        }
        return this.myClassLoader;
    }

    public boolean isBottom() {
        return this.myFrameFromBottomIndex == 1;
    }

    public int getIndexFromBottom() {
        return this.myFrameFromBottomIndex;
    }

    private static Method getMethod(Location location) {
        try {
            return location.method();
        }
        catch (IllegalArgumentException e) {
            LOG.info(e.getMessage());
            return null;
        }
    }
}

