/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.utils;

import java.util.Locale;

public final class OSUtils {
    public static final String WINDOWS = "windows";
    public static final String UNIX = "unix";
    public static final String MAC = "mac";
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());

    private OSUtils() {
    }

    public static String getOperatingSystem() {
        if (OSUtils.isWindows()) {
            return WINDOWS;
        }
        if (OSUtils.isUnix() || OSUtils.isSolaris()) {
            return UNIX;
        }
        if (OSUtils.isMac()) {
            return MAC;
        }
        return null;
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains(MAC);
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }
}

