/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.utils;

import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.projects.directory.SingleFileProject;
import io.ballerina.projects.util.ProjectPaths;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.DebugSourceType;
import org.ballerinalang.debugadapter.ExecutionContext;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.IdentifierModifier;
import org.ballerinalang.debugadapter.utils.DependencySourceResolver;
import org.ballerinalang.debugadapter.utils.LangLibSourceResolver;
import org.ballerinalang.debugadapter.utils.ProjectSourceResolver;
import org.ballerinalang.debugadapter.utils.SourceResolver;

public final class PackageUtils {
    public static final String BAL_FILE_EXT = ".bal";
    public static final String BAL_TOML_FILE_NAME = "Ballerina.toml";
    public static final String INIT_CLASS_NAME = "$_init";
    public static final String INIT_TYPE_INSTANCE_PREFIX = "$type$";
    public static final String GENERATED_VAR_PREFIX = "$";
    static final String USER_MODULE_DIR = "modules";
    static final String GEN_MODULE_DIR = "generated";
    static final String PERSIST_DIR = "persist";
    static final String TEST_PKG_POSTFIX = "$test";
    private static final String URI_SCHEME_FILE = "file";
    public static final String URI_SCHEME_BALA = "bala";
    private static final String FILE_SEPARATOR_REGEX = File.separatorChar == '\\' ? "\\\\" : File.separator;

    private PackageUtils() {
    }

    public static Optional<Map.Entry<Path, DebugSourceType>> getStackFrameSourcePath(Location stackFrameLocation, Project sourceProject) {
        ArrayList<SourceResolver> sourceResolvers = new ArrayList<SourceResolver>();
        sourceResolvers.add(new ProjectSourceResolver(sourceProject));
        sourceResolvers.add(new LangLibSourceResolver(sourceProject));
        sourceResolvers.add(new DependencySourceResolver(sourceProject));
        for (SourceResolver sourceResolver : sourceResolvers) {
            Optional<Path> resolvedPath;
            if (!sourceResolver.isSupported(stackFrameLocation) || !(resolvedPath = sourceResolver.resolve(stackFrameLocation)).isPresent()) continue;
            if (sourceResolver instanceof DependencySourceResolver) {
                return Optional.of(new AbstractMap.SimpleEntry<Path, DebugSourceType>(resolvedPath.get(), DebugSourceType.DEPENDENCY));
            }
            return Optional.of(new AbstractMap.SimpleEntry<Path, DebugSourceType>(resolvedPath.get(), DebugSourceType.PACKAGE));
        }
        return Optional.empty();
    }

    public static Map.Entry<ProjectKind, Path> computeProjectKindAndRoot(Path path) {
        if (ProjectPaths.isStandaloneBalFile((Path)path) && !PackageUtils.isBalToolSpecificFile(path)) {
            return new AbstractMap.SimpleEntry<ProjectKind, Path>(ProjectKind.SINGLE_FILE_PROJECT, path);
        }
        Optional<Path> packageRoot = PackageUtils.findProjectRoot(path);
        if (packageRoot.isEmpty()) {
            return new AbstractMap.SimpleEntry<ProjectKind, Path>(ProjectKind.SINGLE_FILE_PROJECT, path);
        }
        if (PackageUtils.hasBallerinaToml(packageRoot.get())) {
            return new AbstractMap.SimpleEntry<ProjectKind, Path>(ProjectKind.BUILD_PROJECT, packageRoot.get());
        }
        return new AbstractMap.SimpleEntry<ProjectKind, Path>(ProjectKind.BALA_PROJECT, packageRoot.get());
    }

    private static boolean isBalToolSpecificFile(Path filePath) {
        Path parentPath = filePath.toAbsolutePath().normalize().getParent();
        return ProjectPaths.isBalFile((Path)filePath) && parentPath.toFile().isDirectory() && parentPath.toFile().getName().equals(PERSIST_DIR) && PackageUtils.hasBallerinaToml(parentPath.getParent());
    }

    private static boolean hasBallerinaToml(Path filePath) {
        if (Objects.isNull(filePath)) {
            return false;
        }
        Path absFilePath = filePath.toAbsolutePath().normalize();
        return absFilePath.resolve(BAL_TOML_FILE_NAME).toFile().exists();
    }

    private static Optional<Path> findProjectRoot(Path filePath) {
        if (filePath == null) {
            return Optional.empty();
        }
        if ((filePath = filePath.toAbsolutePath().normalize()).toFile().isDirectory() && (PackageUtils.hasBallerinaToml(filePath) || PackageUtils.hasPackageJson(filePath))) {
            return Optional.of(filePath);
        }
        return PackageUtils.findProjectRoot(filePath.getParent());
    }

    private static boolean hasPackageJson(Path filePath) {
        Path absFilePath = filePath.toAbsolutePath().normalize();
        return absFilePath.resolve("package.json").toFile().exists();
    }

    public static String getOrgName(Project project) {
        if (project instanceof BuildProject) {
            return project.currentPackage().packageOrg().value();
        }
        return "";
    }

    public static String getDefaultModuleName(Project project) {
        if (project instanceof BuildProject) {
            return project.currentPackage().getDefaultModule().moduleName().toString();
        }
        return "";
    }

    public static String getFileNameFrom(Path filePath) {
        try {
            String[] split = filePath.toString().split(FILE_SEPARATOR_REGEX);
            String fileName = split[split.length - 1];
            if (fileName.endsWith(BAL_FILE_EXT)) {
                return fileName.replace(BAL_FILE_EXT, "");
            }
            return fileName;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getQualifiedClassName(SuspendedContext context, String className) {
        if (context.getSourceType() == DebugSourceType.SINGLE_FILE) {
            return className;
        }
        StringJoiner classNameJoiner = new StringJoiner(".");
        classNameJoiner.add(context.getPackageOrg().get()).add(context.getModuleName().get()).add(context.getPackageMajorVersion().get()).add(className);
        return classNameJoiner.toString();
    }

    public static Optional<String> getQualifiedClassName(ExecutionContext context, String filePathUri) {
        try {
            Optional<Path> path = PackageUtils.getPathFromURI(filePathUri);
            if (path.isEmpty()) {
                return Optional.empty();
            }
            Project project = context.getProjectCache().getProject(path.get());
            project.currentPackage().getResolution();
            if (project instanceof SingleFileProject) {
                DocumentId documentId = (DocumentId)project.currentPackage().getDefaultModule().documentIds().iterator().next();
                String docName = project.currentPackage().getDefaultModule().document(documentId).name();
                if (docName.endsWith(BAL_FILE_EXT)) {
                    docName = docName.replace(BAL_FILE_EXT, "");
                }
                return Optional.of(docName);
            }
            DocumentId documentId = project.documentId(path.get());
            Module module = project.currentPackage().module(documentId.moduleId());
            Document document = module.document(documentId);
            int packageMajorVersion = document.module().packageInstance().packageVersion().value().major();
            StringJoiner classNameJoiner = new StringJoiner(".");
            classNameJoiner.add(document.module().packageInstance().packageOrg().value()).add(PackageUtils.getFullModuleName(document)).add(String.valueOf(packageMajorVersion)).add(document.name().replace(BAL_FILE_EXT, "").replace(FILE_SEPARATOR_REGEX, ".").replace("/", "."));
            return Optional.ofNullable(classNameJoiner.toString());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static String getQualifiedClassName(ReferenceType referenceType) {
        try {
            List<String> paths = referenceType.sourcePaths(null);
            List<String> names = referenceType.sourceNames(null);
            if (paths.isEmpty() || names.isEmpty()) {
                return referenceType.name();
            }
            String path = paths.get(0);
            String name = names.get(0);
            String[] nameParts = PackageUtils.getQModuleNameParts(name);
            String srcFileName = nameParts[nameParts.length - 1];
            if (!path.endsWith(BAL_FILE_EXT)) {
                return referenceType.name();
            }
            srcFileName = srcFileName.replaceAll(".bal$", "");
            path = path.replaceAll(name + GENERATED_VAR_PREFIX, srcFileName);
            return PackageUtils.replaceSeparators(path);
        }
        catch (Exception e) {
            return referenceType.name();
        }
    }

    public static String[] getQModuleNameParts(String path) {
        String[] moduleParts = (path = path.replace("\\", "/")).contains("/") ? path.split("/") : new String[]{path};
        return moduleParts;
    }

    public static URI covertToBalaUri(URI fileUri) throws URISyntaxException, IllegalArgumentException {
        if (fileUri.getScheme().equals(URI_SCHEME_FILE)) {
            return new URI(URI_SCHEME_BALA, fileUri.getHost(), fileUri.getPath(), fileUri.getFragment());
        }
        throw new IllegalArgumentException("unsupported URI with scheme: " + fileUri.getScheme());
    }

    private static Optional<Path> getPathFromURI(String fileUri) {
        try {
            if (PackageUtils.isValidPath(fileUri)) {
                return Optional.of(Path.of(fileUri, new String[0]).normalize());
            }
            URI uri = URI.create(fileUri);
            String scheme = uri.getScheme();
            if (uri.getScheme() == null || uri.getScheme().equals(URI_SCHEME_BALA)) {
                scheme = URI_SCHEME_FILE;
            }
            URI converted = new URI(scheme, uri.getHost(), uri.getPath(), uri.getFragment());
            return Optional.of(Path.of(converted).normalize());
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }

    private static boolean isValidPath(String path) {
        if (path.startsWith("bala:")) {
            return false;
        }
        try {
            Path.of(path, new String[0]);
        }
        catch (InvalidPathException ex) {
            return false;
        }
        return true;
    }

    private static String getFullModuleName(Document document) {
        Object moduleName;
        String packageNamePart = IdentifierModifier.encodeModuleName(document.module().moduleName().packageName().value());
        String moduleNamePart = document.module().moduleName().moduleNamePart();
        Object object = moduleName = moduleNamePart != null ? IdentifierModifier.encodeModuleName(packageNamePart + "." + moduleNamePart) : packageNamePart;
        if (document.module().testDocumentIds().contains(document.documentId())) {
            moduleName = (String)moduleName + TEST_PKG_POSTFIX;
        }
        return moduleName;
    }

    private static String replaceSeparators(String path) {
        if (path.contains("/")) {
            return path.replace("/", ".");
        }
        if (path.contains("\\")) {
            return path.replace("\\", ".");
        }
        return path;
    }
}

