/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.utils;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import io.ballerina.identifier.Utils;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import java.io.File;
import java.nio.file.Path;
import java.util.Optional;
import org.ballerinalang.debugadapter.utils.DebugSourceLocation;
import org.ballerinalang.debugadapter.utils.PackageUtils;
import org.ballerinalang.debugadapter.utils.SourceResolver;

public class ProjectSourceResolver
extends SourceResolver {
    ProjectSourceResolver(Project sourceProject) {
        super(sourceProject);
    }

    @Override
    public boolean isSupported(Location location) {
        try {
            if (this.sourceProject.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                DocumentId docId = (DocumentId)this.sourceProject.currentPackage().getDefaultModule().documentIds().iterator().next();
                Document document = this.sourceProject.currentPackage().getDefaultModule().document(docId);
                return document.name().equals(location.sourcePath()) && document.name().equals(location.sourceName());
            }
            if (this.sourceProject.kind() == ProjectKind.BUILD_PROJECT) {
                String projectOrg = PackageUtils.getOrgName(this.sourceProject);
                DebugSourceLocation debugSourceLocation = new DebugSourceLocation(location);
                return debugSourceLocation.isValid() && debugSourceLocation.orgName().equals(projectOrg);
            }
            return false;
        }
        catch (AbsentInformationException e) {
            return false;
        }
    }

    @Override
    public Optional<Path> resolve(Location location) {
        try {
            String projectRoot = this.sourceProject.sourceRoot().toAbsolutePath().toString();
            if (this.sourceProject.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
                DocumentId docId = (DocumentId)this.sourceProject.currentPackage().getDefaultModule().documentIds().iterator().next();
                Document document = this.sourceProject.currentPackage().getDefaultModule().document(docId);
                if (!document.name().equals(location.sourcePath()) || !document.name().equals(location.sourceName())) {
                    return Optional.empty();
                }
                return Optional.of(Path.of(projectRoot, new String[0]));
            }
            if (this.sourceProject.kind() == ProjectKind.BUILD_PROJECT) {
                String projectOrg = PackageUtils.getOrgName(this.sourceProject);
                String defaultModuleName = PackageUtils.getDefaultModuleName(this.sourceProject);
                String locationName = location.sourceName();
                DebugSourceLocation debugSourceLocation = new DebugSourceLocation(location);
                if (!debugSourceLocation.isValid() || !debugSourceLocation.orgName().equals(projectOrg)) {
                    return Optional.empty();
                }
                String modulePart = Utils.decodeIdentifier((String)debugSourceLocation.moduleName());
                if ((modulePart = modulePart.replaceFirst(defaultModuleName, "")).startsWith(".")) {
                    modulePart = modulePart.replaceFirst("\\.", "");
                }
                if (modulePart.isBlank()) {
                    File moduleFile = Path.of(projectRoot, locationName).toFile();
                    if (moduleFile.isFile()) {
                        return Optional.of(moduleFile.toPath().toAbsolutePath());
                    }
                    File generatedFile = Path.of(projectRoot, "generated", locationName).toFile();
                    if (generatedFile.isFile()) {
                        return Optional.of(generatedFile.toPath().toAbsolutePath());
                    }
                } else {
                    File moduleFile = Path.of(projectRoot, "modules", modulePart, locationName).toFile();
                    if (moduleFile.isFile()) {
                        return Optional.of(moduleFile.toPath().toAbsolutePath());
                    }
                    File generatedFile = Path.of(projectRoot, "generated", modulePart, locationName).toFile();
                    if (generatedFile.isFile()) {
                        return Optional.of(generatedFile.toPath().toAbsolutePath());
                    }
                }
            }
            return Optional.empty();
        }
        catch (AbsentInformationException e) {
            return Optional.empty();
        }
    }
}

