/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.evaluation.EvaluationException;
import org.ballerinalang.debugadapter.jdi.JDIUtils;
import org.ballerinalang.debugadapter.jdi.LocalVariableProxyImpl;
import org.ballerinalang.debugadapter.variable.BVariable;
import org.ballerinalang.debugadapter.variable.DebugVariableException;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.JVMValueType;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;

public final class VariableUtils {
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_TYPENAME = "typeName";
    public static final String FIELD_VALUE = "value";
    public static final String FIELD_PACKAGE = "pkg";
    public static final String FIELD_PKG_ORG = "org";
    public static final String FIELD_PKG_NAME = "name";
    public static final String FIELD_REFERRED_TYPE = "referredType";
    public static final String FIELD_EFFECTIVE_TYPE = "effectiveType";
    private static final String FIELD_CONSTRAINT = "constraint";
    private static final String METHOD_STR_VALUE = "stringValue";
    private static final String METHOD_EXP_STR_VALUE = "expressionStringValue";
    public static final String UNKNOWN_VALUE = "unknown";
    private static final String LAMBDA_PARAM_MAP_PATTERN = "\\$.*[Mm][Aa][Pp].*\\$.*";
    private static final String ADDITIONAL_QUOTES_REMOVE_REGEX = "^\"|\"$";
    static final String INTERNAL_VALUE_PREFIX = "io.ballerina.runtime.internal.values.";
    public static final String INTERNAL_TYPE_PREFIX = "io.ballerina.runtime.internal.types.";
    public static final String INTERNAL_TYPE_REF_TYPE = "BTypeReferenceType";
    public static final String INTERNAL_TYPE_INTERSECTION_TYPE = "BIntersectionType";

    private VariableUtils() {
    }

    public static String getBType(Value value) {
        try {
            if (!(value instanceof ObjectReference)) {
                return UNKNOWN_VALUE;
            }
            ObjectReference valueRef = (ObjectReference)value;
            Field bTypeField = valueRef.referenceType().fieldByName(FIELD_TYPE);
            Value bTypeRef = valueRef.getValue(bTypeField);
            Field typeNameField = ((ObjectReference)bTypeRef).referenceType().fieldByName(FIELD_TYPENAME);
            Value typeNameRef = ((ObjectReference)bTypeRef).getValue(typeNameField);
            return VariableUtils.getStringFrom(typeNameRef);
        }
        catch (Exception e) {
            return UNKNOWN_VALUE;
        }
    }

    public static String getRecordBType(Value value) {
        try {
            if (!(value instanceof ObjectReference) || !(value.type() instanceof ClassType)) {
                return UNKNOWN_VALUE;
            }
            ClassType mapValueClass = ((ClassType)value.type()).superclass();
            if (mapValueClass == null) {
                return UNKNOWN_VALUE;
            }
            Field bTypeField = mapValueClass.fieldByName(FIELD_TYPE);
            Value bTypeRef = ((ObjectReference)value).getValue(bTypeField);
            Field typeNameField = ((ObjectReference)bTypeRef).referenceType().fieldByName(FIELD_TYPENAME);
            Value typeNameRef = ((ObjectReference)bTypeRef).getValue(typeNameField);
            return VariableUtils.getStringFrom(typeNameRef);
        }
        catch (Exception e) {
            return UNKNOWN_VALUE;
        }
    }

    public static Map.Entry<String, String> getPackageOrgAndName(Value bValue) {
        try {
            if (!(bValue instanceof ObjectReference)) {
                return null;
            }
            ObjectReference valueRef = (ObjectReference)bValue;
            Field bTypeField = valueRef.referenceType().fieldByName(FIELD_TYPE);
            Value bTypeRef = valueRef.getValue(bTypeField);
            Field typePkgField = ((ObjectReference)bTypeRef).referenceType().fieldByName(FIELD_PACKAGE);
            Value typePkgRef = ((ObjectReference)bTypeRef).getValue(typePkgField);
            Field pkgOrgField = ((ObjectReference)typePkgRef).referenceType().fieldByName(FIELD_PKG_ORG);
            Value pkgOrgRef = ((ObjectReference)typePkgRef).getValue(pkgOrgField);
            String typePkgOrg = VariableUtils.getStringFrom(pkgOrgRef);
            Field pkgNameField = ((ObjectReference)typePkgRef).referenceType().fieldByName(FIELD_PKG_NAME);
            Value pkgNameRef = ((ObjectReference)typePkgRef).getValue(pkgNameField);
            String typePkgName = VariableUtils.getStringFrom(pkgNameRef);
            return new AbstractMap.SimpleEntry<String, String>(typePkgOrg, typePkgName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getStringFrom(Value stringValue) {
        try {
            if (!(stringValue instanceof ObjectReference)) {
                return UNKNOWN_VALUE;
            }
            ObjectReference stringRef = (ObjectReference)stringValue;
            if (!stringRef.referenceType().name().equals(JVMValueType.BMP_STRING.getString()) && !stringRef.referenceType().name().equals(JVMValueType.NON_BMP_STRING.getString())) {
                return VariableUtils.removeRedundantQuotes(stringRef.toString());
            }
            Optional<Value> valueField = VariableUtils.getFieldValue(stringRef, FIELD_VALUE);
            return valueField.map(value -> VariableUtils.removeRedundantQuotes(value.toString())).orElse(UNKNOWN_VALUE);
        }
        catch (Exception e) {
            return UNKNOWN_VALUE;
        }
    }

    public static String getStringValue(SuspendedContext context, Value jvmObject) {
        try {
            Value result = VariableUtils.invokeRemoteVMMethod(context, jvmObject, METHOD_STR_VALUE, Collections.singletonList(null));
            return VariableUtils.getStringFrom(result);
        }
        catch (DebugVariableException e) {
            return UNKNOWN_VALUE;
        }
    }

    public static Value invokeRemoteVMMethod(SuspendedContext context, Value jvmObject, String methodName, List<Value> arguments) throws DebugVariableException {
        if (!(jvmObject instanceof ObjectReference)) {
            throw new DebugVariableException("Failed to invoke remote VM method.");
        }
        Optional<Method> method = VariableUtils.getMethod(jvmObject, methodName);
        if (method.isEmpty()) {
            throw new DebugVariableException("Failed to invoke remote VM method.");
        }
        return VariableUtils.invokeRemoteVMMethod(context, jvmObject, method.get(), arguments);
    }

    public static Value invokeRemoteVMMethod(SuspendedContext context, Value jvmObject, Method method, List<Value> arguments) throws DebugVariableException {
        try {
            if (!(jvmObject instanceof ObjectReference)) {
                throw new DebugVariableException("Failed to invoke remote VM method.");
            }
            if (arguments == null) {
                arguments = Collections.emptyList();
            }
            for (int attempt = 0; attempt < 100; ++attempt) {
                try {
                    return ((ObjectReference)jvmObject).invokeMethod(context.getOwningThread().getThreadReference(), method, arguments, 1);
                }
                catch (Exception e) {
                    JDIUtils.sleepMillis(10L);
                    continue;
                }
            }
            throw new DebugVariableException("Failed to invoke remote VM method as the invocation thread is busy");
        }
        catch (Exception e) {
            throw new DebugVariableException("Failed to invoke remote VM method due to an internal error");
        }
    }

    public static String getExpressionStringValue(SuspendedContext context, Value jvmObject) {
        try {
            if (!(jvmObject instanceof ObjectReference)) {
                return UNKNOWN_VALUE;
            }
            Optional<Method> method = VariableUtils.getMethod(jvmObject, METHOD_EXP_STR_VALUE);
            if (method.isPresent()) {
                Value stringValue = ((ObjectReference)jvmObject).invokeMethod(context.getOwningThread().getThreadReference(), method.get(), Collections.singletonList(null), 1);
                return VariableUtils.getStringFrom(stringValue);
            }
            return UNKNOWN_VALUE;
        }
        catch (Exception ignored) {
            return UNKNOWN_VALUE;
        }
    }

    static boolean isObject(Value value) {
        try {
            return VariableUtils.getFieldValue(value, FIELD_TYPE).map(type -> type.type().name().endsWith(JVMValueType.BTYPE_OBJECT.getString())).orElse(false);
        }
        catch (DebugVariableException e) {
            return false;
        }
    }

    static boolean isClientObject(Value value) {
        try {
            return VariableUtils.getFieldValue(value, FIELD_TYPE).map(type -> type.type().name().endsWith(JVMValueType.BTYPE_CLIENT.getString())).orElse(false);
        }
        catch (DebugVariableException e) {
            return false;
        }
    }

    static boolean isRecord(Value value) {
        try {
            if (!(value.type() instanceof ClassType)) {
                return false;
            }
            ClassType mapValueClass = ((ClassType)value.type()).superclass();
            if (mapValueClass == null) {
                return false;
            }
            Field mapTypeField = mapValueClass.fieldByName(FIELD_TYPE);
            Value mapType = ((ObjectReference)value).getValue(mapTypeField);
            return VariableUtils.isRecordType(mapType);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isRecordType(Value typeValue) throws DebugVariableException {
        if (VariableUtils.isTypeReferenceType(typeValue) || VariableUtils.isIntersectionType(typeValue)) {
            typeValue = VariableUtils.getEffectiveType(typeValue);
        }
        return typeValue != null && typeValue.type().name().endsWith(JVMValueType.BTYPE_RECORD.getString());
    }

    private static Value getEffectiveType(Value typeValue) throws DebugVariableException {
        if (VariableUtils.isTypeReferenceType(typeValue)) {
            typeValue = VariableUtils.getReferredTypeFromTypeRefType(typeValue);
        }
        if (VariableUtils.isIntersectionType(typeValue)) {
            typeValue = VariableUtils.getEffectiveTypeFromIntersectionType(typeValue);
        }
        return typeValue;
    }

    public static boolean isTypeReferenceType(Value runtimeType) {
        return runtimeType.type().name().equals("io.ballerina.runtime.internal.types.BTypeReferenceType");
    }

    private static boolean isIntersectionType(Value runtimeType) {
        return runtimeType.type().name().equals("io.ballerina.runtime.internal.types.BIntersectionType");
    }

    private static Value getReferredTypeFromTypeRefType(Value typeValue) throws DebugVariableException {
        while (typeValue != null && VariableUtils.isTypeReferenceType(typeValue)) {
            typeValue = VariableUtils.getFieldValue(typeValue, FIELD_REFERRED_TYPE).orElse(null);
        }
        return typeValue;
    }

    private static Value getEffectiveTypeFromIntersectionType(Value typeValue) throws DebugVariableException {
        while (typeValue != null && VariableUtils.isIntersectionType(typeValue)) {
            typeValue = VariableUtils.getFieldValue(typeValue, FIELD_EFFECTIVE_TYPE).orElse(null);
        }
        return typeValue;
    }

    public static boolean isService(Value value) {
        try {
            return VariableUtils.getFieldValue(value, FIELD_TYPE).map(type -> type.type().name().endsWith(JVMValueType.BTYPE_SERVICE.getString())).orElse(false);
        }
        catch (DebugVariableException e) {
            return false;
        }
    }

    static boolean isJson(Value value) {
        try {
            Optional<Value> typeField = VariableUtils.getFieldValue(value, FIELD_TYPE);
            if (typeField.isEmpty()) {
                return false;
            }
            if (typeField.get().type().name().endsWith(JVMValueType.BTYPE_JSON.getString())) {
                return true;
            }
            Optional<Value> constraint = VariableUtils.getFieldValue(typeField.get(), FIELD_CONSTRAINT);
            return constraint.map(val -> val.type().name().endsWith(JVMValueType.BTYPE_JSON.getString())).orElse(false);
        }
        catch (DebugVariableException e) {
            return false;
        }
    }

    public static boolean isLambdaParamMap(LocalVariableProxyImpl localVar) {
        return localVar.name().matches(LAMBDA_PARAM_MAP_PATTERN);
    }

    public static Optional<Value> getFieldValue(Value parent, String fieldName) throws DebugVariableException {
        if (!(parent instanceof ObjectReference)) {
            return Optional.empty();
        }
        ObjectReference parentRef = (ObjectReference)parent;
        Field field = parentRef.referenceType().fieldByName(fieldName);
        if (field == null) {
            throw new DebugVariableException(String.format("No fields found with name: \"%s\", in %s", fieldName, parent));
        }
        return Optional.ofNullable(parentRef.getValue(field));
    }

    public static Optional<Method> getMethod(Value parent, String methodName) throws DebugVariableException {
        return VariableUtils.getMethod(parent, methodName, "");
    }

    public static Optional<Method> getMethod(Value parent, String methodName, String signature) throws DebugVariableException {
        List<Object> methods = new ArrayList();
        if (!(parent instanceof ObjectReference)) {
            return Optional.empty();
        }
        ObjectReference parentRef = (ObjectReference)parent;
        if (signature.isEmpty()) {
            methods = parentRef.referenceType().methodsByName(methodName);
        } else {
            List<Method> signatureMethods = parentRef.referenceType().methodsByName(methodName);
            for (Method method : signatureMethods) {
                if (!method.signature().matches(signature)) continue;
                methods.add(method);
            }
        }
        if (methods.isEmpty()) {
            throw new DebugVariableException(String.format("No methods found for name: \"%s\", in %s", methodName, parent));
        }
        if (methods.size() > 1) {
            throw new DebugVariableException(String.format("Overloaded methods found for name: \"%s\", in %s", methodName, parent));
        }
        return Optional.of((Method)methods.get(0));
    }

    public static String removeRedundantQuotes(String str) {
        while ((str = str.replaceAll(ADDITIONAL_QUOTES_REMOVE_REGEX, "")).startsWith("\"") || str.endsWith("\"")) {
        }
        return str;
    }

    public static Value getChildVarByName(BVariable variable, String childVarName) throws DebugVariableException, EvaluationException {
        if (variable instanceof IndexedCompoundVariable) {
            IndexedCompoundVariable indexedCompoundVariable = (IndexedCompoundVariable)variable;
            return indexedCompoundVariable.getChildByName(childVarName);
        }
        if (variable instanceof NamedCompoundVariable) {
            NamedCompoundVariable namedCompoundVariable = (NamedCompoundVariable)variable;
            return namedCompoundVariable.getChildByName(childVarName);
        }
        throw EvaluationException.createEvaluationException("Field access is not allowed for Ballerina simple types.");
    }
}

