/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.Method;
import com.sun.jdi.Value;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class BFuture
extends NamedCompoundVariable {
    private static final String FIELD_RESULT = "result";
    private static final String FIELD_IS_DONE = "isDone";
    private static final String FIELD_PANIC = "panic";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_CONSTRAINT = "constraint";
    private static final String FIELD_TYPENAME = "typeName";
    private static final String METHOD_LOCALIZEDMESSAGE = "getLocalizedMessage";

    public BFuture(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.FUTURE, value);
    }

    @Override
    public String computeValue() {
        return BVariableType.FUTURE.getString() + "<" + this.getConstrainedType() + ">";
    }

    @Override
    public Map<String, Value> computeChildVariables() {
        LinkedHashMap<String, Value> childVarMap = new LinkedHashMap<String, Value>();
        try {
            Optional<Method> method;
            Optional<Value> isDone = VariableUtils.getFieldValue(this.jvmValue, FIELD_IS_DONE);
            Optional<Value> result = VariableUtils.getFieldValue(this.jvmValue, FIELD_RESULT);
            Optional<Value> panic = VariableUtils.getFieldValue(this.jvmValue, FIELD_PANIC);
            isDone.ifPresent(value -> childVarMap.put(FIELD_IS_DONE, (Value)value));
            result.ifPresent(value -> childVarMap.put(FIELD_RESULT, (Value)value));
            if (panic.isPresent() && (method = VariableUtils.getMethod(panic.get(), METHOD_LOCALIZEDMESSAGE)).isPresent()) {
                Value stringValue = VariableUtils.invokeRemoteVMMethod(this.context, panic.get(), METHOD_LOCALIZEDMESSAGE, null);
                childVarMap.put(FIELD_PANIC, stringValue);
            }
            return childVarMap;
        }
        catch (Exception ignored) {
            return childVarMap;
        }
    }

    @Override
    public int getChildrenCount() {
        return 3;
    }

    private String getConstrainedType() {
        try {
            Optional<Value> futureType = VariableUtils.getFieldValue(this.jvmValue, FIELD_TYPE);
            Optional<Value> constrainedType = VariableUtils.getFieldValue(futureType.get(), FIELD_CONSTRAINT);
            Optional<Value> typeName = VariableUtils.getFieldValue(constrainedType.get(), FIELD_TYPENAME);
            return VariableUtils.getStringFrom(typeName.get());
        }
        catch (Exception e) {
            return "unknown";
        }
    }
}

