/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class BHandle
extends NamedCompoundVariable {
    public BHandle(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.HANDLE, value);
    }

    @Override
    public String computeValue() {
        try {
            Optional<Value> value = VariableUtils.getFieldValue(this.jvmValue, "value");
            if (value.isPresent() && value.get() instanceof ObjectReference) {
                return String.format("instance of %s", value.get().type().name());
            }
            return "unknown";
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    public Map<String, Value> computeChildVariables() {
        try {
            LinkedHashMap<String, Value> childVarMap = new LinkedHashMap<String, Value>();
            Optional<Value> value = VariableUtils.getFieldValue(this.jvmValue, "value");
            value.ifPresent(val -> childVarMap.put("value", (Value)val));
            return childVarMap;
        }
        catch (Exception ignored) {
            return new HashMap<String, Value>();
        }
    }

    @Override
    public int getChildrenCount() {
        return 1;
    }
}

