/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.IndexedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class BTuple
extends IndexedCompoundVariable {
    int tupleSize = -1;

    public BTuple(SuspendedContext context, String name, Value value) {
        super(context, name, BVariableType.TUPLE, value);
    }

    @Override
    public String computeValue() {
        try {
            return String.format("%s (size = %d)", this.getTupleType(this.jvmValue), this.getChildrenCount());
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    @Override
    public Either<Map<String, Value>, List<Value>> computeChildVariables(int start, int count) {
        try {
            Value value = this.jvmValue;
            if (!(value instanceof ObjectReference)) {
                return Either.forRight(new ArrayList());
            }
            ObjectReference jvmValueRef = (ObjectReference)value;
            Field valueField = jvmValueRef.referenceType().fieldByName("refValues");
            List<Value> children = count > 0 ? ((ArrayReference)jvmValueRef.getValue(valueField)).getValues(start, count) : ((ArrayReference)jvmValueRef.getValue(valueField)).getValues(0, this.getTupleSize(jvmValueRef));
            return Either.forRight(children);
        }
        catch (Exception ignored) {
            return Either.forRight(new ArrayList());
        }
    }

    @Override
    public int getChildrenCount() {
        return this.getTupleSize((ObjectReference)this.jvmValue);
    }

    private String getTupleType(Value jvmValue) {
        try {
            Optional<Value> tupleType = VariableUtils.getFieldValue(jvmValue, "tupleType");
            if (tupleType.isEmpty()) {
                return "unknown";
            }
            Optional<Value> subTypes = VariableUtils.getFieldValue(tupleType.get(), "tupleTypes");
            if (subTypes.isEmpty()) {
                return "unknown";
            }
            Optional<Value> typesArray = VariableUtils.getFieldValue(subTypes.get(), "elementData");
            if (typesArray.isEmpty()) {
                return "unknown";
            }
            List<Value> subValues = ((ArrayReference)typesArray.get()).getValues();
            StringJoiner tupleTypes = new StringJoiner(",");
            subValues.forEach(ref -> {
                if (ref instanceof ObjectReference) {
                    ObjectReference objectRef = (ObjectReference)ref;
                    Field typeNameField = objectRef.referenceType().fieldByName("typeName");
                    Value typeNameRef = objectRef.getValue(typeNameField);
                    tupleTypes.add(VariableUtils.getStringFrom(typeNameRef));
                }
            });
            return String.format("tuple[%s]", tupleTypes);
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private int getTupleSize(ObjectReference arrayRef) {
        if (this.tupleSize < 0) {
            this.populateTupleSize(arrayRef);
        }
        return this.tupleSize;
    }

    private void populateTupleSize(ObjectReference arrayRef) {
        List<Field> fields = arrayRef.referenceType().allFields();
        Field arraySizeField = arrayRef.getValues(fields).entrySet().stream().filter(fieldValueEntry -> fieldValueEntry.getValue() != null && ((Field)fieldValueEntry.getKey()).toString().endsWith("ArrayValue.size")).map(Map.Entry::getKey).toList().get(0);
        this.tupleSize = ((IntegerValue)arrayRef.getValue(arraySizeField)).value();
    }
}

