/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.parsers;

import com.google.gson.JsonElement;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.parsers.Kind;
import io.ballerina.parsers.PartialSTRequest;
import io.ballerina.parsers.STModificationUtil;
import io.ballerina.parsers.STResponse;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.ballerinalang.diagramutil.DiagramUtil;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.ballerinalang.langserver.commons.workspace.WorkspaceManager;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;
import org.eclipse.lsp4j.services.LanguageServer;

@JsonSegment(value="partialParser")
public class PartialParserService
implements ExtendedLanguageServerService {
    private LanguageServerContext serverContext;

    public void init(LanguageServer langServer, WorkspaceManager workspaceManager, LanguageServerContext serverContext) {
        this.serverContext = serverContext;
    }

    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<STResponse> getSTForSingleStatement(PartialSTRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String statement = STModificationUtil.getModifiedStatement(request.getCodeSnippet(), request.getStModification());
            String formattedSourceCode = this.getFormattedSourceForBlockStatement(statement);
            String sourceToBeParsed = this.getLinesWithoutLeadingTab(formattedSourceCode);
            StatementNode statementNode = NodeParser.parseStatement((String)sourceToBeParsed);
            JsonElement syntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)statementNode);
            STResponse response = new STResponse();
            response.setSyntaxTree(syntaxTreeJSON);
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<STResponse> getSTForExpression(PartialSTRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String expression = STModificationUtil.getModifiedStatement(request.getCodeSnippet(), request.getStModification());
            String formattedSourceCode = this.getFormattedSourceForExpression(expression);
            ExpressionNode expressionNode = NodeParser.parseExpression((String)formattedSourceCode);
            JsonElement syntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)expressionNode);
            STResponse response = new STResponse();
            response.setSyntaxTree(syntaxTreeJSON);
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<STResponse> getSTForModuleMembers(PartialSTRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String statement = STModificationUtil.getModifiedStatement(request.getCodeSnippet(), request.getStModification());
            String formattedSourceCode = this.getFormattedSource(statement);
            ModuleMemberDeclarationNode expressionNode = NodeParser.parseModuleMemberDeclaration((String)formattedSourceCode);
            JsonElement syntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)expressionNode);
            STResponse response = new STResponse();
            response.setSyntaxTree(syntaxTreeJSON);
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<STResponse> getSTForModulePart(PartialSTRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String statement = STModificationUtil.getModifiedStatement(request.getCodeSnippet(), request.getStModification());
            String formattedSourceCode = this.getFormattedSource(statement);
            ModulePartNode modulePartNode = (ModulePartNode)SyntaxTree.from((TextDocument)TextDocuments.from(formattedSourceCode)).rootNode();
            JsonElement syntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)modulePartNode);
            STResponse response = new STResponse();
            response.setSyntaxTree(syntaxTreeJSON);
            return response;
        });
    }

    @JsonRequest
    public CompletableFuture<STResponse> getSTForResource(PartialSTRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String serviceMemberSource = "service / on new http:Listener(9090) {" + request.getCodeSnippet() + "}";
            String statement = STModificationUtil.getModifiedStatement(serviceMemberSource, request.getStModification());
            String formattedSourceCode = this.getFormattedSource(statement);
            ModuleMemberDeclarationNode moduleMemberDeclaration = NodeParser.parseModuleMemberDeclaration((String)formattedSourceCode);
            ServiceDeclarationNode serviceDeclaration = (ServiceDeclarationNode)moduleMemberDeclaration;
            JsonElement syntaxTreeJSON = DiagramUtil.getSyntaxTreeJSON((NonTerminalNode)((FunctionDefinitionNode)serviceDeclaration.members().get(0)));
            STResponse response = new STResponse();
            response.setSyntaxTree(syntaxTreeJSON);
            return response;
        });
    }

    public String getName() {
        return "partialParser";
    }

    private String getFormattedSource(String statement) {
        String formattedSourceCode = statement;
        try {
            formattedSourceCode = Formatter.format((String)statement);
        }
        catch (FormatterException e) {
            String msg = "[Warn] Failed to apply formatting before parsing module member";
            ((ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class)).logMessage(new MessageParams(MessageType.Error, msg));
        }
        return formattedSourceCode;
    }

    private String getFormattedSourceForBlockStatement(String statement) {
        SyntaxTree syntaxTree = this.getSTForSource(statement, Kind.BLOCK_LEVEL_STATEMENT);
        String formattedSourceCode = statement;
        try {
            SyntaxTree formattedTree = Formatter.format((SyntaxTree)syntaxTree);
            ModulePartNode modulePartNode = (ModulePartNode)formattedTree.rootNode();
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)modulePartNode.members().get(0);
            FunctionBodyBlockNode functionBodyBlockNode = (FunctionBodyBlockNode)functionDefinitionNode.functionBody();
            formattedSourceCode = ((StatementNode)functionBodyBlockNode.statements().get(0)).toSourceCode();
        }
        catch (NullPointerException | FormatterException e) {
            String msg = "[Warn] Failed to apply formatting before parsing statement";
            ((ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class)).logMessage(new MessageParams(MessageType.Error, msg));
        }
        return formattedSourceCode;
    }

    private String getFormattedSourceForExpression(String expression) {
        SyntaxTree syntaxTree = this.getSTForSource(expression, Kind.EXPRESSION);
        String formattedSourceCode = expression;
        try {
            SyntaxTree formattedTree = Formatter.format((SyntaxTree)syntaxTree);
            ModulePartNode modulePartNode = (ModulePartNode)formattedTree.rootNode();
            ModuleVariableDeclarationNode moduleVariableDeclarationNode = (ModuleVariableDeclarationNode)modulePartNode.members().get(0);
            ExpressionNode expressionNode = moduleVariableDeclarationNode.initializer().orElse(null);
            formattedSourceCode = Objects.requireNonNull(expressionNode).toSourceCode();
        }
        catch (NullPointerException | FormatterException e) {
            String msg = "[Warn] Failed to apply formatting before parsing expression";
            ((ExtendedLanguageClient)this.serverContext.get(ExtendedLanguageClient.class)).logMessage(new MessageParams(MessageType.Error, msg));
        }
        return formattedSourceCode;
    }

    private String getLinesWithoutLeadingTab(String statement) {
        StringJoiner sj = new StringJoiner(System.getProperty("line.separator"));
        Stream<String> lines = statement.lines();
        lines.iterator().forEachRemaining(line -> sj.add(line.replaceFirst(String.format("^ {%d}", 4), "")));
        return sj.toString();
    }

    private SyntaxTree getSTForSource(String source, Kind kind) {
        String wrappedSource = source;
        if (kind == Kind.BLOCK_LEVEL_STATEMENT) {
            wrappedSource = String.format("public function main() { %s };", source);
        } else if (kind == Kind.EXPRESSION) {
            wrappedSource = String.format("var expr = %s;", source);
        }
        TextDocument textDocument = TextDocuments.from(wrappedSource);
        return SyntaxTree.from((TextDocument)textDocument);
    }
}

