/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.parsers;

import io.ballerina.parsers.STModification;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextDocuments;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextRange;

public final class STModificationUtil {
    private STModificationUtil() {
    }

    static String getModifiedStatement(String oldStatement, STModification stModification) {
        if (stModification == null) {
            return oldStatement;
        }
        TextDocument oldTextDocument = TextDocuments.from(oldStatement);
        TextEdit[] textEdits = new TextEdit[]{STModificationUtil.constructEdit(oldTextDocument, stModification)};
        TextDocumentChange textDocumentChange = TextDocumentChange.from(textEdits);
        TextDocument newTextDocument = oldTextDocument.apply(textDocumentChange);
        return newTextDocument.toString();
    }

    private static TextEdit constructEdit(TextDocument oldTextDocument, STModification stModification) {
        LinePosition startLinePos = LinePosition.from(stModification.getStartLine(), stModification.getStartColumn());
        LinePosition endLinePos = LinePosition.from(stModification.getEndLine(), stModification.getEndColumn());
        int startOffset = oldTextDocument.textPositionFrom(startLinePos);
        int endOffset = oldTextDocument.textPositionFrom(endLinePos);
        return TextEdit.from(TextRange.from(startOffset, endOffset - startOffset), stModification.getNewCodeSnippet());
    }
}

