/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels;

import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.asyncapi.v20.visitors.AsyncApi20Traverser;
import io.apicurio.datamodels.models.asyncapi.v21.visitors.AsyncApi21Traverser;
import io.apicurio.datamodels.models.asyncapi.v22.visitors.AsyncApi22Traverser;
import io.apicurio.datamodels.models.asyncapi.v23.visitors.AsyncApi23Traverser;
import io.apicurio.datamodels.models.asyncapi.v24.visitors.AsyncApi24Traverser;
import io.apicurio.datamodels.models.asyncapi.v25.visitors.AsyncApi25Traverser;
import io.apicurio.datamodels.models.asyncapi.v26.visitors.AsyncApi26Traverser;
import io.apicurio.datamodels.models.openapi.v20.visitors.OpenApi20Traverser;
import io.apicurio.datamodels.models.openapi.v30.visitors.OpenApi30Traverser;
import io.apicurio.datamodels.models.openapi.v31.visitors.OpenApi31Traverser;
import io.apicurio.datamodels.models.visitors.ReverseTraverser;
import io.apicurio.datamodels.models.visitors.Visitor;

public class VisitorUtil {
    public static void visitTree(Node node, Visitor visitor, TraverserDirection direction) {
        ModelType type = node.root().modelType();
        Visitor traverser = null;
        if (direction == TraverserDirection.up) {
            traverser = new ReverseTraverser(visitor);
        } else {
            switch (type) {
                case ASYNCAPI20: {
                    traverser = new AsyncApi20Traverser(visitor);
                    break;
                }
                case ASYNCAPI21: {
                    traverser = new AsyncApi21Traverser(visitor);
                    break;
                }
                case ASYNCAPI22: {
                    traverser = new AsyncApi22Traverser(visitor);
                    break;
                }
                case ASYNCAPI23: {
                    traverser = new AsyncApi23Traverser(visitor);
                    break;
                }
                case ASYNCAPI24: {
                    traverser = new AsyncApi24Traverser(visitor);
                    break;
                }
                case ASYNCAPI25: {
                    traverser = new AsyncApi25Traverser(visitor);
                    break;
                }
                case ASYNCAPI26: {
                    traverser = new AsyncApi26Traverser(visitor);
                    break;
                }
                case OPENAPI20: {
                    traverser = new OpenApi20Traverser(visitor);
                    break;
                }
                case OPENAPI30: {
                    traverser = new OpenApi30Traverser(visitor);
                    break;
                }
                case OPENAPI31: {
                    traverser = new OpenApi31Traverser(visitor);
                }
            }
        }
        if (traverser == null) {
            throw new RuntimeException("Traverser not found for type: " + type);
        }
        traverser.traverse(node);
    }
}

