/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.refs;

import io.apicurio.datamodels.refs.Reference;
import java.util.Stack;

public class ReferenceContext {
    private final Stack<Reference> refStack = new Stack();

    public ReferenceContext() {
    }

    private ReferenceContext(Stack<Reference> fromStack) {
        this.refStack.addAll(fromStack);
    }

    public ReferenceContext append(Reference reference) {
        ReferenceContext newContext = new ReferenceContext(this.refStack);
        newContext.refStack.add(reference);
        return newContext;
    }

    public Reference canonicalizeRef(Reference reference) {
        if (this.refStack.isEmpty() || reference.getAbsPart() != null) {
            return reference;
        }
        return new Reference(this.absolutePartFromStack(), reference.getRelPart());
    }

    private String absolutePartFromStack() {
        for (int idx = this.refStack.size() - 1; idx >= 0; --idx) {
            Reference reference = (Reference)this.refStack.get(idx);
            String abs = reference.getAbsPart();
            if (abs == null) continue;
            return abs;
        }
        return null;
    }
}

