/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.application;

import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.ballerina.asyncapi.codegenerator.application.Application;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.controller.AsyncApiSpecController;
import io.ballerina.asyncapi.codegenerator.controller.DispatcherController;
import io.ballerina.asyncapi.codegenerator.controller.ListenerController;
import io.ballerina.asyncapi.codegenerator.controller.SchemaController;
import io.ballerina.asyncapi.codegenerator.controller.ServiceTypesController;
import io.ballerina.asyncapi.codegenerator.entity.ServiceType;
import io.ballerina.asyncapi.codegenerator.repository.FileRepository;
import io.ballerina.asyncapi.codegenerator.repository.FileRepositoryImpl;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;

public class CodeGenerator
implements Application {
    private final FileRepository fileRepository;
    private static final PrintStream outStream = System.err;

    public CodeGenerator() {
        this.fileRepository = new FileRepositoryImpl();
    }

    public CodeGenerator(FileRepository fileRepository) {
        this.fileRepository = fileRepository;
    }

    @Override
    public void generate(String specPath, String outputPath) throws BallerinaAsyncApiException {
        String dispatcherContent;
        String asyncApiSpecJson = this.getFileContent(this.fileRepository, specPath);
        AsyncApiSpecController specController = new AsyncApiSpecController(asyncApiSpecJson);
        Map<String, AsyncApiSchema> schemas = specController.getSchemas();
        List<ServiceType> serviceTypes = specController.getServiceTypes();
        String eventIdentifierType = specController.getEventIdentifierType();
        String eventIdentifierPath = specController.getEventIdentifierPath();
        String dataTypesTemplate = this.fileRepository.getFileContentFromResources("data_types.bal");
        SchemaController schemaController = new SchemaController(schemas);
        String dataTypesBalContent = schemaController.generateBalCode(dataTypesTemplate);
        ServiceTypesController serviceTypesController = new ServiceTypesController(serviceTypes);
        String serviceTypesBalContent = serviceTypesController.generateBalCode("");
        String listenerTemplate = this.fileRepository.getFileContentFromResources("listener.bal");
        ListenerController listenerController = new ListenerController(serviceTypes);
        String listenerBalContent = listenerController.generateBalCode(listenerTemplate);
        DispatcherController dispatcherController = new DispatcherController(serviceTypes, eventIdentifierType, eventIdentifierPath);
        if (eventIdentifierType.equals("body")) {
            String dispatcherTemplateForEventIdentifierInBody = this.fileRepository.getFileContentFromResources("dispatcher_service.bal");
            dispatcherContent = dispatcherController.generateBalCode(dispatcherTemplateForEventIdentifierInBody);
        } else {
            String dispatcherTemplateForEventIdentifierInHeader = this.fileRepository.getFileContentFromResources("dispatcher_service_for_event_identifier_in_header.bal");
            dispatcherContent = dispatcherController.generateBalCode(dispatcherTemplateForEventIdentifierInHeader);
        }
        String outputDirectory = this.getOutputDirectory(outputPath);
        this.fileRepository.writeToFile(outputDirectory.concat("data_types.bal"), dataTypesBalContent);
        this.fileRepository.writeToFile(outputDirectory.concat("service_types.bal"), serviceTypesBalContent);
        this.fileRepository.writeToFile(outputDirectory.concat("listener.bal"), listenerBalContent);
        this.fileRepository.writeToFile(outputDirectory.concat("dispatcher_service.bal"), dispatcherContent);
        outStream.println("Following files were generated successfully:\n--data_types.bal\n--service_types.bal\n--listener.bal\n--dispatcher_service.bal");
    }

    private String getOutputDirectory(String outputPath) {
        if (outputPath.endsWith("/")) {
            return outputPath;
        }
        return outputPath.concat("/");
    }

    private String getFileContent(FileRepository fileRepository, String specPath) throws BallerinaAsyncApiException {
        String asyncApiSpecYaml = fileRepository.getFileContent(specPath);
        if (specPath.endsWith(".json")) {
            fileRepository.validateJson(asyncApiSpecYaml);
            return asyncApiSpecYaml;
        }
        if (specPath.endsWith("yaml") || specPath.endsWith("yml")) {
            return fileRepository.convertYamlToJson(asyncApiSpecYaml);
        }
        throw new BallerinaAsyncApiException("Unknown file type: ".concat(specPath));
    }
}

