/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.controller;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.controller.BalController;
import io.ballerina.asyncapi.codegenerator.entity.ServiceType;
import io.ballerina.asyncapi.codegenerator.usecase.GenerateServiceTypeNode;
import io.ballerina.asyncapi.codegenerator.usecase.GenerateUnionDescriptorNode;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class ServiceTypesController
implements BalController {
    private final List<ServiceType> serviceTypes;

    public ServiceTypesController(List<ServiceType> serviceTypes) {
        this.serviceTypes = serviceTypes;
    }

    @Override
    public String generateBalCode(String balTemplate) throws BallerinaAsyncApiException {
        ArrayList<Object> serviceNodes = new ArrayList<Object>();
        ArrayList<TypeDescriptorNode> serviceTypeNodes = new ArrayList<TypeDescriptorNode>();
        for (ServiceType service : this.serviceTypes) {
            GenerateServiceTypeNode generateServiceTypeNode = new GenerateServiceTypeNode(service.getServiceTypeName(), service.getRemoteFunctions());
            TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)generateServiceTypeNode.generate();
            serviceTypeNodes.add((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)typeDefinitionNode.typeName().text())));
            serviceNodes.add(typeDefinitionNode);
        }
        GenerateUnionDescriptorNode generateUnionNode = new GenerateUnionDescriptorNode(serviceTypeNodes, "GenericServiceType");
        serviceNodes.add((ModuleMemberDeclarationNode)generateUnionNode.generate());
        TextDocument textDocument = TextDocuments.from((String)balTemplate);
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        ModulePartNode oldRoot = (ModulePartNode)syntaxTree.rootNode();
        ModulePartNode newRoot = oldRoot.modify().withMembers(oldRoot.members().addAll(serviceNodes)).apply();
        SyntaxTree modifiedTree = syntaxTree.replaceNode((Node)oldRoot, (Node)newRoot);
        try {
            return Formatter.format((SyntaxTree)modifiedTree).toSourceCode();
        }
        catch (FormatterException e) {
            throw new BallerinaAsyncApiException("Could not format the generated code, may be a syntax issue in the generated code", e);
        }
    }
}

