/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiDocument;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.configuration.Constants;
import io.ballerina.asyncapi.codegenerator.usecase.Extractor;
import io.ballerina.asyncapi.codegenerator.usecase.utils.ExtensionExtractor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExtractIdentifierPathFromSpec
implements Extractor {
    private final AsyncApiDocument asyncApiSpec;

    public ExtractIdentifierPathFromSpec(AsyncApiDocument asyncApiSpec) {
        this.asyncApiSpec = asyncApiSpec;
    }

    public String extract() throws BallerinaAsyncApiException {
        JsonNode identifier = ExtensionExtractor.getExtensions(this.asyncApiSpec).get("x-ballerina-event-identifier");
        Iterator values = identifier.fields();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        while (values.hasNext()) {
            Map.Entry entry = (Map.Entry)values.next();
            valuesMap.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
        }
        StringBuilder eventPathString = new StringBuilder();
        if (((String)valuesMap.get("type")).equals("header")) {
            if (!valuesMap.containsKey("name")) {
                throw new BallerinaAsyncApiException("name".concat(" attribute is not found within the attribute ".concat("x-ballerina-event-identifier").concat(" in the Async API Specification")));
            }
            String identifierName = (String)valuesMap.get("name");
            if (Constants.BAL_KEYWORDS.stream().anyMatch(identifierName::equals)) {
                eventPathString.append("'").append(identifierName);
            } else {
                eventPathString.append(identifierName);
            }
        } else if (((String)valuesMap.get("type")).equals("body")) {
            if (!valuesMap.containsKey("path")) {
                throw new BallerinaAsyncApiException("path".concat(" attribute is not found within the attribute ".concat("x-ballerina-event-identifier").concat(" in the Async API Specification")));
            }
            String identifierPath = (String)valuesMap.get("path");
            String[] pathParts = identifierPath.split("\\.");
            String prefix = "";
            for (String eventPathPart : pathParts) {
                eventPathString.append(prefix);
                prefix = ".";
                if (Constants.BAL_KEYWORDS.stream().anyMatch(eventPathPart::equals)) {
                    eventPathString.append("'").append(eventPathPart);
                    continue;
                }
                eventPathString.append(eventPathPart);
            }
        }
        return eventPathString.toString();
    }
}

