/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import com.fasterxml.jackson.databind.JsonNode;
import io.apicurio.datamodels.models.asyncapi.AsyncApiDocument;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.usecase.Extractor;
import io.ballerina.asyncapi.codegenerator.usecase.utils.ExtensionExtractor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExtractIdentifierTypeFromSpec
implements Extractor {
    private final AsyncApiDocument asyncApiSpec;

    public ExtractIdentifierTypeFromSpec(AsyncApiDocument asyncApiSpec) {
        this.asyncApiSpec = asyncApiSpec;
    }

    public String extract() throws BallerinaAsyncApiException {
        if (!ExtensionExtractor.getExtensions(this.asyncApiSpec).containsKey("x-ballerina-event-identifier")) {
            throw new BallerinaAsyncApiException("x-ballerina-event-identifier".concat(" attribute is not found in the Async API Specification"));
        }
        JsonNode identifier = ExtensionExtractor.getExtensions(this.asyncApiSpec).get("x-ballerina-event-identifier");
        Iterator values = identifier.fields();
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        while (values.hasNext()) {
            Map.Entry entry = (Map.Entry)values.next();
            valuesMap.put((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
        }
        if (!valuesMap.containsKey("type")) {
            throw new BallerinaAsyncApiException("type".concat(" attribute is not found within the attribute ".concat("x-ballerina-event-identifier").concat(" in the Async API Specification")));
        }
        StringBuilder eventIdentifierType = new StringBuilder("");
        if (((String)valuesMap.get("type")).equals("header")) {
            eventIdentifierType.append("header");
        } else if (((String)valuesMap.get("type")).equals("body")) {
            eventIdentifierType.append("body");
        } else {
            throw new BallerinaAsyncApiException("header".concat(" or ").concat("body").concat(" is not provided as the value of ").concat("type").concat(" attribute within the attribute ".concat("x-ballerina-event-identifier").concat(" in the Async API Specification")));
        }
        return eventIdentifierType.toString();
    }
}

