/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.entity.RemoteFunction;
import io.ballerina.asyncapi.codegenerator.entity.ServiceType;
import io.ballerina.asyncapi.codegenerator.usecase.Generator;
import io.ballerina.asyncapi.codegenerator.usecase.utils.CodegenUtils;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MatchClauseNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;

public class GenerateMatchStatementNode
implements Generator {
    private final CodegenUtils codegenUtils = new CodegenUtils();
    private final List<ServiceType> serviceTypes;
    private final String eventIdentifierPath;

    public GenerateMatchStatementNode(List<ServiceType> serviceTypes, String eventIdentifierPath) {
        this.serviceTypes = serviceTypes;
        this.eventIdentifierPath = eventIdentifierPath;
    }

    public MatchStatementNode generate() throws BallerinaAsyncApiException {
        if (this.eventIdentifierPath.isEmpty()) {
            throw new BallerinaAsyncApiException("Event identifier path is empty");
        }
        if (this.serviceTypes.isEmpty()) {
            throw new BallerinaAsyncApiException("No service types found, probably there are no channels defined in the async api spec");
        }
        ArrayList<MatchClauseNode> matchClauseNodes = new ArrayList<MatchClauseNode>();
        for (ServiceType service : this.serviceTypes) {
            String serviceName = service.getServiceTypeName();
            for (RemoteFunction remoteFunction : service.getRemoteFunctions()) {
                String eventName = remoteFunction.getEventName();
                String formattedEventName = this.codegenUtils.getFunctionNameByEventName(eventName);
                MatchClauseNode matchClause = this.generateMatchClause(serviceName, eventName, formattedEventName);
                matchClauseNodes.add(matchClause);
            }
        }
        return NodeFactory.createMatchStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.MATCH_KEYWORD), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.eventIdentifierPath)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(matchClauseNodes), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private MatchClauseNode generateMatchClause(String serviceTypeName, String eventName, String formattedEventName) {
        SeparatedNodeList argumentsList = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"genericDataType"))), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + eventName + "\"")))), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + this.codegenUtils.getServiceTypeNameByServiceName(serviceTypeName) + "\"")))), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + formattedEventName + "\""))))});
        MethodCallExpressionNode methodCallExpressionNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"executeRemoteFunc")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)argumentsList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        CheckExpressionNode lineNode = NodeFactory.createCheckExpressionNode((SyntaxKind)SyntaxKind.CHECK_EXPRESSION, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)methodCallExpressionNode);
        BlockStatementNode blockStatement = NodeFactory.createBlockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeFactory.createExpressionStatementNode((SyntaxKind)SyntaxKind.CALL_STATEMENT, (ExpressionNode)lineNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN))}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createMatchClauseNode((SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + eventName + "\""), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()))}), null, (Token)AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.RIGHT_DOUBLE_ARROW_TOKEN, (String)"=>", (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()), (BlockStatementNode)blockStatement);
    }
}

