/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSchema;
import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.usecase.Generator;
import io.ballerina.asyncapi.codegenerator.usecase.utils.CodegenUtils;
import io.ballerina.asyncapi.codegenerator.usecase.utils.DocCommentsUtils;
import io.ballerina.asyncapi.codegenerator.usecase.utils.ExtensionExtractor;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenerateModuleMemberDeclarationNode
implements Generator {
    private final Map.Entry<String, AsyncApiSchema> recordFields;
    private final CodegenUtils codegenUtils = new CodegenUtils();
    private final DocCommentsUtils commentsUtils = new DocCommentsUtils();

    public GenerateModuleMemberDeclarationNode(Map.Entry<String, AsyncApiSchema> recordFields) {
        this.recordFields = recordFields;
    }

    public ModuleMemberDeclarationNode generate() throws BallerinaAsyncApiException {
        ArrayList<String> requiredList;
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)this.codegenUtils.getValidName(this.codegenUtils.escapeIdentifier(this.recordFields.getKey().trim()), true));
        ArrayList schemaDoc = new ArrayList();
        MarkdownDocumentationNode documentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(schemaDoc));
        MetadataNode metadataNode = NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        ArrayList<Node> recordFieldList = new ArrayList<Node>();
        List<String> list = requiredList = this.recordFields.getValue().getRequired() != null ? this.recordFields.getValue().getRequired() : new ArrayList<String>();
        if (this.recordFields.getValue().getEnum() != null) {
            ArrayList<Object> enums = new ArrayList<Object>();
            for (int i = 0; i < this.recordFields.getValue().getEnum().size(); ++i) {
                if (i > 0) {
                    enums.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                }
                String enumName = ((TextNode)this.recordFields.getValue().getEnum().get(i)).textValue();
                enums.add(NodeFactory.createEnumMemberNode(null, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)enumName), null, null));
            }
            return NodeFactory.createEnumDeclarationNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ENUM_KEYWORD), (IdentifierToken)typeName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(enums), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        }
        if (this.recordFields.getValue().getProperties() == null && this.recordFields.getValue().getType() != null) {
            TypeDescriptorNode fieldTypeName = this.getTypeDescriptorNode(this.recordFields.getValue());
            TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)NodeFactory.createOptionalTypeDescriptorNode((Node)fieldTypeName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN)), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            return typeDefinitionNode;
        }
        if (this.recordFields.getValue().getProperties() != null) {
            for (Map.Entry<String, Schema> field : this.recordFields.getValue().getProperties().entrySet()) {
                AbstractMap.SimpleEntry<String, AsyncApiSchema> castedField = new AbstractMap.SimpleEntry<String, AsyncApiSchema>(field.getKey(), (AsyncApiSchema)field.getValue());
                this.addRecordField(requiredList, recordFieldList, castedField);
            }
        } else if (this.recordFields.getValue().hasExtraProperties()) {
            // empty if block
        }
        NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFieldList);
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)fieldNodes, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        return typeDefinitionNode;
    }

    private void addRecordField(List<String> required, List<Node> recordFieldList, Map.Entry<String, AsyncApiSchema> field) throws BallerinaAsyncApiException {
        ArrayList<MarkdownDocumentationLineNode> schemaDoc = new ArrayList<MarkdownDocumentationLineNode>();
        String fieldName = this.codegenUtils.escapeIdentifier(field.getKey().trim());
        if (field.getValue().getTitle() != null) {
            schemaDoc.addAll(this.commentsUtils.createDescriptionComments(field.getValue().getTitle(), false));
        } else if (field.getValue().getDescription() != null) {
            schemaDoc.addAll(this.commentsUtils.createDescriptionComments(field.getValue().getDescription(), false));
        }
        IdentifierToken fieldNameToken = AbstractNodeFactory.createIdentifierToken((String)fieldName);
        TypeDescriptorNode fieldTypeName = this.getTypeDescriptorNode(field.getValue());
        IdentifierToken semicolonToken = AbstractNodeFactory.createIdentifierToken((String)";");
        IdentifierToken questionMarkToken = AbstractNodeFactory.createIdentifierToken((String)"?");
        MarkdownDocumentationNode documentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(schemaDoc));
        MetadataNode metadataNode = NodeFactory.createMetadataNode((Node)documentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        RecordFieldNode recordFieldNode = required != null ? (!required.contains(field.getKey().trim()) ? NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldNameToken, (Token)questionMarkToken, (Token)semicolonToken) : NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldNameToken, null, (Token)semicolonToken)) : NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)fieldTypeName, (Token)fieldNameToken, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldList.add((Node)recordFieldNode);
    }

    private TypeDescriptorNode getTypeDescriptorNode(AsyncApiSchema schema) throws BallerinaAsyncApiException {
        if (schema.getType() != null || schema.getProperties() != null) {
            TypeDescriptorNode originalTypeDesc = this.getTypeDescriptorNodeForObjects(schema);
            return this.addNullableType(schema, originalTypeDesc);
        }
        if (schema instanceof Referenceable && ((Referenceable)((Object)schema)).get$ref() != null) {
            String type = this.codegenUtils.extractReferenceType(((Referenceable)((Object)schema)).get$ref());
            type = this.codegenUtils.getValidName(type, true);
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
            BuiltinSimpleNameReferenceNode originalTypeDesc = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
            return this.addNullableType(schema, (TypeDescriptorNode)originalTypeDesc);
        }
        String type = "anydata";
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
        return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
    }

    private TypeDescriptorNode getTypeDescriptorNodeForObjects(AsyncApiSchema schema) throws BallerinaAsyncApiException {
        if (schema.getProperties() != null) {
            return this.getRecordTypeDescriptorNode(schema);
        }
        if (schema.getType() != null) {
            return this.getTypeDescriptorNodeForPreDefined(schema);
        }
        throw new BallerinaAsyncApiException("Unsupported Async Api Spec data type `" + schema.getType() + "`");
    }

    private TypeDescriptorNode getTypeDescriptorNodeForPreDefined(AsyncApiSchema schema) throws BallerinaAsyncApiException {
        switch (schema.getType()) {
            case "integer": 
            case "string": 
            case "boolean": {
                String type = GenerateModuleMemberDeclarationNode.convertAsyncApiTypeToBallerina(schema.getType().trim());
                IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
                return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
            }
            case "number": {
                String type = GenerateModuleMemberDeclarationNode.convertAsyncApiTypeToBallerina(schema.getType().trim());
                if (schema.getFormat() != null) {
                    type = GenerateModuleMemberDeclarationNode.convertAsyncApiTypeToBallerina(schema.getFormat().trim());
                }
                IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
                return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
            }
            case "array": {
                return this.getTypeDescriptorNodeForArraySchema(schema);
            }
            case "object": {
                IdentifierToken typeName;
                if (schema instanceof Referenceable && ((Referenceable)((Object)schema)).get$ref() != null) {
                    String type = this.codegenUtils.getValidName(this.codegenUtils.extractReferenceType(((Referenceable)((Object)schema)).get$ref()), true);
                    typeName = AbstractNodeFactory.createIdentifierToken((String)type);
                } else {
                    typeName = AbstractNodeFactory.createIdentifierToken((String)GenerateModuleMemberDeclarationNode.convertAsyncApiTypeToBallerina(schema.getType().trim()));
                }
                return NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
            }
        }
        throw new BallerinaAsyncApiException("Unsupported Async Api Spec data type `" + schema.getType() + "`");
    }

    private RecordTypeDescriptorNode getRecordTypeDescriptorNode(AsyncApiSchema schema) throws BallerinaAsyncApiException {
        Map<String, Schema> properties = schema.getProperties();
        IdentifierToken recordKeyWord = AbstractNodeFactory.createIdentifierToken((String)"record ");
        IdentifierToken bodyStartDelimiter = AbstractNodeFactory.createIdentifierToken((String)"{ ");
        IdentifierToken bodyEndDelimiter = AbstractNodeFactory.createIdentifierToken((String)"} ");
        ArrayList<Node> recordFList = new ArrayList<Node>();
        List<String> required = schema.getRequired();
        for (Map.Entry<String, Schema> property : properties.entrySet()) {
            AbstractMap.SimpleEntry<String, AsyncApiSchema> castedProperty = new AbstractMap.SimpleEntry<String, AsyncApiSchema>(property.getKey(), (AsyncApiSchema)property.getValue());
            this.addRecordField(required, recordFList, castedProperty);
        }
        NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFList);
        return NodeFactory.createRecordTypeDescriptorNode((Token)recordKeyWord, (Token)bodyStartDelimiter, (NodeList)fieldNodes, null, (Token)bodyEndDelimiter);
    }

    public static String convertAsyncApiTypeToBallerina(String type) throws BallerinaAsyncApiException {
        return switch (type) {
            case "integer" -> "int";
            case "string" -> "string";
            case "boolean" -> "boolean";
            case "array" -> "[]";
            case "object" -> "record {}";
            case "decimal", "number" -> "decimal";
            case "double", "float" -> "float";
            default -> throw new BallerinaAsyncApiException("Unsupported Async Api Spec data type `" + type + "`");
        };
    }

    public TypeDescriptorNode getTypeDescriptorNodeForArraySchema(AsyncApiSchema schema) throws BallerinaAsyncApiException {
        if (schema.getItems() != null) {
            IdentifierToken openSBracketToken = AbstractNodeFactory.createIdentifierToken((String)"[");
            AsyncApiSchema schemaItem = (AsyncApiSchema)schema.getItems();
            IdentifierToken closeSBracketToken = AbstractNodeFactory.createIdentifierToken((String)"]");
            ArrayDimensionNode arrayDimensionNode = NodeFactory.createArrayDimensionNode((Token)openSBracketToken, null, (Token)closeSBracketToken);
            if (schemaItem instanceof Referenceable && ((Referenceable)((Object)schemaItem)).get$ref() != null) {
                String type = this.codegenUtils.getValidName(this.codegenUtils.extractReferenceType(((Referenceable)((Object)schemaItem)).get$ref()), true);
                IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
                BuiltinSimpleNameReferenceNode memberTypeDesc = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
                return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)memberTypeDesc, (NodeList)AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode}));
            }
            if (schemaItem.getType() != null && (schemaItem.getType().equals("array") || schemaItem.getType().equals("object"))) {
                TypeDescriptorNode memberTypeDesc = this.getTypeDescriptorNode(schemaItem);
                return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)memberTypeDesc, (NodeList)AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode}));
            }
            if (schemaItem.getType() != null) {
                String type = schemaItem.getType();
                IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)GenerateModuleMemberDeclarationNode.convertAsyncApiTypeToBallerina(type));
                BuiltinSimpleNameReferenceNode memberTypeDesc = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
                return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)memberTypeDesc, (NodeList)AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode}));
            }
            String type = "anydata";
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)type);
            BuiltinSimpleNameReferenceNode memberTypeDesc = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)typeName);
            return NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)memberTypeDesc, (NodeList)AbstractNodeFactory.createNodeList((Node[])new ArrayDimensionNode[]{arrayDimensionNode}));
        }
        throw new BallerinaAsyncApiException("Array does not contain the 'items' attribute");
    }

    private TypeDescriptorNode addNullableType(AsyncApiSchema schema, TypeDescriptorNode originalTypeDesc) {
        JsonNode identifier;
        Map<String, JsonNode> ext = ExtensionExtractor.getExtensions(schema);
        if (ExtensionExtractor.getExtensions(schema).containsKey("x-nullable") && (identifier = ExtensionExtractor.getExtensions(schema).get("x-nullable")).asText().equals("true")) {
            return NodeFactory.createOptionalTypeDescriptorNode((Node)originalTypeDesc, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        }
        return originalTypeDesc;
    }
}

