/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.entity.RemoteFunction;
import io.ballerina.asyncapi.codegenerator.usecase.Generator;
import io.ballerina.asyncapi.codegenerator.usecase.utils.CodegenUtils;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.ArrayList;
import java.util.List;

public class GenerateServiceTypeNode
implements Generator {
    private final String serviceTypeName;
    private final List<RemoteFunction> remoteFunctionNames;
    private final CodegenUtils codegenUtils = new CodegenUtils();

    public GenerateServiceTypeNode(String serviceTypeName, List<RemoteFunction> remoteFunctionNames) {
        this.serviceTypeName = serviceTypeName;
        this.remoteFunctionNames = remoteFunctionNames;
    }

    public TypeDefinitionNode generate() throws BallerinaAsyncApiException {
        if (this.remoteFunctionNames.isEmpty()) {
            throw new BallerinaAsyncApiException("Remote functions list is empty in the service type " + this.serviceTypeName);
        }
        ArrayList remoteFunctions = new ArrayList();
        OptionalTypeDescriptorNode returnType = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ERROR_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnType);
        this.remoteFunctionNames.forEach(remoteFunction -> {
            ArrayList<RequiredParameterNode> parameterList = new ArrayList<RequiredParameterNode>();
            String eventType = this.codegenUtils.getValidName(this.codegenUtils.escapeIdentifier(remoteFunction.getEventType().trim()), true);
            BuiltinSimpleNameReferenceNode typeNode = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)eventType));
            parameterList.add(NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)typeNode, (Token)AbstractNodeFactory.createIdentifierToken((String)"event")));
            MethodDeclarationNode methodDeclarationNode = NodeFactory.createMethodDeclarationNode((SyntaxKind)SyntaxKind.METHOD_DECLARATION, null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.REMOTE_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)this.codegenUtils.getFunctionNameByEventName(remoteFunction.getEventName())), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)NodeFactory.createFunctionSignatureNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(parameterList), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN), (ReturnTypeDescriptorNode)returnTypeDescriptorNode), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            remoteFunctions.add(methodDeclarationNode);
        });
        IdentifierToken serviceTypeToken = AbstractNodeFactory.createIdentifierToken((String)this.codegenUtils.getServiceTypeNameByServiceName(this.serviceTypeName));
        ObjectTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createObjectTypeDescriptorNode((NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SERVICE_KEYWORD)}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OBJECT_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(remoteFunctions), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createTypeDefinitionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)serviceTypeToken, (Node)recordTypeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }
}

