/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.codegenerator.usecase.utils;

import io.ballerina.asyncapi.codegenerator.configuration.BallerinaAsyncApiException;
import io.ballerina.asyncapi.codegenerator.configuration.Constants;
import java.util.Locale;
import java.util.Optional;

public class CodegenUtils {
    public String escapeIdentifier(String identifier) {
        block10: {
            block9: {
                if (((String)identifier).matches("\\S*\\d+\\S*")) {
                    return "'" + (String)identifier;
                }
                if (!((String)identifier).matches("\\b[_a-zA-Z][_a-zA-Z0-9]*\\b")) break block9;
                if (!Constants.BAL_KEYWORDS.stream().anyMatch(((String)identifier)::equals)) break block10;
            }
            if (((String)(identifier = ((String)identifier).replaceAll("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])", "\\\\$1"))).endsWith("?")) {
                if (((String)identifier).charAt(((String)identifier).length() - 2) == '\\') {
                    StringBuilder stringBuilder = new StringBuilder((String)identifier);
                    stringBuilder.deleteCharAt(((String)identifier).length() - 2);
                    identifier = stringBuilder.toString();
                }
                if (Constants.BAL_KEYWORDS.stream().anyMatch(Optional.of(identifier).filter(sStr -> sStr.length() != 0).map(sStr -> sStr.substring(0, sStr.length() - 1)).orElse((String)identifier)::equals)) {
                    identifier = "'" + (String)identifier;
                }
            } else if (Constants.BAL_KEYWORDS.stream().anyMatch(((String)identifier)::equals)) {
                identifier = "'" + (String)identifier;
            }
        }
        return identifier;
    }

    /*
     * WARNING - void declaration
     */
    public String getValidName(String identifier, boolean capitalizeFirstChar) {
        if (!identifier.matches("\\b[0-9]*\\b")) {
            String[] split = identifier.split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])");
            StringBuilder validName = new StringBuilder();
            for (String string : split) {
                void var8_8;
                if (string.isBlank()) continue;
                if (split.length > 1) {
                    String string2 = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1).toLowerCase(Locale.ENGLISH);
                }
                validName.append((String)var8_8);
            }
            identifier = validName.toString();
        }
        if (capitalizeFirstChar) {
            return identifier.substring(0, 1).toUpperCase(Locale.ENGLISH) + identifier.substring(1);
        }
        return identifier.substring(0, 1).toLowerCase(Locale.ENGLISH) + identifier.substring(1);
    }

    public String extractReferenceType(String referenceVariable) throws BallerinaAsyncApiException {
        if (referenceVariable.startsWith("#/")) {
            String[] refArray = referenceVariable.split("/");
            return this.escapeIdentifier(refArray[refArray.length - 1]);
        }
        throw new BallerinaAsyncApiException("Invalid reference value: " + referenceVariable + "\nBallerina only supports local reference values.");
    }

    public String getFunctionNameByEventName(String eventName) {
        return "on" + this.getValidName(eventName, true);
    }

    public String getServiceTypeNameByServiceName(String serviceName) {
        if (serviceName.trim().endsWith("Service")) {
            return this.getValidName(serviceName.trim(), true);
        }
        return this.getValidName(serviceName.trim(), true) + "Service";
    }
}

