/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic;

import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ExceptionDiagnostic
implements AsyncApiConverterDiagnostic {
    private final String code;
    private final String message;
    private final DiagnosticSeverity diagnosticSeverity;
    private final Location location;

    public ExceptionDiagnostic(String code, String message, Location location, Object ... args) {
        this.code = code;
        this.message = String.format(message, args);
        this.diagnosticSeverity = DiagnosticSeverity.ERROR;
        this.location = location;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public DiagnosticSeverity getDiagnosticSeverity() {
        return this.diagnosticSeverity;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Optional<Location> getLocation() {
        return Optional.ofNullable(this.location);
    }
}

