/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.model;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Document;
import io.apicurio.datamodels.models.util.JsonUtil;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class AsyncApiResult {
    private final List<AsyncApiConverterDiagnostic> diagnostics;
    private AsyncApi25Document asyncAPI;
    private String serviceName;

    public AsyncApiResult(AsyncApi25Document asyncAPI, List<AsyncApiConverterDiagnostic> diagnostics) {
        this.asyncAPI = asyncAPI;
        this.diagnostics = diagnostics != null ? Collections.unmodifiableList(diagnostics) : Collections.unmodifiableList(new ArrayList());
    }

    public List<AsyncApiConverterDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public Optional<AsyncApi25Document> getAsyncAPI() {
        return Optional.ofNullable(this.asyncAPI);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Optional<String> getYaml() {
        String finalYaml;
        ObjectNode json = Library.writeDocument(this.asyncAPI);
        YAMLFactory factory = new YAMLFactory();
        factory.disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER);
        factory.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
        factory.enable(YAMLGenerator.Feature.SPLIT_LINES);
        factory.enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS);
        try {
            finalYaml = new ObjectMapper((JsonFactory)factory).writer((PrettyPrinter)new DefaultPrettyPrinter()).writeValueAsString((Object)json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return Optional.ofNullable(finalYaml);
    }

    public Optional<String> getJson() {
        ObjectNode json = Library.writeDocument(this.asyncAPI);
        String finalJson = JsonUtil.stringify((JsonNode)json);
        return Optional.ofNullable(finalJson);
    }
}

