/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class AsyncApiHeaderMapper {
    private final Map<String, String> apiDocs;

    public AsyncApiHeaderMapper(Map<String, String> apiDocs) {
        this.apiDocs = apiDocs;
    }

    public void setHeaderParameter(RequiredParameterNode headerParam, BalAsyncApi25SchemaImpl bindingHeaderObject) {
        String extractedHeaderName = this.extractHeaderName((ParameterNode)headerParam);
        if (extractedHeaderName != null) {
            String headerName = ConverterCommonUtils.unescapeIdentifier(extractedHeaderName);
            Node node = headerParam.typeName();
            BalAsyncApi25SchemaImpl headerTypeSchema = ConverterCommonUtils.getAsyncApiSchema(this.getHeaderType((ParameterNode)headerParam));
            this.enableHeaderRequiredOption(node, headerTypeSchema);
            if (this.apiDocs != null && this.apiDocs.containsKey(headerName)) {
                headerTypeSchema.setDescription(this.apiDocs.get(headerName.trim()));
            }
            this.completeHeaderParameter(headerName, headerTypeSchema, (NodeList<AnnotationNode>)headerParam.annotations(), headerParam.typeName(), bindingHeaderObject);
        }
    }

    private String extractHeaderName(ParameterNode headerParam) {
        if (headerParam instanceof DefaultableParameterNode && ((DefaultableParameterNode)headerParam).paramName().isPresent()) {
            return ((Token)((DefaultableParameterNode)headerParam).paramName().get()).text().replaceAll("\\\\", "");
        }
        if (((RequiredParameterNode)headerParam).paramName().isPresent()) {
            return ((Token)((RequiredParameterNode)headerParam).paramName().get()).text().replaceAll("\\\\", "");
        }
        return null;
    }

    public void setHeaderParameter(DefaultableParameterNode headerParam, BalAsyncApi25SchemaImpl bindingHeaderObject) {
        String headerName = this.extractHeaderName((ParameterNode)headerParam);
        BalAsyncApi25SchemaImpl headerTypeSchema = ConverterCommonUtils.getAsyncApiSchema(this.getHeaderType((ParameterNode)headerParam));
        String defaultValue = headerParam.expression().toString().trim();
        if (defaultValue.length() > 1 && defaultValue.charAt(0) == '\"' && defaultValue.charAt(defaultValue.length() - 1) == '\"') {
            defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
        }
        ArrayList<SyntaxKind> allowedTypes = new ArrayList<SyntaxKind>();
        allowedTypes.addAll(Arrays.asList(SyntaxKind.STRING_LITERAL, SyntaxKind.NUMERIC_LITERAL, SyntaxKind.BOOLEAN_LITERAL));
        if (allowedTypes.contains(headerParam.expression().kind())) {
            headerTypeSchema.setDefault((JsonNode)new TextNode(defaultValue));
        } else if (headerParam.expression().kind() == SyntaxKind.LIST_CONSTRUCTOR) {
            headerTypeSchema = new BalAsyncApi25SchemaImpl();
            headerTypeSchema.setDefault((JsonNode)new TextNode(defaultValue));
        }
        if (headerParam.typeName().kind() == SyntaxKind.OPTIONAL_TYPE_DESC) {
            headerTypeSchema.addExtension("x-nullable", (JsonNode)BooleanNode.TRUE);
        }
        if (this.apiDocs != null && this.apiDocs.containsKey(headerName)) {
            headerTypeSchema.setDescription(this.apiDocs.get(headerName.trim()));
        }
        this.completeHeaderParameter(headerName, headerTypeSchema, (NodeList<AnnotationNode>)headerParam.annotations(), headerParam.typeName(), bindingHeaderObject);
    }

    private String getHeaderType(ParameterNode headerParam) {
        if (headerParam instanceof DefaultableParameterNode) {
            return ((DefaultableParameterNode)headerParam).typeName().toString().replaceAll("\\?", "").replaceAll("\\[", "").replaceAll("\\]", "").trim();
        }
        return ((RequiredParameterNode)headerParam).typeName().toString().replaceAll("\\?", "").replaceAll("\\[", "").replaceAll("\\]", "").trim();
    }

    private void completeHeaderParameter(String headerName, BalAsyncApi25SchemaImpl headerSchema, NodeList<AnnotationNode> annotations, Node node, BalAsyncApi25SchemaImpl bindingHeaderObject) {
        if (!annotations.isEmpty()) {
            AnnotationNode annotationNode = (AnnotationNode)annotations.get(0);
            headerName = this.getHeaderName(headerName, annotationNode);
        }
        if (node instanceof ArrayTypeDescriptorNode) {
            ArrayTypeDescriptorNode arrayNode = (ArrayTypeDescriptorNode)node;
            BalAsyncApi25SchemaImpl arraySchema = new BalAsyncApi25SchemaImpl();
            arraySchema.setType(Constants.AsyncAPIType.ARRAY.toString());
            SyntaxKind kind = arrayNode.memberTypeDesc().kind();
            BalAsyncApi25SchemaImpl itemSchema = ConverterCommonUtils.getAsyncApiSchema(kind);
            if (headerSchema.getDefault() != null) {
                arraySchema.setDefault(headerSchema.getDefault());
            }
            arraySchema.setItems(itemSchema);
            bindingHeaderObject.addProperty(headerName, arraySchema);
        } else {
            bindingHeaderObject.addProperty(headerName, headerSchema);
        }
    }

    private void enableHeaderRequiredOption(Node node, BalAsyncApi25SchemaImpl headerSchema) {
        if (node.kind() == SyntaxKind.OPTIONAL_TYPE_DESC) {
            headerSchema.addExtension("x-nullable", (JsonNode)BooleanNode.TRUE);
        }
    }

    private String getHeaderName(String headerName, AnnotationNode annotationNode) {
        if (annotationNode.annotValue().isPresent()) {
            MappingConstructorExpressionNode fieldNode = (MappingConstructorExpressionNode)annotationNode.annotValue().get();
            SeparatedNodeList fields = fieldNode.fields();
            for (MappingFieldNode field : fields) {
                SpecificFieldNode sField = (SpecificFieldNode)field;
                if (!sField.fieldName().toString().trim().equals("name") || !sField.valueExpr().isPresent()) continue;
                return ((ExpressionNode)sField.valueExpr().get()).toString().trim().replaceAll("\"", "");
            }
        }
        return headerName;
    }
}

