/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelItemImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25OperationImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25MessageImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiComponentMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiParameterMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiResponseMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.tools.diagnostics.Location;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class AsyncApiRemoteMapper {
    private final AsyncApi25ChannelsImpl channelObject = new AsyncApi25ChannelsImpl();
    private final AsyncApi25ComponentsImpl components = new AsyncApi25ComponentsImpl();
    private final AsyncApiComponentMapper componentMapper = new AsyncApiComponentMapper(this.components);
    private final SemanticModel semanticModel;

    AsyncApiRemoteMapper(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public AsyncApi25ComponentsImpl getComponents() {
        return this.components;
    }

    public AsyncApi25ChannelsImpl getChannels(FunctionDefinitionNode resource, List<ClassDefinitionNode> classDefinitionNodes, String dispatcherValue) {
        AsyncApi25ChannelItemImpl channelItem = (AsyncApi25ChannelItemImpl)this.channelObject.createChannelItem();
        Map<String, String> apiDocs = this.listAPIDocumentations(resource, channelItem);
        AsyncApiParameterMapper asyncAPIParameterMapper = new AsyncApiParameterMapper(resource, apiDocs, this.components, this.semanticModel);
        asyncAPIParameterMapper.getResourceInputs(channelItem);
        String serviceClassName = this.getServiceClassName(resource);
        if (!serviceClassName.isEmpty()) {
            for (ClassDefinitionNode node : classDefinitionNodes) {
                String testClassName1 = node.className().text();
                if (!testClassName1.equals(serviceClassName)) continue;
                return this.handleRemoteFunctions(resource, node, dispatcherValue, channelItem);
            }
        } else {
            throw new NoSuchElementException("ERROR: No service class present");
        }
        return this.channelObject;
    }

    private AsyncApi25ChannelsImpl handleRemoteFunctions(FunctionDefinitionNode resource, ClassDefinitionNode classDefinitionNode, String dispatcherValue, AsyncApi25ChannelItemImpl channelItem) {
        String path = ConverterCommonUtils.unescapeIdentifier(this.generateRelativePath(resource));
        NodeList classMethodNodes = classDefinitionNode.members();
        AsyncApi25OperationImpl publishOperationItem = new AsyncApi25OperationImpl();
        AsyncApi25OperationImpl subscribeOperationItem = new AsyncApi25OperationImpl();
        BalAsyncApi25MessageImpl subscribeMessage = new BalAsyncApi25MessageImpl();
        BalAsyncApi25MessageImpl publishMessage = new BalAsyncApi25MessageImpl();
        AsyncApiResponseMapper responseMapper = new AsyncApiResponseMapper((Location)resource.location(), this.componentMapper, this.semanticModel, this.components);
        for (Node node : classMethodNodes) {
            if (!node.kind().equals((Object)SyntaxKind.OBJECT_METHOD_DEFINITION)) continue;
            FunctionDefinitionNode remoteFunctionNode = (FunctionDefinitionNode)node;
            if (remoteFunctionNode.functionSignature().parameters().size() <= 2) {
                String functionName = remoteFunctionNode.functionName().toString().trim();
                if (functionName.matches("^on[A-Z][a-z0-9A-Z]*$")) {
                    String remoteRequestTypeName;
                    RequiredParameterNode requiredParameterNode;
                    if (!this.isRemoteFunctionNameValid(functionName).booleanValue() || (requiredParameterNode = this.checkParameterContainsCustomType(remoteRequestTypeName = ConverterCommonUtils.unescapeIdentifier(functionName.substring(2)), remoteFunctionNode)) == null) continue;
                    String paramName = ((Token)requiredParameterNode.paramName().get()).toString().trim();
                    Node parameterTypeNode = requiredParameterNode.typeName();
                    TypeSymbol remoteFunctionNameTypeSymbol = (TypeSymbol)this.semanticModel.symbol(parameterTypeNode).orElseThrow();
                    TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)remoteFunctionNameTypeSymbol;
                    TypeSymbol type = typeRef.typeDescriptor();
                    if (type.typeKind().equals((Object)TypeDescKind.RECORD) || type.typeKind().equals((Object)TypeDescKind.INTERSECTION) && this.componentMapper.excludeReadonlyIfPresent(type).typeKind().equals((Object)TypeDescKind.RECORD)) {
                        Optional optionalRemoteReturnNode;
                        FunctionSymbol remoteFunctionSymbol = (FunctionSymbol)this.semanticModel.symbol((Node)remoteFunctionNode).get();
                        Map<String, String> remoteDocs = this.getRemoteDocumentation(remoteFunctionSymbol);
                        String paramDescription = null;
                        if (remoteDocs.containsKey(paramName)) {
                            paramDescription = remoteDocs.get(paramName);
                            remoteDocs.remove(paramName);
                        }
                        BalAsyncApi25MessageImpl componentMessage = responseMapper.extractMessageSchemaReference(publishMessage, remoteRequestTypeName, remoteFunctionNameTypeSymbol, dispatcherValue, paramDescription);
                        if (remoteDocs.containsKey("remoteDescription")) {
                            componentMessage.setDescription(remoteDocs.get("remoteDescription"));
                            remoteDocs.remove("remoteDescription");
                        }
                        if ((optionalRemoteReturnNode = remoteFunctionNode.functionSignature().returnTypeDesc()).isPresent()) {
                            Node remoteReturnType = ((ReturnTypeDescriptorNode)optionalRemoteReturnNode.get()).type();
                            String returnDescription = null;
                            if (remoteDocs.containsKey("return")) {
                                returnDescription = remoteDocs.get("return");
                                remoteDocs.remove("return");
                            }
                            responseMapper.createResponse(subscribeMessage, componentMessage, remoteReturnType, returnDescription, "false", null);
                        }
                        this.components.addMessage(remoteRequestTypeName, componentMessage);
                        continue;
                    }
                    throw new NoSuchElementException(String.format("ERROR: %s type must be a record,%s given", remoteRequestTypeName, type.typeKind().getName()));
                }
                throw new NoSuchElementException("ERROR: Function name must start with 'on' and use camelCase convention ex-onHeartBeat,onRemoteFunctionTestName");
            }
            throw new NoSuchElementException("ERROR: Function name can only have two parameters, websocket:caller and type");
        }
        if (publishMessage.getOneOf() != null) {
            if (publishMessage.getOneOf().size() == 1) {
                BalAsyncApi25MessageImpl publishOneMessage = new BalAsyncApi25MessageImpl();
                publishOneMessage.set$ref(((BalAsyncApi25MessageImpl)publishMessage.getOneOf().get(0)).get$ref());
                publishOperationItem.setMessage(publishOneMessage);
            } else {
                publishOperationItem.setMessage(publishMessage);
            }
            channelItem.setPublish(publishOperationItem);
        }
        if (subscribeMessage.getOneOf() != null) {
            if (subscribeMessage.getOneOf().size() == 1) {
                BalAsyncApi25MessageImpl subscribeOneMessage = new BalAsyncApi25MessageImpl();
                subscribeOneMessage.set$ref(((BalAsyncApi25MessageImpl)subscribeMessage.getOneOf().get(0)).get$ref());
                if (subscribeOneMessage.get$ref() == null) {
                    subscribeOneMessage.setPayload(subscribeMessage.getOneOf().get(0).getPayload());
                }
                subscribeOperationItem.setMessage(subscribeOneMessage);
            } else {
                subscribeOperationItem.setMessage(subscribeMessage);
            }
            channelItem.setSubscribe(subscribeOperationItem);
        }
        this.channelObject.addItem(path, channelItem);
        return this.channelObject;
    }

    private Boolean isRemoteFunctionNameValid(String providedFunctionName) {
        String[] invalidRemoteFunctionNames = new String[]{"onMessage", "onTextMessage", "onBinaryMessage", "onClose", "onOpen", "onPing", "onPong"};
        return Arrays.stream(invalidRemoteFunctionNames).noneMatch(remoteFunctionName -> remoteFunctionName.equals(providedFunctionName));
    }

    private Map<String, String> getRemoteDocumentation(FunctionSymbol remoteFunctionSymbol) {
        Map<String, String> apiDocs = new HashMap<String, String>();
        Optional documentation = remoteFunctionSymbol.documentation();
        if (documentation.isPresent()) {
            Optional description;
            apiDocs = ((Documentation)documentation.get()).parameterMap();
            if (((Documentation)documentation.get()).returnDescription().isPresent()) {
                apiDocs.put("return", (String)((Documentation)documentation.get()).returnDescription().get());
            }
            if (((Documentation)documentation.get()).description().isPresent() && (description = ((Documentation)documentation.get()).description()).isPresent() && !((String)description.get()).trim().isEmpty()) {
                apiDocs.put("remoteDescription", ((String)description.get()).trim());
            }
        }
        return apiDocs;
    }

    private RequiredParameterNode checkParameterContainsCustomType(String customTypeName, FunctionDefinitionNode remoteFunctionNode) {
        SeparatedNodeList remoteParameters = remoteFunctionNode.functionSignature().parameters();
        for (ParameterNode remoteParameterNode : remoteParameters) {
            QualifiedNameReferenceNode qualifiedNameReferenceNode;
            String identifier;
            SimpleNameReferenceNode simpleNameReferenceNode;
            String simpleType;
            RequiredParameterNode requiredParameterNode;
            Node parameterTypeNode;
            if (remoteParameterNode.kind() != SyntaxKind.REQUIRED_PARAM || !((parameterTypeNode = (requiredParameterNode = (RequiredParameterNode)remoteParameterNode).typeName()).kind() == SyntaxKind.SIMPLE_NAME_REFERENCE ? (simpleType = (simpleNameReferenceNode = (SimpleNameReferenceNode)parameterTypeNode).name().toString().trim()).equals(customTypeName) : parameterTypeNode.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE && (identifier = (qualifiedNameReferenceNode = (QualifiedNameReferenceNode)parameterTypeNode).identifier().text()).equals(customTypeName))) continue;
            return requiredParameterNode;
        }
        return null;
    }

    private String getServiceClassName(FunctionDefinitionNode resource) {
        String serviceClassName = "";
        FunctionBodyNode functionBodyNode = resource.functionBody();
        ChildNodeList childNodeList = functionBodyNode.children();
        for (Node node : childNodeList) {
            ReturnStatementNode returnStatementNode;
            Optional expression;
            if (!(node instanceof ReturnStatementNode) || !((expression = (returnStatementNode = (ReturnStatementNode)node).expression()).get() instanceof ExplicitNewExpressionNode)) continue;
            ExplicitNewExpressionNode explicitNewExpressionNode = (ExplicitNewExpressionNode)expression.get();
            TypeDescriptorNode typeDescriptorNode = explicitNewExpressionNode.typeDescriptor();
            serviceClassName = typeDescriptorNode.toString().trim();
        }
        return serviceClassName;
    }

    private Map<String, String> listAPIDocumentations(FunctionDefinitionNode resource, AsyncApi25ChannelItemImpl channelItem) {
        Documentation documentation1;
        Optional description;
        Symbol symbol;
        Optional documentation;
        Optional resourceSymbol;
        Map<String, String> apiDocs = new HashMap<String, String>();
        if (resource.metadata().isPresent() && (resourceSymbol = this.semanticModel.symbol((Node)resource)).isPresent() && (documentation = ((Documentable)(symbol = (Symbol)resourceSymbol.get())).documentation()).isPresent() && (description = (documentation1 = (Documentation)documentation.get()).description()).isPresent()) {
            String resourceFunctionAPI = ((String)description.get()).trim();
            apiDocs = documentation1.parameterMap();
            channelItem.setDescription(resourceFunctionAPI);
        }
        return apiDocs;
    }

    private String generateRelativePath(FunctionDefinitionNode resource) {
        StringBuilder relativePath = new StringBuilder();
        relativePath.append("/");
        if (!resource.relativeResourcePath().isEmpty()) {
            for (Node node : resource.relativeResourcePath()) {
                if (node instanceof ResourcePathParameterNode) {
                    ResourcePathParameterNode pathNode = (ResourcePathParameterNode)node;
                    relativePath.append("{");
                    relativePath.append(pathNode.paramName().get());
                    relativePath.append("}");
                    continue;
                }
                if (resource.relativeResourcePath().size() == 1 && node.toString().trim().equals(".")) {
                    return relativePath.toString().trim();
                }
                relativePath.append(node.toString().trim());
            }
        }
        return relativePath.toString().trim();
    }
}

