/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ComponentsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiRemoteMapper;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.List;
import java.util.NoSuchElementException;

public class AsyncApiServiceMapper {
    private final AsyncApi25DocumentImpl asyncAPI;
    private final SemanticModel semanticModel;

    public AsyncApiServiceMapper(SemanticModel semanticModel, AsyncApi25DocumentImpl asyncAPI) {
        this.semanticModel = semanticModel;
        this.asyncAPI = asyncAPI;
    }

    private String extractDispatcherValue(ServiceDeclarationNode service) {
        String dispatcherValue = "";
        if (service.metadata().isPresent()) {
            MetadataNode serviceMetadataNode = (MetadataNode)service.metadata().get();
            NodeList annotationNodes = serviceMetadataNode.annotations();
            AnnotationNode annotationNode = (AnnotationNode)annotationNodes.get(0);
            Node node = annotationNode.annotReference();
            if (node instanceof QualifiedNameReferenceNode) {
                SeparatedNodeList fields = ((MappingConstructorExpressionNode)annotationNode.annotValue().get()).fields();
                for (MappingFieldNode field : fields) {
                    if (!(field instanceof SpecificFieldNode)) continue;
                    SpecificFieldNode specificFieldNode = (SpecificFieldNode)field;
                    String fieldName = specificFieldNode.fieldName().toString().trim();
                    dispatcherValue = this.setFieldValues(dispatcherValue, specificFieldNode, fieldName);
                    if (!fieldName.equals("dispatcherStreamId")) continue;
                    String dispatcherStreamIdValue = ((ExpressionNode)specificFieldNode.valueExpr().get()).toString().trim();
                    if ((dispatcherStreamIdValue = dispatcherStreamIdValue.replaceAll("\"", "")).equals("")) {
                        throw new NoSuchElementException("ERROR: dispatcherStreamId cannot be empty");
                    }
                    this.asyncAPI.addExtension("x-dispatcherStreamId", (JsonNode)new TextNode(dispatcherStreamIdValue));
                }
                if (!dispatcherValue.equals("")) {
                    return dispatcherValue.trim();
                }
                if (dispatcherValue.isEmpty()) {
                    throw new NoSuchElementException("ERROR: No dispatcherKey field is present in @websocket:ServiceConfig annotation");
                }
            }
        } else {
            throw new NoSuchElementException("ERROR: No Annotation present, use @websocket:ServiceConfig{dispatcherKey: \"event\"} above the service");
        }
        return null;
    }

    private String setFieldValues(String dispatcherValue, SpecificFieldNode specificFieldNode, String fieldName) {
        if (fieldName.equals("dispatcherKey")) {
            dispatcherValue = ((ExpressionNode)specificFieldNode.valueExpr().get()).toString().trim();
            if ((dispatcherValue = dispatcherValue.replaceAll("\"", "")).isEmpty()) {
                throw new NoSuchElementException("ERROR: dispatcherKey cannot be empty");
            }
            this.asyncAPI.addExtension("x-dispatcherKey", (JsonNode)new TextNode(dispatcherValue));
        }
        return dispatcherValue;
    }

    public AsyncApi25DocumentImpl convertServiceToAsyncApi(ServiceDeclarationNode service, List<ClassDefinitionNode> classDefinitionNodes, AsyncApi25DocumentImpl asyncApi) {
        NodeList functions = service.members();
        String dispatcherValue = this.extractDispatcherValue(service);
        for (Node function : functions) {
            SyntaxKind kind = function.kind();
            if (!kind.equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION)) continue;
            AsyncApiRemoteMapper resourceMapper = new AsyncApiRemoteMapper(this.semanticModel);
            AsyncApi25ChannelsImpl generatedChannels = resourceMapper.getChannels((FunctionDefinitionNode)function, classDefinitionNodes, dispatcherValue);
            asyncApi.setChannels(generatedChannels);
            AsyncApi25ComponentsImpl generatedComponents = resourceMapper.getComponents();
            asyncApi.setComponents(generatedComponents);
        }
        return asyncApi;
    }
}

