/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Objects;

public final class CodegenUtils {
    public static void writeFile(Path filePath, String content) throws IOException {
        try (FileWriter writer = new FileWriter(filePath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }

    public static String resolveContractFileName(Path outPath, String asyncApiName, Boolean isJson) {
        File[] listFiles;
        if (outPath != null && Files.exists(outPath, new LinkOption[0]) && (listFiles = new File(String.valueOf(outPath)).listFiles()) != null) {
            asyncApiName = CodegenUtils.checkAvailabilityOfGivenName(asyncApiName, listFiles, isJson);
        }
        return asyncApiName;
    }

    private static String checkAvailabilityOfGivenName(String asyncApiName, File[] listFiles, Boolean isJson) {
        for (File file : listFiles) {
            String userInput;
            if (System.console() == null || !file.getName().equals(asyncApiName) || Objects.equals((userInput = System.console().readLine("There is already a file named ' " + file.getName() + "' in the target location. Do you want to overwrite the file? [y/N] ", new Object[0])).toLowerCase(Locale.ENGLISH), "y")) continue;
            asyncApiName = CodegenUtils.setGeneratedFileName(listFiles, asyncApiName, isJson);
        }
        return asyncApiName;
    }

    private static String setGeneratedFileName(File[] listFiles, String fileName, boolean isJson) {
        int duplicateCount = 0;
        for (File listFile : listFiles) {
            String listFileName = listFile.getName();
            if (!listFileName.contains(".") || listFileName.split("\\.").length < 2 || !listFileName.split("\\.")[0].equals(fileName.split("\\.")[0])) continue;
            ++duplicateCount;
        }
        if (isJson) {
            return fileName.split("\\.")[0] + "." + duplicateCount + ".json";
        }
        return fileName.split("\\.")[0] + "." + duplicateCount + ".yaml";
    }
}

