/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactoryBuilder;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Document;
import io.apicurio.datamodels.validation.ValidationProblem;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.Constants;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.ExceptionDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.AsyncApiResult;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalBooleanSchema;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.runtime.api.utils.IdentifierUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class ConverterCommonUtils {
    public static BalAsyncApi25SchemaImpl getAsyncApiSchema(String type) {
        BalAsyncApi25SchemaImpl schema = new BalAsyncApi25SchemaImpl();
        switch (type) {
            case "string": 
            case "plain": {
                schema.setType(Constants.AsyncAPIType.STRING.toString());
                break;
            }
            case "boolean": {
                schema.setType(Constants.AsyncAPIType.BOOLEAN.toString());
                break;
            }
            case "array": 
            case "tuple": {
                schema.setType(Constants.AsyncAPIType.ARRAY.toString());
                break;
            }
            case "int": 
            case "integer": {
                schema.setType(Constants.AsyncAPIType.INTEGER.toString());
                schema.setFormat("int64");
                break;
            }
            case "byte[]": 
            case "octet-stream": {
                schema.setType(Constants.AsyncAPIType.STRING.toString());
                schema.setFormat("uuid");
                break;
            }
            case "number": 
            case "decimal": {
                schema.setType(Constants.AsyncAPIType.NUMBER.toString());
                schema.setFormat("double");
                break;
            }
            case "float": {
                schema.setType(Constants.AsyncAPIType.NUMBER.toString());
                schema.setFormat("float");
                break;
            }
            case "object": {
                schema.setType(Constants.AsyncAPIType.OBJECT.toString());
                break;
            }
            case "map<json>": 
            case "map": {
                schema.setType(Constants.AsyncAPIType.OBJECT.toString());
                schema.setAdditionalProperties(new BalBooleanSchema(true));
                break;
            }
            default: {
                schema = new BalAsyncApi25SchemaImpl();
            }
        }
        return schema;
    }

    public static BalAsyncApi25SchemaImpl getAsyncApiSchema(SyntaxKind type) {
        BalAsyncApi25SchemaImpl schema = new BalAsyncApi25SchemaImpl();
        switch (type) {
            case STRING_TYPE_DESC: {
                schema.setType("string");
                break;
            }
            case BOOLEAN_TYPE_DESC: {
                schema.setType("boolean");
                break;
            }
            case ARRAY_TYPE_DESC: {
                schema.setType("array");
                break;
            }
            case INT_TYPE_DESC: {
                schema.setType("integer");
                schema.setFormat("int64");
                break;
            }
            case BYTE_TYPE_DESC: {
                schema.setType("string");
                schema.setFormat("uuid");
                break;
            }
            case DECIMAL_TYPE_DESC: {
                schema.setType("number");
                schema.setFormat("double");
                break;
            }
            case FLOAT_TYPE_DESC: {
                schema.setType("number");
                schema.setFormat("float");
                break;
            }
            case MAP_TYPE_DESC: {
                schema.setType("object");
                break;
            }
            default: {
                schema = new BalAsyncApi25SchemaImpl();
            }
        }
        return schema;
    }

    public static AsyncApiResult parseAsyncAPIFile(String definitionURI) {
        AsyncApi25Document yamldoc;
        ExceptionDiagnostic diagnostic;
        DiagnosticMessages error;
        ArrayList<AsyncApiConverterDiagnostic> diagnostics = new ArrayList<AsyncApiConverterDiagnostic>();
        Path contractPath = Paths.get(definitionURI, new String[0]);
        if (!Files.exists(contractPath, new LinkOption[0])) {
            error = DiagnosticMessages.AAS_CONVERTOR_103;
            diagnostic = new ExceptionDiagnostic(error.getCode(), error.getDescription(), null, new Object[0]);
            diagnostics.add(diagnostic);
        }
        if (!(definitionURI.endsWith(".yaml") || definitionURI.endsWith(".json") || definitionURI.endsWith(".yml"))) {
            error = DiagnosticMessages.AAS_CONVERTOR_103;
            diagnostic = new ExceptionDiagnostic(error.getCode(), error.getDescription(), null, new Object[0]);
            diagnostics.add(diagnostic);
        }
        String asyncAPIFileContent = null;
        try {
            asyncAPIFileContent = Files.readString(contractPath);
        }
        catch (IOException e) {
            DiagnosticMessages error2 = DiagnosticMessages.AAS_CONVERTOR_102;
            ExceptionDiagnostic diagnostic2 = new ExceptionDiagnostic(error2.getCode(), error2.getDescription(), null, e.toString());
            diagnostics.add(diagnostic2);
        }
        YAMLFactory factory1 = ((YAMLFactoryBuilder)YAMLFactory.builder().enable(StreamReadFeature.STRICT_DUPLICATE_DETECTION)).build();
        new ObjectMapper();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory1);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            ObjectNode yamlNodes = (ObjectNode)mapper.readTree(asyncAPIFileContent);
            yamldoc = (AsyncApi25Document)Library.readDocument(yamlNodes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<ValidationProblem> yamlprob = Library.validate(yamldoc, null);
        if (!yamlprob.isEmpty()) {
            DiagnosticMessages error3 = DiagnosticMessages.AAS_CONVERTOR_105;
            ExceptionDiagnostic diagnostic3 = new ExceptionDiagnostic(error3.getCode(), error3.getDescription(), null, new Object[0]);
            diagnostics.add(diagnostic3);
            return new AsyncApiResult(null, diagnostics);
        }
        AsyncApi25Document api = yamldoc;
        return new AsyncApiResult(api, diagnostics);
    }

    public static String normalizeTitle(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        String[] urlPaths = serviceName.replaceFirst("/", "").split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])");
        StringBuilder stringBuilder = new StringBuilder();
        String title = serviceName;
        if (urlPaths.length > 1) {
            for (String path : urlPaths) {
                if (path.isBlank()) continue;
                stringBuilder.append(path.substring(0, 1).toUpperCase(Locale.ENGLISH));
                stringBuilder.append(path.substring(1));
                stringBuilder.append(" ");
            }
            title = stringBuilder.toString().trim();
        } else if (urlPaths.length == 1 && !urlPaths[0].isBlank()) {
            stringBuilder.append(urlPaths[0].substring(0, 1).toUpperCase(Locale.ENGLISH));
            stringBuilder.append(urlPaths[0].substring(1));
            title = stringBuilder.toString().trim();
        }
        return title;
    }

    public static boolean isWebsocketService(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Optional serviceSymbol = semanticModel.symbol((Node)serviceNode);
        if (serviceSymbol.isEmpty()) {
            return false;
        }
        ServiceDeclarationSymbol serviceNodeSymbol = (ServiceDeclarationSymbol)serviceSymbol.get();
        List listenerTypes = serviceNodeSymbol.listenerTypes();
        for (TypeSymbol listenerType : listenerTypes) {
            if (!ConverterCommonUtils.isWebsocketListener(listenerType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isWebsocketListener(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> ConverterCommonUtils.isWebsocketModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return ConverterCommonUtils.isWebsocketModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }

    private static boolean isWebsocketModule(ModuleSymbol moduleSymbol) {
        if (moduleSymbol.getName().isPresent()) {
            return "websocket".equals(moduleSymbol.getName().get()) && "ballerina".equals(moduleSymbol.id().orgName());
        }
        return false;
    }

    public static String getAsyncApiFileName(String servicePath, String serviceName, boolean isJson) {
        Object asyncAPIFileName;
        if (serviceName.isBlank() || serviceName.equals("/") || serviceName.startsWith("/-")) {
            String[] fileName = serviceName.split("/");
            asyncAPIFileName = fileName.length > 0 && !serviceName.isBlank() ? FilenameUtils.removeExtension((String)servicePath) + fileName[1] : FilenameUtils.removeExtension((String)servicePath);
        } else if (serviceName.startsWith("-")) {
            asyncAPIFileName = FilenameUtils.removeExtension((String)servicePath) + serviceName;
        } else {
            if (serviceName.startsWith("/")) {
                serviceName = serviceName.substring(1);
            }
            asyncAPIFileName = serviceName.replaceAll("/", "_");
        }
        return ConverterCommonUtils.getNormalizedFileName((String)asyncAPIFileName) + "_asyncapi" + (isJson ? ".json" : ".yaml");
    }

    public static String getNormalizedFileName(String asyncAPIFileName) {
        String[] splitNames = asyncAPIFileName.split("[^a-zA-Z0-9]");
        if (splitNames.length > 0) {
            return Arrays.stream(splitNames).filter(namePart -> !namePart.isBlank()).collect(Collectors.joining("_"));
        }
        return asyncAPIFileName;
    }

    public static boolean containErrors(List<Diagnostic> diagnostics) {
        return diagnostics != null && diagnostics.stream().anyMatch(diagnostic -> diagnostic.diagnosticInfo().severity() == DiagnosticSeverity.ERROR);
    }

    public static String unescapeIdentifier(String parameterName) {
        String unescapedParamName = IdentifierUtils.unescapeBallerina((String)parameterName);
        return unescapedParamName.trim().replaceAll("\\\\", "").replaceAll("'", "");
    }

    public static ObjectNode createObjectNode() {
        return new ObjectNode(JsonNodeFactory.instance);
    }

    public static ObjectMapper callObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        return objectMapper;
    }

    public static class NullLocation
    implements Location {
        public LineRange lineRange() {
            LinePosition from = LinePosition.from((int)0, (int)0);
            return LineRange.from((String)"", (LinePosition)from, (LinePosition)from);
        }

        public TextRange textRange() {
            return TextRange.from((int)0, (int)0);
        }
    }
}

