/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils;

import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.Info;
import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25Document;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.validation.ValidationProblem;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.AsyncApiConverterDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.DiagnosticMessages;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.diagnostic.ExceptionDiagnostic;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.AsyncApiInfo;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.AsyncApiResult;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiEndpointMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.service.AsyncApiServiceMapper;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Location;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class ServiceToAsyncApiConverterUtils {
    public static List<AsyncApiResult> generateAsyncAPISpecDefinition(SyntaxTree syntaxTree, SemanticModel semanticModel, String serviceName, Boolean needJson, Path inputPath) {
        ArrayList<ListenerDeclarationNode> endpoints = new ArrayList<ListenerDeclarationNode>();
        LinkedHashMap<String, ServiceDeclarationNode> servicesToGenerate = new LinkedHashMap<String, ServiceDeclarationNode>();
        ArrayList<String> availableService = new ArrayList<String>();
        ArrayList<AsyncApiConverterDiagnostic> diagnostics = new ArrayList<AsyncApiConverterDiagnostic>();
        ArrayList<AsyncApiResult> outputs = new ArrayList<AsyncApiResult>();
        ArrayList<ClassDefinitionNode> classDefinitionNodes = new ArrayList<ClassDefinitionNode>();
        if (ConverterCommonUtils.containErrors(semanticModel.diagnostics())) {
            DiagnosticMessages messages = DiagnosticMessages.AAS_CONVERTOR_100;
            ExceptionDiagnostic error = new ExceptionDiagnostic(messages.getCode(), messages.getDescription(), null, new Object[0]);
            diagnostics.add(error);
        } else {
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            ServiceToAsyncApiConverterUtils.extractListenersAndServiceNodes(serviceName, availableService, servicesToGenerate, classDefinitionNodes, modulePartNode, endpoints, semanticModel);
            if (serviceName != null && servicesToGenerate.isEmpty()) {
                DiagnosticMessages messages = DiagnosticMessages.AAS_CONVERTOR_101;
                ExceptionDiagnostic error = new ExceptionDiagnostic(messages.getCode(), messages.getDescription(), null, serviceName, ((Object)availableService).toString().trim());
                diagnostics.add(error);
            }
            for (Map.Entry serviceNode : servicesToGenerate.entrySet()) {
                String asyncApiName = ConverterCommonUtils.getAsyncApiFileName(syntaxTree.filePath(), (String)serviceNode.getKey(), needJson);
                AsyncApiResult asyncAPIDefinition = ServiceToAsyncApiConverterUtils.generateAsyncApiSpec((ServiceDeclarationNode)serviceNode.getValue(), endpoints, classDefinitionNodes, semanticModel, asyncApiName, inputPath);
                asyncAPIDefinition.setServiceName(asyncApiName);
                outputs.add(asyncAPIDefinition);
            }
        }
        if (!diagnostics.isEmpty()) {
            AsyncApiResult exceptions = new AsyncApiResult(null, diagnostics);
            outputs.add(exceptions);
        }
        return outputs;
    }

    private static void extractListenersAndServiceNodes(String serviceName, List<String> availableService, Map<String, ServiceDeclarationNode> servicesToGenerate, List<ClassDefinitionNode> classDefinitionNodes, ModulePartNode modulePartNode, List<ListenerDeclarationNode> endpoints, SemanticModel semanticModel) {
        for (Node node : modulePartNode.members()) {
            ServiceDeclarationNode serviceNode;
            SyntaxKind syntaxKind = node.kind();
            if (syntaxKind.equals((Object)SyntaxKind.LISTENER_DECLARATION)) {
                ListenerDeclarationNode listener = (ListenerDeclarationNode)node;
                endpoints.add(listener);
                continue;
            }
            if (syntaxKind.equals((Object)SyntaxKind.SERVICE_DECLARATION)) {
                Optional serviceSymbol;
                serviceNode = (ServiceDeclarationNode)node;
                if (!ConverterCommonUtils.isWebsocketService(serviceNode, semanticModel) || !(serviceSymbol = semanticModel.symbol((Node)serviceNode)).isPresent() || !(serviceSymbol.get() instanceof ServiceDeclarationSymbol)) continue;
                String service = AsyncApiEndpointMapper.ENDPOINT_MAPPER.getServiceBasePath(serviceNode);
                Object updateServiceName = service;
                if (servicesToGenerate.containsKey(service)) {
                    updateServiceName = service + "-" + ((Symbol)serviceSymbol.get()).hashCode();
                }
                if (serviceName != null) {
                    availableService.add(service);
                    if (!serviceName.equals(service)) continue;
                    servicesToGenerate.put((String)updateServiceName, serviceNode);
                    continue;
                }
                servicesToGenerate.put((String)updateServiceName, serviceNode);
                continue;
            }
            if (!syntaxKind.equals((Object)SyntaxKind.CLASS_DEFINITION)) continue;
            serviceNode = (ClassDefinitionNode)node;
            classDefinitionNodes.add((ClassDefinitionNode)serviceNode);
        }
    }

    public static AsyncApiResult generateAsyncApiSpec(ServiceDeclarationNode serviceDefinition, List<ListenerDeclarationNode> endpoints, List<ClassDefinitionNode> classDefinitionNodes, SemanticModel semanticModel, String asyncApiFileName, Path ballerinaFilePath) {
        AsyncApiResult asyncApiResult = ServiceToAsyncApiConverterUtils.fillAsyncApiInfoSection(serviceDefinition, semanticModel, asyncApiFileName, ballerinaFilePath);
        if (asyncApiResult.getAsyncAPI().isPresent() && asyncApiResult.getDiagnostics().isEmpty()) {
            AsyncApi25DocumentImpl asyncapi = (AsyncApi25DocumentImpl)asyncApiResult.getAsyncAPI().get();
            if (asyncapi.getChannels() == null) {
                AsyncApiServiceMapper asyncApiServiceMapper = new AsyncApiServiceMapper(semanticModel, asyncapi);
                asyncapi = AsyncApiEndpointMapper.ENDPOINT_MAPPER.getServers(asyncapi, endpoints, serviceDefinition);
                List<ValidationProblem> modelProblems = Library.validate(asyncapi = asyncApiServiceMapper.convertServiceToAsyncApi(serviceDefinition, classDefinitionNodes, asyncapi), null);
                if (!modelProblems.isEmpty()) {
                    ArrayList<AsyncApiConverterDiagnostic> diagnostics = new ArrayList<AsyncApiConverterDiagnostic>();
                    DiagnosticMessages error = DiagnosticMessages.AAS_CONVERTER_107;
                    ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(error.getCode(), error.getDescription(), null, new Object[0]);
                    diagnostics.add(diagnostic);
                    return new AsyncApiResult(null, diagnostics);
                }
                return new AsyncApiResult(asyncapi, null);
            }
            return new AsyncApiResult(asyncapi, asyncApiResult.getDiagnostics());
        }
        return asyncApiResult;
    }

    private static AsyncApiResult fillAsyncApiInfoSection(ServiceDeclarationNode serviceNode, SemanticModel semanticModel, String asyncApiFileName, Path ballerinaFilePath) {
        Optional metadata = serviceNode.metadata();
        ArrayList<AsyncApiConverterDiagnostic> diagnostics = new ArrayList<AsyncApiConverterDiagnostic>();
        AsyncApi25Document asyncAPI = (AsyncApi25Document)Library.createDocument(ModelType.ASYNCAPI25);
        asyncAPI.setAsyncapi("2.5.0");
        String currentServiceName = AsyncApiEndpointMapper.ENDPOINT_MAPPER.getServiceBasePath(serviceNode);
        String version = ServiceToAsyncApiConverterUtils.getContractVersion(serviceNode, semanticModel);
        if (metadata.isPresent() && !((MetadataNode)metadata.get()).annotations().isEmpty()) {
            MetadataNode metadataNode = (MetadataNode)metadata.get();
            NodeList annotations = metadataNode.annotations();
            for (AnnotationNode annotation : annotations) {
                if (annotation.annotReference().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
                QualifiedNameReferenceNode ref = (QualifiedNameReferenceNode)annotation.annotReference();
                String annotationName = ref.modulePrefix().text() + ":" + ref.identifier().text();
                if (annotationName.equals("asyncapi:ServiceInfo")) {
                    AsyncApiResult asyncApiResult = ServiceToAsyncApiConverterUtils.parseServiceInfoAnnotationAttachmentDetails(diagnostics, annotation, ballerinaFilePath);
                    return ServiceToAsyncApiConverterUtils.normalizeInfoSection(asyncApiFileName, currentServiceName, version, asyncApiResult);
                }
                Info info = asyncAPI.createInfo();
                info.setVersion(version);
                info.setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(currentServiceName));
                asyncAPI.setInfo(info);
            }
        } else if (currentServiceName.equals("/") || currentServiceName.isBlank()) {
            Info info = asyncAPI.createInfo();
            info.setVersion(version);
            info.setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(asyncApiFileName));
            asyncAPI.setInfo(info);
        } else {
            Info info = asyncAPI.createInfo();
            info.setVersion(version);
            info.setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(currentServiceName));
            asyncAPI.setInfo(info);
        }
        return new AsyncApiResult(asyncAPI, diagnostics);
    }

    private static AsyncApiResult normalizeInfoSection(String asyncApiFileName, String currentServiceName, String version, AsyncApiResult asyncApiResult) {
        if (asyncApiResult.getAsyncAPI().isPresent()) {
            AsyncApi25Document asyncAPI = asyncApiResult.getAsyncAPI().get();
            if (asyncAPI.getInfo() == null) {
                String title = ServiceToAsyncApiConverterUtils.normalizeTitle(currentServiceName);
                if (currentServiceName.equals("/")) {
                    title = ServiceToAsyncApiConverterUtils.normalizeTitle(asyncApiFileName);
                }
                Info info = asyncAPI.createInfo();
                info.setVersion(version);
                info.setTitle(title);
                asyncAPI.setInfo(info);
            } else {
                if (asyncAPI.getInfo().getTitle() == null) {
                    asyncAPI.getInfo().setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(currentServiceName));
                } else if (asyncAPI.getInfo().getTitle() != null && asyncAPI.getInfo().getTitle().equals("/")) {
                    asyncAPI.getInfo().setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(asyncApiFileName));
                } else if (asyncAPI.getInfo().getTitle().isBlank()) {
                    asyncAPI.getInfo().setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(currentServiceName));
                } else if (asyncAPI.getInfo().getTitle() == null && currentServiceName.equals("/")) {
                    asyncAPI.getInfo().setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(asyncApiFileName));
                }
                if (asyncAPI.getInfo().getVersion() == null || asyncAPI.getInfo().getVersion().isBlank()) {
                    asyncAPI.getInfo().setVersion(version);
                }
            }
            return new AsyncApiResult(asyncAPI, asyncApiResult.getDiagnostics());
        }
        return asyncApiResult;
    }

    private static String getContractVersion(ServiceDeclarationNode serviceDefinition, SemanticModel semanticModel) {
        Symbol serviceSymbol;
        Optional module;
        Optional symbol = semanticModel.symbol((Node)serviceDefinition);
        String version = "1.0.0";
        if (symbol.isPresent() && (module = (serviceSymbol = (Symbol)symbol.get()).getModule()).isPresent()) {
            version = ((ModuleSymbol)module.get()).id().version();
        }
        return version;
    }

    private static String normalizeTitle(String title) {
        if (title != null) {
            String[] splits = title.replaceFirst("/", "").split("([\\[\\]\\\\?!<>@#&~`*\\-=^+();:\\/\\_{}\\s|.$])");
            StringBuilder stringBuilder = new StringBuilder();
            if (splits.length > 1) {
                for (String piece : splits) {
                    if (piece.isBlank()) continue;
                    stringBuilder.append(piece.substring(0, 1).toUpperCase(Locale.ENGLISH)).append(piece.substring(1));
                    stringBuilder.append(" ");
                }
                title = stringBuilder.toString().trim();
            } else if (splits.length == 1 && !splits[0].isBlank()) {
                stringBuilder.append(splits[0].substring(0, 1).toUpperCase(Locale.ENGLISH)).append(splits[0].substring(1));
                title = stringBuilder.toString().trim();
            }
            return title;
        }
        return null;
    }

    private static AsyncApiResult parseServiceInfoAnnotationAttachmentDetails(List<AsyncApiConverterDiagnostic> diagnostics, AnnotationNode annotation, Path ballerinaFilePath) {
        SeparatedNodeList fields;
        NodeLocation location = annotation.location();
        AsyncApi25Document asyncAPI = (AsyncApi25Document)Library.createDocument(ModelType.ASYNCAPI25);
        asyncAPI.setAsyncapi("2.5.0");
        Optional content = annotation.annotValue();
        if (content.isPresent() && !(fields = ((MappingConstructorExpressionNode)content.get()).fields()).isEmpty()) {
            AsyncApiInfo asyncAPIInfo = ServiceToAsyncApiConverterUtils.updateAsyncAPIInfoModel((SeparatedNodeList<MappingFieldNode>)fields);
            if (asyncAPIInfo.getContractPath().isPresent() && ballerinaFilePath != null) {
                return ServiceToAsyncApiConverterUtils.updateExistingContractAsyncAPI(diagnostics, (Location)location, asyncAPIInfo, ballerinaFilePath);
            }
            if (asyncAPIInfo.getTitle().isPresent() && asyncAPIInfo.getVersion().isPresent()) {
                Info info = asyncAPI.createInfo();
                info.setVersion(asyncAPIInfo.getVersion().get());
                info.setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(asyncAPIInfo.getTitle().get()));
                asyncAPI.setInfo(info);
            } else if (asyncAPIInfo.getVersion().isPresent()) {
                Info info = asyncAPI.createInfo();
                info.setVersion(asyncAPIInfo.getVersion().get());
                asyncAPI.setInfo(info);
            } else if (asyncAPIInfo.getTitle().isPresent()) {
                Info info = asyncAPI.createInfo();
                info.setTitle(ServiceToAsyncApiConverterUtils.normalizeTitle(asyncAPIInfo.getTitle().get()));
                asyncAPI.setInfo(info);
            }
        }
        return new AsyncApiResult(asyncAPI, diagnostics);
    }

    private static AsyncApiResult updateExistingContractAsyncAPI(List<AsyncApiConverterDiagnostic> diagnostics, Location location, AsyncApiInfo asyncAPIInfo, Path ballerinaFilePath) {
        AsyncApiResult asyncAPIResult = ServiceToAsyncApiConverterUtils.resolveContractPath(diagnostics, location, asyncAPIInfo, ballerinaFilePath);
        Optional<AsyncApi25Document> contract = asyncAPIResult.getAsyncAPI();
        if (contract.isEmpty()) {
            return asyncAPIResult;
        }
        AsyncApi25Document asyncApi = contract.get();
        if (asyncAPIInfo.getVersion().isPresent() && asyncAPIInfo.getTitle().isPresent()) {
            asyncApi.getInfo().setVersion(asyncAPIInfo.getVersion().get());
            asyncApi.getInfo().setTitle(asyncAPIInfo.getTitle().get());
            diagnostics.addAll(asyncAPIResult.getDiagnostics());
            return new AsyncApiResult(asyncApi, asyncAPIResult.getDiagnostics());
        }
        if (asyncAPIInfo.getTitle().isPresent()) {
            asyncApi.getInfo().setTitle(asyncAPIInfo.getTitle().get());
            return new AsyncApiResult(asyncApi, asyncAPIResult.getDiagnostics());
        }
        if (asyncAPIInfo.getVersion().isPresent()) {
            asyncApi.getInfo().setVersion(asyncAPIInfo.getVersion().get());
            return new AsyncApiResult(asyncApi, asyncAPIResult.getDiagnostics());
        }
        return asyncAPIResult;
    }

    private static AsyncApiInfo updateAsyncAPIInfoModel(SeparatedNodeList<MappingFieldNode> fields) {
        AsyncApiInfo.AsyncAPIInfoBuilder infoBuilder = new AsyncApiInfo.AsyncAPIInfoBuilder();
        for (MappingFieldNode field : fields) {
            String fieldValue;
            ExpressionNode expressionNode;
            String fieldName = ((SpecificFieldNode)field).fieldName().toString().trim();
            Optional value = ((SpecificFieldNode)field).valueExpr();
            if (!value.isPresent() || (expressionNode = (ExpressionNode)value.get()).toString().trim().isBlank() || (fieldValue = expressionNode.toString().trim().replaceAll("\"", "")).isBlank()) continue;
            switch (fieldName) {
                case "contract": {
                    infoBuilder.contractPath(fieldValue);
                    break;
                }
                case "title": {
                    infoBuilder.title(fieldValue);
                    break;
                }
                case "'version": {
                    infoBuilder.version(fieldValue);
                    break;
                }
            }
        }
        return infoBuilder.build();
    }

    private static AsyncApiResult resolveContractPath(List<AsyncApiConverterDiagnostic> diagnostics, Location location, AsyncApiInfo asyncAPIInfo, Path ballerinaFilePath) {
        AsyncApi25Document asyncApi = null;
        Path asyncApiPath = Paths.get(asyncAPIInfo.getContractPath().get().replaceAll("\"", "").trim(), new String[0]);
        Path relativePath = null;
        if (asyncApiPath.toString().trim().isBlank()) {
            DiagnosticMessages error = DiagnosticMessages.AAS_CONVERTOR_103;
            ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(error.getCode(), error.getDescription(), location, new Object[0]);
            diagnostics.add(diagnostic);
        } else {
            Path path = Paths.get(asyncApiPath.toString(), new String[0]);
            if (path.isAbsolute()) {
                relativePath = path;
            } else {
                File file = new File(ballerinaFilePath.toString());
                File parentFolder = new File(file.getParent());
                File asyncApiContract = new File(parentFolder, asyncApiPath.toString());
                try {
                    relativePath = Paths.get(asyncApiContract.getCanonicalPath(), new String[0]);
                }
                catch (IOException e) {
                    DiagnosticMessages error = DiagnosticMessages.AAS_CONVERTOR_102;
                    ExceptionDiagnostic diagnostic = new ExceptionDiagnostic(error.getCode(), error.getDescription(), location, e.toString());
                    diagnostics.add(diagnostic);
                }
            }
        }
        if (relativePath != null && Files.exists(relativePath, new LinkOption[0])) {
            AsyncApiResult asyncApiResult = ConverterCommonUtils.parseAsyncAPIFile(relativePath.toString());
            if (asyncApiResult.getAsyncAPI().isPresent()) {
                asyncApi = asyncApiResult.getAsyncAPI().get();
            }
            diagnostics.addAll(asyncApiResult.getDiagnostics());
        }
        return new AsyncApiResult(asyncApi, diagnostics);
    }
}

