/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.asyncapi.AsyncApiChannelItem;
import io.apicurio.datamodels.models.asyncapi.AsyncApiParameter;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25BindingImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ChannelBindingsImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25DocumentImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25ParametersImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SecuritySchemeImpl;
import io.apicurio.datamodels.models.union.BooleanUnionValueImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorConstants;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.model.BalAsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.generators.asyncspec.utils.ConverterCommonUtils;
import io.ballerina.asyncapi.websocketscore.generators.document.DocCommentsGenerator;
import io.ballerina.asyncapi.websocketscore.generators.schema.BallerinaTypesGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ElseBlockNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceTypeDescNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BallerinaAuthConfigGenerator {
    private final Map<String, String> headerApiKeyNameList = new HashMap<String, String>();
    private final Map<String, String> queryApiKeyNameList = new HashMap<String, String>();
    private final List<Node> apiKeysConfigRecordFields = new ArrayList<Node>();
    private final Set<String> authTypes = new LinkedHashSet<String>();
    private final BallerinaTypesGenerator ballerinaSchemaGenerator;
    private boolean httpApiKey;
    private boolean isPathParam = false;
    private boolean isQueryParam = false;
    private boolean isHeaderParam = false;
    private boolean httpOROAuth;
    private String clientCredGrantTokenUrl;
    private String passwordGrantTokenUrl;
    private String refreshTokenUrl;
    private List<TypeDefinitionNode> authRelatedTypeDefinitionNodes = new ArrayList<TypeDefinitionNode>();

    public BallerinaAuthConfigGenerator(boolean isAPIKey, boolean isHttpOROAuth, BallerinaTypesGenerator ballerinaSchemaGenerator) {
        this.httpApiKey = isAPIKey;
        this.httpOROAuth = isHttpOROAuth;
        this.ballerinaSchemaGenerator = ballerinaSchemaGenerator;
    }

    public boolean isPathParam() {
        return this.isPathParam;
    }

    public boolean isQueryParam() {
        return this.isQueryParam;
    }

    public boolean isHeaderParam() {
        return this.isHeaderParam;
    }

    public boolean isHttpApiKey() {
        return this.httpApiKey;
    }

    public boolean isHttpOrOAuth() {
        return this.httpOROAuth;
    }

    public Map<String, String> getQueryApiKeyNameList() {
        return this.queryApiKeyNameList;
    }

    public Map<String, String> getHeaderApiKeyNameList() {
        return this.headerApiKeyNameList;
    }

    public Set<String> getAuthType() {
        return this.authTypes;
    }

    public List<TypeDefinitionNode> getAuthRelatedTypeDefinitionNodes() {
        return this.authRelatedTypeDefinitionNodes;
    }

    public void addAuthRelatedRecords(AsyncApi25DocumentImpl asyncAPI) throws BallerinaAsyncApiExceptionWs {
        ArrayList<TypeDefinitionNode> nodes = new ArrayList<TypeDefinitionNode>();
        if (asyncAPI.getComponents() != null) {
            if (asyncAPI.getComponents().getSecuritySchemes() != null) {
                Map<String, SecurityScheme> securitySchemeMap = asyncAPI.getComponents().getSecuritySchemes();
                this.setAuthTypes(securitySchemeMap);
            }
            if (this.isHttpApiKey()) {
                nodes.add(this.generateApiKeysConfig());
            }
            if (this.clientCredGrantTokenUrl != null) {
                nodes.add(this.getOAuth2ClientCredsGrantConfigRecord());
            }
            if (this.passwordGrantTokenUrl != null) {
                nodes.add(this.getOAuth2PasswordGrantConfigRecord());
            }
            if (this.refreshTokenUrl != null) {
                nodes.add(this.getOAuth2RefreshTokenGrantConfigRecord());
            }
        }
        this.authRelatedTypeDefinitionNodes = nodes;
    }

    public TypeDefinitionNode generateConnectionConfigRecord() {
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)"websocket:ClientConfiguration");
        NodeList recordFieldList = NodeFactory.createNodeList(this.getClientConfigRecordFields());
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        TypeDefinitionNode node = NodeFactory.createTypeDefinitionNode(null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        return node;
    }

    public TypeDefinitionNode generateApiKeysConfig() {
        MetadataNode configRecordMetadataNode = this.getMetadataNode("Provides API key configurations needed when communicating with a remote WEBSOCKET service endpoint.");
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig");
        NodeList recordFieldList = NodeFactory.createNodeList(this.apiKeysConfigRecordFields);
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private TypeDefinitionNode getOAuth2ClientCredsGrantConfigRecord() {
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)GeneratorConstants.AuthConfigTypes.CUSTOM_CLIENT_CREDENTIAL.getValue());
        NodeList recordFieldList = NodeFactory.createNodeList(this.getClientCredsGrantConfigFields());
        MetadataNode configRecordMetadataNode = this.getMetadataNode("OAuth2 Client Credentials Grant Configs");
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private List<Node> getClientCredsGrantConfigFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        recordFieldNodes.add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)AbstractNodeFactory.createIdentifierToken((String)"websocket:OAuth2ClientCredentialsGrantConfig;"), null));
        MetadataNode metadataNode = this.getMetadataNode("Token URL");
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        IdentifierToken fieldNameTokenUrl = AbstractNodeFactory.createIdentifierToken((String)"tokenUrl");
        RequiredExpressionNode defaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + this.clientCredGrantTokenUrl + "\"")));
        RecordFieldWithDefaultValueNode fieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)stringType, (Token)fieldNameTokenUrl, (Token)equalToken, (ExpressionNode)defaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)fieldNode);
        return recordFieldNodes;
    }

    private TypeDefinitionNode getOAuth2PasswordGrantConfigRecord() {
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)GeneratorConstants.AuthConfigTypes.CUSTOM_PASSWORD.getValue());
        NodeList recordFieldList = NodeFactory.createNodeList(this.getPasswordGrantConfigFields());
        MetadataNode configRecordMetadataNode = this.getMetadataNode("OAuth2 Password Grant Configs");
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private List<Node> getPasswordGrantConfigFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        recordFieldNodes.add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)AbstractNodeFactory.createIdentifierToken((String)"websocket:OAuth2PasswordGrantConfig;"), null));
        MetadataNode metadataNode = this.getMetadataNode("Token URL");
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        IdentifierToken fieldNameTokenUrl = AbstractNodeFactory.createIdentifierToken((String)"tokenUrl");
        RequiredExpressionNode defaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + this.passwordGrantTokenUrl + "\"")));
        RecordFieldWithDefaultValueNode fieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)stringType, (Token)fieldNameTokenUrl, (Token)equalToken, (ExpressionNode)defaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)fieldNode);
        return recordFieldNodes;
    }

    private TypeDefinitionNode getOAuth2RefreshTokenGrantConfigRecord() {
        IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)GeneratorConstants.AuthConfigTypes.CUSTOM_REFRESH_TOKEN.getValue());
        NodeList recordFieldList = NodeFactory.createNodeList(this.getRefreshTokenGrantConfigFields());
        MetadataNode configRecordMetadataNode = this.getMetadataNode("OAuth2 Refresh Token Grant Configs");
        RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recordFieldList, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)configRecordMetadataNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private List<Node> getRefreshTokenGrantConfigFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        recordFieldNodes.add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)AbstractNodeFactory.createIdentifierToken((String)"websocket:OAuth2RefreshTokenGrantConfig;"), null));
        MetadataNode metadataNode = this.getMetadataNode("Refresh URL");
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        IdentifierToken fieldNameTokenUrl = AbstractNodeFactory.createIdentifierToken((String)"refreshUrl");
        RequiredExpressionNode defaultValue = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + this.refreshTokenUrl + "\"")));
        RecordFieldWithDefaultValueNode fieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)metadataNode, null, (Node)stringType, (Token)fieldNameTokenUrl, (Token)equalToken, (ExpressionNode)defaultValue, (Token)semicolonToken);
        recordFieldNodes.add((Node)fieldNode);
        return recordFieldNodes;
    }

    public ObjectFieldNode getApiKeyMapClassVariable() {
        if (this.httpApiKey) {
            NodeList qualifierList = NodeFactory.createNodeList((Node[])new Token[]{NodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD)});
            TypeReferenceTypeDescNode readOnlyNode = NodeFactory.createTypeReferenceTypeDescNode((NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.READONLY_KEYWORD)));
            SimpleNameReferenceNode apiKeyMapNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
            if (this.httpOROAuth) {
                apiKeyMapNode = NodeFactory.createOptionalTypeDescriptorNode((Node)apiKeyMapNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN));
            }
            IntersectionTypeDescriptorNode intersectionTypeDescriptorNode = NodeFactory.createIntersectionTypeDescriptorNode((Node)readOnlyNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.BITWISE_AND_TOKEN), (Node)apiKeyMapNode);
            IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig");
            MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
            return NodeFactory.createObjectFieldNode((MetadataNode)metadataNode, null, (NodeList)qualifierList, (Node)intersectionTypeDescriptorNode, (Token)fieldName, null, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        }
        return null;
    }

    public void getConfigParamForClassInit(String serviceUrl, List<Node> parameters) {
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        Node serviceURLNode = this.getServiceURLNode(serviceUrl);
        IdentifierToken equalToken = AbstractNodeFactory.createIdentifierToken((String)"=");
        if (this.httpOROAuth) {
            BuiltinSimpleNameReferenceNode typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"websocket:ClientConfiguration"));
            IdentifierToken paramName = AbstractNodeFactory.createIdentifierToken((String)"clientConfig");
            RequiredParameterNode authConfig = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)typeName, (Token)paramName);
            parameters.add((Node)authConfig);
            parameters.add((Node)NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            parameters.add(serviceURLNode);
        } else {
            if (this.httpApiKey) {
                BuiltinSimpleNameReferenceNode apiKeyConfigTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
                IdentifierToken apiKeyConfigParamName = AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig");
                RequiredParameterNode apiKeyConfigParamNode = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)apiKeyConfigTypeName, (Token)apiKeyConfigParamName);
                parameters.add((Node)apiKeyConfigParamNode);
                parameters.add((Node)NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
            }
            BuiltinSimpleNameReferenceNode websocketClientConfigTypeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"websocket:ClientConfiguration"));
            IdentifierToken httpClientConfig = AbstractNodeFactory.createIdentifierToken((String)"clientConfig");
            BasicLiteralNode emptyExpression = NodeFactory.createBasicLiteralNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)" {}"));
            DefaultableParameterNode defaultConnectionConfig = NodeFactory.createDefaultableParameterNode((NodeList)annotationNodes, (Node)websocketClientConfigTypeName, (Token)httpClientConfig, (Token)equalToken, (Node)emptyExpression);
            if (serviceURLNode instanceof RequiredParameterNode) {
                parameters.add(serviceURLNode);
                parameters.add((Node)NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                parameters.add((Node)defaultConnectionConfig);
            } else {
                parameters.add((Node)defaultConnectionConfig);
                parameters.add((Node)NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
                parameters.add(serviceURLNode);
            }
        }
    }

    public void setFunctionParameters(AsyncApiChannelItem channelItem, List<Node> parameterList, Token comma, AsyncApi25SchemaImpl querySchema, AsyncApi25SchemaImpl headerSchema) throws BallerinaAsyncApiExceptionWs {
        AsyncApi25ParametersImpl parameters = (AsyncApi25ParametersImpl)channelItem.getParameters();
        AsyncApi25ChannelBindingsImpl bindings = (AsyncApi25ChannelBindingsImpl)channelItem.getBindings();
        if (bindings != null && bindings.getWs() == null) {
            throw new BallerinaAsyncApiExceptionWs("This tool support only for websocket protocol,use ws bindings");
        }
        if (parameters != null) {
            AsyncApi25SchemaImpl pathSchema = new AsyncApi25SchemaImpl();
            pathSchema.setType("object");
            pathSchema.setAdditionalProperties(new BooleanUnionValueImpl(false));
            ArrayList<String> pathRequiredFields = new ArrayList<String>();
            ArrayList<Node> schemaDocs = new ArrayList<Node>();
            String pathParamDescription = "Path parameters as a record";
            schemaDocs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(pathParamDescription, true));
            for (String parameterName : parameters.getItemNames()) {
                AsyncApiParameter parameter = parameters.getItem(parameterName);
                String type = ((AsyncApi25SchemaImpl)parameter.getSchema()).getType();
                if (type != null && type.equals("array")) {
                    throw new BallerinaAsyncApiExceptionWs("Ballerina doesn't support array type path parameters");
                }
                if (type != null && type.equals("object")) {
                    throw new BallerinaAsyncApiExceptionWs("Ballerina doesn't support record type path parameters");
                }
                if (parameter.getDescription() != null && !parameter.getDescription().isBlank()) {
                    MarkdownParameterDocumentationLineNode paramAPIDoc = DocCommentsGenerator.createAPIParamDoc(GeneratorUtils.getValidName(parameterName, false), parameter.getDescription());
                    schemaDocs.add((Node)paramAPIDoc);
                }
                pathSchema.addProperty(parameterName, parameter.getSchema());
                pathRequiredFields.add(parameterName);
            }
            pathSchema.setRequired(pathRequiredFields);
            this.authRelatedTypeDefinitionNodes.add(this.ballerinaSchemaGenerator.getTypeDefinitionNode(pathSchema, "PathParams", schemaDocs));
            BuiltinSimpleNameReferenceNode typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"PathParams"));
            RequiredParameterNode pathParamNode = NodeFactory.createRequiredParameterNode((NodeList)NodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)"pathParams"));
            this.isPathParam = true;
            parameterList.add((Node)pathParamNode);
            parameterList.add((Node)comma);
        }
        if (bindings != null) {
            BuiltinSimpleNameReferenceNode typeName;
            String type;
            BalAsyncApi25SchemaImpl schema;
            Map.Entry field;
            Iterator it;
            ArrayList<Node> schemaDocs;
            Iterator properties;
            ObjectMapper objMapper;
            AsyncApi25BindingImpl wsBindings = (AsyncApi25BindingImpl)bindings.getWs();
            if (wsBindings.getItem("headers") != null) {
                JsonNode headers = wsBindings.getItem("headers");
                objMapper = ConverterCommonUtils.callObjectMapper();
                if (headers.get("properties") != null) {
                    properties = headers.get("properties").fields();
                    headerSchema.setType("object");
                    headerSchema.setAdditionalProperties(new BooleanUnionValueImpl(false));
                    ArrayList<String> headerRequiredFields = new ArrayList<String>();
                    schemaDocs = new ArrayList<Node>();
                    String headerParamDescription = "Header parameters as a record";
                    schemaDocs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(headerParamDescription, true));
                    it = properties;
                    while (it.hasNext()) {
                        field = (Map.Entry)it.next();
                        String headerName = (String)field.getKey();
                        try {
                            schema = (BalAsyncApi25SchemaImpl)objMapper.treeToValue((TreeNode)field.getValue(), BalAsyncApi25SchemaImpl.class);
                            type = schema.getType();
                            if (type != null && type.equals("array")) {
                                throw new BallerinaAsyncApiExceptionWs("Ballerina doesn't support array type header parameters");
                            }
                            if (type != null && type.equals("object")) {
                                throw new BallerinaAsyncApiExceptionWs("Ballerina doesn't support record type header parameters");
                            }
                            headerSchema.addProperty(headerName, schema);
                            headerRequiredFields.add(headerName);
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    headerSchema.setRequired(headerRequiredFields);
                    this.authRelatedTypeDefinitionNodes.add(this.ballerinaSchemaGenerator.getTypeDefinitionNode(headerSchema, "HeaderParams", schemaDocs));
                    typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"HeaderParams"));
                    RequiredParameterNode headerParamNode = NodeFactory.createRequiredParameterNode((NodeList)NodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)"headerParams"));
                    parameterList.add((Node)headerParamNode);
                    parameterList.add((Node)comma);
                    this.isHeaderParam = true;
                }
            }
            if (wsBindings.getItem("query") != null) {
                ObjectNode query = (ObjectNode)wsBindings.getItem("query");
                objMapper = ConverterCommonUtils.callObjectMapper();
                if (query.get("properties") != null) {
                    properties = query.get("properties").fields();
                    querySchema.setType("object");
                    querySchema.setAdditionalProperties(new BooleanUnionValueImpl(false));
                    ArrayList<String> queryRequiredFields = new ArrayList<String>();
                    schemaDocs = new ArrayList();
                    String queryParamDescription = "Query parameters as a record";
                    schemaDocs.addAll(DocCommentsGenerator.createAPIDescriptionDoc(queryParamDescription, true));
                    it = properties;
                    while (it.hasNext()) {
                        field = (Map.Entry)it.next();
                        String queryName = (String)field.getKey();
                        try {
                            schema = (BalAsyncApi25SchemaImpl)objMapper.treeToValue((TreeNode)field.getValue(), BalAsyncApi25SchemaImpl.class);
                            type = schema.getType();
                            if (type != null && type.equals("array")) {
                                throw new BallerinaAsyncApiExceptionWs("Ballerina doesn't support array type query parameters");
                            }
                            if (type != null && type.equals("object")) {
                                throw new BallerinaAsyncApiExceptionWs("Ballerina doesn't support record type query parameters");
                            }
                            querySchema.addProperty(queryName, schema);
                            queryRequiredFields.add(queryName);
                        }
                        catch (JsonProcessingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    querySchema.setRequired(queryRequiredFields);
                    this.authRelatedTypeDefinitionNodes.add(this.ballerinaSchemaGenerator.getTypeDefinitionNode(querySchema, "QueryParams", schemaDocs));
                    typeName = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"QueryParams"));
                    RequiredParameterNode queryParamNode = NodeFactory.createRequiredParameterNode((NodeList)NodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)typeName, (Token)AbstractNodeFactory.createIdentifierToken((String)"queryParams"));
                    parameterList.add((Node)queryParamNode);
                    parameterList.add((Node)comma);
                    this.isQueryParam = true;
                }
            }
        }
    }

    private Node getServiceURLNode(String serviceUrl) {
        RequiredParameterNode serviceURLNode;
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode serviceURLType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"string"));
        IdentifierToken serviceURLVarName = AbstractNodeFactory.createIdentifierToken((String)"serviceUrl");
        if (serviceUrl.equals("/")) {
            serviceURLNode = NodeFactory.createRequiredParameterNode((NodeList)annotationNodes, (Node)serviceURLType, (Token)serviceURLVarName);
        } else {
            BasicLiteralNode expression = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)AbstractNodeFactory.createIdentifierToken((String)("\"" + serviceUrl + "\"")));
            serviceURLNode = NodeFactory.createDefaultableParameterNode((NodeList)annotationNodes, (Node)serviceURLType, (Token)serviceURLVarName, (Token)AbstractNodeFactory.createIdentifierToken((String)"="), (Node)expression);
        }
        return serviceURLNode;
    }

    public VariableDeclarationNode getWebsocketClientConfigVariableNode() {
        Token comma = NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        SimpleNameReferenceNode typeBindingPattern = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"websocket:ClientConfiguration"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        ArrayList<Object> argumentsList = new ArrayList<Object>();
        if (this.isHttpOrOAuth() && !this.isHttpApiKey()) {
            FieldAccessExpressionNode authValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"auth")));
            SpecificFieldNode authField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"auth"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)authValExp);
            argumentsList.add(authField);
            argumentsList.add(comma);
        }
        FieldAccessExpressionNode subProtocolsValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"subProtocols")));
        SpecificFieldNode subProtocolsField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"subProtocols"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)subProtocolsValExp);
        argumentsList.add(subProtocolsField);
        argumentsList.add(comma);
        FieldAccessExpressionNode customHeadersValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"customHeaders")));
        SpecificFieldNode customHeadersField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"customHeaders"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)customHeadersValExp);
        argumentsList.add(customHeadersField);
        argumentsList.add(comma);
        FieldAccessExpressionNode readTimeoutValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"readTimeout")));
        SpecificFieldNode readTimeoutField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"readTimeout"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)readTimeoutValExp);
        argumentsList.add(readTimeoutField);
        argumentsList.add(comma);
        FieldAccessExpressionNode writeTimeoutValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"writeTimeout")));
        SpecificFieldNode writeTimeoutField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"writeTimeout"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)writeTimeoutValExp);
        argumentsList.add(writeTimeoutField);
        argumentsList.add(comma);
        FieldAccessExpressionNode maxFrameSizeValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"maxFrameSize")));
        SpecificFieldNode maxFrameSizeField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"maxFrameSize"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)maxFrameSizeValExp);
        argumentsList.add(maxFrameSizeField);
        argumentsList.add(comma);
        FieldAccessExpressionNode webSocketCompressionEnabledValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"webSocketCompressionEnabled")));
        SpecificFieldNode webSocketCompressionEnabledField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"webSocketCompressionEnabled"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)webSocketCompressionEnabledValExp);
        argumentsList.add(webSocketCompressionEnabledField);
        argumentsList.add(comma);
        FieldAccessExpressionNode handleShakeTimeoutValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"handleShakeTimeout")));
        SpecificFieldNode handleShakeTimeoutField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"handleShakeTimeout"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)handleShakeTimeoutValExp);
        argumentsList.add(handleShakeTimeoutField);
        argumentsList.add(comma);
        FieldAccessExpressionNode validationValExp = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"validation")));
        SpecificFieldNode validationField = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)"validation"), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)validationValExp);
        argumentsList.add(validationField);
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList(argumentsList);
        MappingConstructorExpressionNode mappingConstructorExpressionNode = NodeFactory.createMappingConstructorExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)arguments, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)mappingConstructorExpressionNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public VariableDeclarationNode getClientInitializationNode(String url) {
        NodeList annotationNodes = AbstractNodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"websocket:Client"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"websocketEp"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        ArrayList<Object> argumentsList = new ArrayList<Object>();
        PositionalArgumentNode positionalArgumentNode01 = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)url)));
        argumentsList.add(positionalArgumentNode01);
        IdentifierToken comma1 = AbstractNodeFactory.createIdentifierToken((String)",");
        PositionalArgumentNode positionalArgumentNode02 = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")));
        argumentsList.add(comma1);
        argumentsList.add(positionalArgumentNode02);
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList(argumentsList);
        Token closeParenArg = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
        ParenthesizedArgList parenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)arguments, (Token)closeParenArg);
        ImplicitNewExpressionNode expressionNode = NodeFactory.createImplicitNewExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)parenthesizedArgList);
        CheckExpressionNode initializer = NodeFactory.createCheckExpressionNode(null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)expressionNode);
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public AssignmentStatementNode getApiKeyAssignmentNode() {
        if (this.httpApiKey) {
            FieldAccessExpressionNode varRefApiKey = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig")));
            RequiredExpressionNode fieldAccessExpressionNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig"));
            MethodCallExpressionNode methodCallExpressionNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)fieldAccessExpressionNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"cloneReadOnly")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
            return NodeFactory.createAssignmentStatementNode((Node)varRefApiKey, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)methodCallExpressionNode, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        }
        return null;
    }

    private List<Node> getClientConfigRecordFields() {
        ArrayList<Node> recordFieldNodes = new ArrayList<Node>();
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        Token equalToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN);
        Token questionMarkToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN);
        if (this.isHttpOrOAuth() && !this.isHttpApiKey()) {
            authMetadataNode = this.getMetadataNode("Configurations related to client authentication");
            authFieldName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier("auth"));
            SimpleNameReferenceNode authFieldTypeNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.getAuthFieldTypeName()));
            authFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)authMetadataNode, null, (Node)authFieldTypeNode, (Token)authFieldName, null, (Token)semicolonToken);
            recordFieldNodes.add((Node)authFieldNode);
        } else if (this.isHttpOrOAuth() && this.isHttpApiKey()) {
            authMetadataNode = this.getMetadataNode("Provides Auth configurations needed when communicating with a remote Websocket service endpoint.");
            authFieldName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.escapeIdentifier("auth"));
            UnionTypeDescriptorNode unionTypeDescriptor = NodeFactory.createUnionTypeDescriptorNode((TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.getAuthFieldTypeName())), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.PIPE_TOKEN), (TypeDescriptorNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig")));
            authFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)authMetadataNode, null, (Node)unionTypeDescriptor, (Token)authFieldName, null, (Token)semicolonToken);
            recordFieldNodes.add((Node)authFieldNode);
        }
        MetadataNode subProtocolsMetadata = this.getMetadataNode("Negotiable sub protocols of the client");
        IdentifierToken subProtocolsFieldName = AbstractNodeFactory.createIdentifierToken((String)"subProtocols");
        NodeList arrayDimensions = NodeFactory.createEmptyNodeList();
        ArrayDimensionNode arrayDimension = NodeFactory.createArrayDimensionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        arrayDimensions = arrayDimensions.add((Node)arrayDimension);
        SimpleNameReferenceNode subProtocolsMemberType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        ArrayTypeDescriptorNode subProtocolsFieldType = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)subProtocolsMemberType, (NodeList)arrayDimensions);
        RequiredExpressionNode subProtocolsExpression = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"[]"));
        RecordFieldWithDefaultValueNode subProtocolsFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)subProtocolsMetadata, null, (Node)subProtocolsFieldType, (Token)subProtocolsFieldName, (Token)equalToken, (ExpressionNode)subProtocolsExpression, (Token)semicolonToken);
        recordFieldNodes.add((Node)subProtocolsFieldNode);
        SimpleNameReferenceNode customHeadersMapParamType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        TypeParameterNode customHeadersTypeParamsNode = NodeFactory.createTypeParameterNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.LT_TOKEN), (TypeDescriptorNode)customHeadersMapParamType, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.GT_TOKEN));
        MapTypeDescriptorNode customHeadersFieldType = NodeFactory.createMapTypeDescriptorNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.MAP_KEYWORD), (TypeParameterNode)customHeadersTypeParamsNode);
        MetadataNode customHeadersMetadata = this.getMetadataNode("Custom headers, which should be sent to the server");
        IdentifierToken customHeadersFieldName = AbstractNodeFactory.createIdentifierToken((String)"customHeaders");
        RequiredExpressionNode customHeadersExpression = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"{}"));
        RecordFieldWithDefaultValueNode customHeadersFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)customHeadersMetadata, null, (Node)customHeadersFieldType, (Token)customHeadersFieldName, (Token)equalToken, (ExpressionNode)customHeadersExpression, (Token)semicolonToken);
        recordFieldNodes.add((Node)customHeadersFieldNode);
        MetadataNode readTimeOutMetadata = this.getMetadataNode("Read timeout (in seconds) of the client");
        SimpleNameReferenceNode readTimeOutFieldType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DECIMAL_KEYWORD));
        IdentifierToken readTimeoutFieldName = AbstractNodeFactory.createIdentifierToken((String)"readTimeout");
        RequiredExpressionNode readTimeOutDecimalLiteralNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"-1"));
        RecordFieldWithDefaultValueNode readTimeoutFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)readTimeOutMetadata, null, (Node)readTimeOutFieldType, (Token)readTimeoutFieldName, (Token)equalToken, (ExpressionNode)readTimeOutDecimalLiteralNode, (Token)semicolonToken);
        recordFieldNodes.add((Node)readTimeoutFieldNode);
        MetadataNode writeTimeOutMetadata = this.getMetadataNode("Write timeout (in seconds) of the client");
        SimpleNameReferenceNode writeTimeOutFieldType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DECIMAL_KEYWORD));
        IdentifierToken writeTimeoutFieldName = AbstractNodeFactory.createIdentifierToken((String)"writeTimeout");
        RequiredExpressionNode writeTimeOutDecimalLiteralNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"-1"));
        RecordFieldWithDefaultValueNode writeTimeoutFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)writeTimeOutMetadata, null, (Node)writeTimeOutFieldType, (Token)writeTimeoutFieldName, (Token)equalToken, (ExpressionNode)writeTimeOutDecimalLiteralNode, (Token)semicolonToken);
        recordFieldNodes.add((Node)writeTimeoutFieldNode);
        MetadataNode secureSocketMetadata = this.getMetadataNode("SSL/TLS-related options");
        IdentifierToken secureSocketFieldName = AbstractNodeFactory.createIdentifierToken((String)"secureSocket");
        OptionalTypeDescriptorNode secureSocketfieldType = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createIdentifierToken((String)"websocket:ClientSecureSocket"), (Token)questionMarkToken);
        RecordFieldWithDefaultValueNode secureSocketFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)secureSocketMetadata, null, (Node)secureSocketfieldType, (Token)secureSocketFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"()")), (Token)semicolonToken);
        recordFieldNodes.add((Node)secureSocketFieldNode);
        MetadataNode maxFrameSizeMetadata = this.getMetadataNode(" The maximum payload size of a WebSocket frame in bytes");
        SimpleNameReferenceNode maxFrameSizeFieldType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.INT_KEYWORD));
        IdentifierToken maxFrameSizeFieldName = AbstractNodeFactory.createIdentifierToken((String)"maxFrameSize");
        RequiredExpressionNode maxFrameSizeDecimalLiteralNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"65536"));
        RecordFieldWithDefaultValueNode maxFrameSizeFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)maxFrameSizeMetadata, null, (Node)maxFrameSizeFieldType, (Token)maxFrameSizeFieldName, (Token)equalToken, (ExpressionNode)maxFrameSizeDecimalLiteralNode, (Token)semicolonToken);
        recordFieldNodes.add((Node)maxFrameSizeFieldNode);
        MetadataNode webSocketCompressionEnabledMetadata = this.getMetadataNode("Enable support for compression in the WebSocket");
        SimpleNameReferenceNode webSocketCompressionEnabledFieldType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.BOOLEAN_KEYWORD));
        IdentifierToken webSocketCompressionEnabledFieldName = AbstractNodeFactory.createIdentifierToken((String)"webSocketCompressionEnabled");
        RecordFieldWithDefaultValueNode webSocketCompressionEnabledFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)webSocketCompressionEnabledMetadata, null, (Node)webSocketCompressionEnabledFieldType, (Token)webSocketCompressionEnabledFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TRUE_KEYWORD)), (Token)semicolonToken);
        recordFieldNodes.add((Node)webSocketCompressionEnabledFieldNode);
        MetadataNode handShakeTimeoutMetadata = this.getMetadataNode("Time (in seconds) that a connection waits to get the response of the WebSocket handshake");
        SimpleNameReferenceNode handShakeTimeoutFieldType = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DECIMAL_KEYWORD));
        IdentifierToken handShakeTimeoutFieldName = AbstractNodeFactory.createIdentifierToken((String)"handShakeTimeout");
        RequiredExpressionNode handShakeTimeoutDecimalLiteralNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"300"));
        RecordFieldWithDefaultValueNode handShakeTimeoutFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)handShakeTimeoutMetadata, null, (Node)handShakeTimeoutFieldType, (Token)handShakeTimeoutFieldName, (Token)equalToken, (ExpressionNode)handShakeTimeoutDecimalLiteralNode, (Token)semicolonToken);
        recordFieldNodes.add((Node)handShakeTimeoutFieldNode);
        MetadataNode cookiesMetadata = this.getMetadataNode("An Array of http:Cookie");
        IdentifierToken cookiesFieldName = AbstractNodeFactory.createIdentifierToken((String)"cookies");
        NodeList cookiesArrayDimensions = NodeFactory.createEmptyNodeList();
        ArrayDimensionNode cookiesArrayDimension = NodeFactory.createArrayDimensionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACKET_TOKEN), null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACKET_TOKEN));
        cookiesArrayDimensions = cookiesArrayDimensions.add((Node)cookiesArrayDimension);
        SimpleNameReferenceNode cookiesArrayMemberType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"http:Cookie"));
        ArrayTypeDescriptorNode cookiesFieldType = NodeFactory.createArrayTypeDescriptorNode((TypeDescriptorNode)cookiesArrayMemberType, (NodeList)cookiesArrayDimensions);
        RecordFieldNode cookiesFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)cookiesMetadata, null, (Node)cookiesFieldType, (Token)cookiesFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)cookiesFieldNode);
        MetadataNode pingPongHandlerMetadata = this.getMetadataNode("A service to handle the ping/pong frames");
        IdentifierToken pingPongHandlerFieldName = AbstractNodeFactory.createIdentifierToken((String)"pingPongHandler");
        SimpleNameReferenceNode pingPongHandlerFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"websocket:PingPongService"));
        RecordFieldNode pingPongHandlerFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)pingPongHandlerMetadata, null, (Node)pingPongHandlerFieldType, (Token)pingPongHandlerFieldName, (Token)questionMarkToken, (Token)semicolonToken);
        recordFieldNodes.add((Node)pingPongHandlerFieldNode);
        MetadataNode retryConfigMetadata = this.getMetadataNode("Configurations associated with retrying");
        IdentifierToken retryConfigFieldName = AbstractNodeFactory.createIdentifierToken((String)"retryConfig");
        OptionalTypeDescriptorNode returConfigFieldType = NodeFactory.createOptionalTypeDescriptorNode((Node)AbstractNodeFactory.createIdentifierToken((String)"websocket:WebSocketRetryConfig"), (Token)questionMarkToken);
        RecordFieldWithDefaultValueNode retryConfigFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)retryConfigMetadata, null, (Node)returConfigFieldType, (Token)retryConfigFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"()")), (Token)semicolonToken);
        recordFieldNodes.add((Node)retryConfigFieldNode);
        MetadataNode validationMetadata = this.getMetadataNode("Enable/disable constraint validation");
        IdentifierToken validationFieldName = AbstractNodeFactory.createIdentifierToken((String)"validation");
        SimpleNameReferenceNode validationFieldType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"boolean"));
        RecordFieldWithDefaultValueNode validateFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)validationMetadata, null, (Node)validationFieldType, (Token)validationFieldName, (Token)equalToken, (ExpressionNode)NodeFactory.createRequiredExpressionNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.TRUE_KEYWORD)), (Token)semicolonToken);
        recordFieldNodes.add((Node)validateFieldNode);
        return recordFieldNodes;
    }

    public IfElseStatementNode handleInitForMixOfApiKeyAndHTTPOrOAuth() {
        ArrayList<AssignmentStatementNode> apiKeyConfigAssignmentNodes = new ArrayList<AssignmentStatementNode>();
        FieldAccessExpressionNode apiKeyConfigRef = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig")));
        SimpleNameReferenceNode apiKeyConfigExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"(<ApiKeysConfig>config.auth).cloneReadOnly()"));
        AssignmentStatementNode apiKeyConfigAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)apiKeyConfigRef, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)apiKeyConfigExpr, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        apiKeyConfigAssignmentNodes.add(apiKeyConfigAssignmentStatementNode);
        NodeList statementList = NodeFactory.createNodeList(apiKeyConfigAssignmentNodes);
        BlockStatementNode ifBody = NodeFactory.createBlockStatementNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)statementList, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        ArrayList<AssignmentStatementNode> clientConfigAssignmentNodes = new ArrayList<AssignmentStatementNode>();
        FieldAccessExpressionNode clientConfigAuthRef = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientConfig")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"auth")));
        SimpleNameReferenceNode clientConfigExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("<" + this.getAuthFieldTypeName() + ">clientConfig" + SyntaxKind.DOT_TOKEN.stringValue() + "auth")));
        AssignmentStatementNode httpClientAuthConfigAssignment = NodeFactory.createAssignmentStatementNode((Node)clientConfigAuthRef, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)clientConfigExpr, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        clientConfigAssignmentNodes.add(httpClientAuthConfigAssignment);
        FieldAccessExpressionNode apiKeyConfigNilRef = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeyConfig")));
        SimpleNameReferenceNode apiKeyConfigNilExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"()"));
        AssignmentStatementNode apiKeyConfigNilAssignment = NodeFactory.createAssignmentStatementNode((Node)apiKeyConfigNilRef, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)apiKeyConfigNilExpr, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        clientConfigAssignmentNodes.add(apiKeyConfigNilAssignment);
        NodeList elseBodyNodeList = NodeFactory.createNodeList(clientConfigAssignmentNodes);
        BlockStatementNode elseBodyStatement = NodeFactory.createBlockStatementNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)elseBodyNodeList, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        ElseBlockNode elseBody = NodeFactory.createElseBlockNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.ELSE_KEYWORD), (StatementNode)elseBodyStatement);
        BinaryExpressionNode condition = NodeFactory.createBinaryExpressionNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)("clientConfig" + SyntaxKind.DOT_TOKEN.stringValue() + "auth")), (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.IS_KEYWORD), (Node)AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig"));
        return NodeFactory.createIfElseStatementNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)condition, (BlockStatementNode)ifBody, (Node)elseBody);
    }

    private MetadataNode getMetadataNode(String comment) {
        ArrayList<MarkdownDocumentationLineNode> docs = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGenerator.createAPIDescriptionDoc(comment, false));
        MarkdownDocumentationNode authDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)NodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)authDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
    }

    public void setAuthTypes(Map<String, SecurityScheme> securitySchemeMap) throws BallerinaAsyncApiExceptionWs {
        for (Map.Entry<String, SecurityScheme> securitySchemeEntry : securitySchemeMap.entrySet()) {
            String schemaType;
            AsyncApi25SecuritySchemeImpl securitySchemaValue = (AsyncApi25SecuritySchemeImpl)securitySchemeEntry.getValue();
            if (securitySchemaValue == null || securitySchemaValue.getType() == null) continue;
            block7 : switch (schemaType = securitySchemaValue.getType().toLowerCase(Locale.getDefault())) {
                case "http": {
                    this.httpOROAuth = true;
                    String scheme = securitySchemaValue.getScheme();
                    if (scheme.equals("basic")) {
                        this.authTypes.add("basic");
                        break;
                    }
                    if (!scheme.equals("bearer")) break;
                    this.authTypes.add("bearer");
                    break;
                }
                case "oauth2": {
                    this.httpOROAuth = true;
                    if (securitySchemaValue.getFlows().getClientCredentials() != null) {
                        if (securitySchemaValue.getFlows().getClientCredentials().getTokenUrl() != null) {
                            this.clientCredGrantTokenUrl = securitySchemaValue.getFlows().getClientCredentials().getTokenUrl();
                        }
                        this.authTypes.add("client_cred");
                    }
                    if (securitySchemaValue.getFlows().getPassword() != null) {
                        if (securitySchemaValue.getFlows().getPassword().getTokenUrl() != null) {
                            this.passwordGrantTokenUrl = securitySchemaValue.getFlows().getPassword().getTokenUrl();
                        }
                        this.authTypes.add("password");
                    }
                    if (securitySchemaValue.getFlows().getAuthorizationCode() != null) {
                        if (securitySchemaValue.getFlows().getAuthorizationCode().getTokenUrl() != null) {
                            this.refreshTokenUrl = securitySchemaValue.getFlows().getAuthorizationCode().getTokenUrl();
                        }
                        this.authTypes.addAll(Arrays.asList("bearer", "refresh_token"));
                    }
                    if (securitySchemaValue.getFlows().getImplicit() == null) break;
                    this.authTypes.add("bearer");
                    break;
                }
                case "httpApiKey": {
                    this.httpApiKey = true;
                    String apiKeyType = securitySchemaValue.getIn().toLowerCase(Locale.getDefault());
                    this.authTypes.add("httpApiKey");
                    this.setApiKeysConfigRecordFields(securitySchemaValue);
                    switch (apiKeyType) {
                        case "query": {
                            this.queryApiKeyNameList.put(securitySchemeEntry.getKey(), securitySchemaValue.getName());
                            break block7;
                        }
                        case "header": {
                            this.headerApiKeyNameList.put(securitySchemeEntry.getKey(), securitySchemaValue.getName());
                            break block7;
                        }
                    }
                    break;
                }
                case "userPassword": {
                    throw new BallerinaAsyncApiExceptionWs("userPassword type security schema doesn't support yet");
                }
                case "apiKey": {
                    throw new BallerinaAsyncApiExceptionWs("apiKey type security schema doesn't support yet");
                }
            }
        }
        if (!this.httpApiKey && !this.httpOROAuth) {
            throw new BallerinaAsyncApiExceptionWs("Ballerina unsupported type of security schema");
        }
    }

    private void setApiKeysConfigRecordFields(AsyncApi25SecuritySchemeImpl securityScheme) {
        MetadataNode metadataNode = null;
        if (securityScheme.getDescription() != null) {
            metadataNode = this.getMetadataNode(securityScheme.getDescription());
        }
        SimpleNameReferenceNode stringTypeDesc = NodeFactory.createSimpleNameReferenceNode((Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        IdentifierToken apiKeyName = AbstractNodeFactory.createIdentifierToken((String)GeneratorUtils.getValidName(securityScheme.getName(), false));
        this.apiKeysConfigRecordFields.add((Node)NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)stringTypeDesc, (Token)apiKeyName, null, (Token)NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
    }

    private String getAuthFieldTypeName() {
        HashSet<String> httpFieldTypeNames = new HashSet<String>();
        Iterator<String> iterator = this.authTypes.iterator();
        while (iterator.hasNext()) {
            String authType;
            switch (authType = iterator.next()) {
                case "bearer": {
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.BEARER.getValue());
                    break;
                }
                case "basic": {
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.BASIC.getValue());
                    break;
                }
                case "client_cred": {
                    if (this.clientCredGrantTokenUrl != null && !this.clientCredGrantTokenUrl.isBlank()) {
                        httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CUSTOM_CLIENT_CREDENTIAL.getValue());
                        break;
                    }
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CLIENT_CREDENTIAL.getValue());
                    break;
                }
                case "password": {
                    if (this.passwordGrantTokenUrl != null && !this.passwordGrantTokenUrl.isBlank()) {
                        httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CUSTOM_PASSWORD.getValue());
                        break;
                    }
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.PASSWORD.getValue());
                    break;
                }
                case "refresh_token": {
                    if (this.refreshTokenUrl != null && !this.refreshTokenUrl.isBlank()) {
                        httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.CUSTOM_REFRESH_TOKEN.getValue());
                        break;
                    }
                    httpFieldTypeNames.add(GeneratorConstants.AuthConfigTypes.REFRESH_TOKEN.getValue());
                    break;
                }
            }
        }
        return this.buildConfigRecordFieldTypes(httpFieldTypeNames).toString();
    }

    private StringBuilder buildConfigRecordFieldTypes(Set<String> fieldtypes) {
        StringBuilder httpAuthFieldTypes = new StringBuilder();
        if (!fieldtypes.isEmpty()) {
            for (String fieldType : fieldtypes) {
                if (httpAuthFieldTypes.length() != 0) {
                    httpAuthFieldTypes.append("|").append(fieldType);
                    continue;
                }
                httpAuthFieldTypes.append(fieldType);
            }
        }
        return httpAuthFieldTypes;
    }
}

