/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.client;

import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.document.DocCommentsGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ChildNodeEntry;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MarkdownParameterDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SingletonTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceNode;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UtilGenerator.class);
    private static final String GET_ENCODED_URI = "getEncodedUri";
    private static final String GET_PATH_FOR_QUERY_PARAM = "getPathForQueryParam";
    private static final String GET_COMBINE_HEADERS = "getCombineHeaders";
    private static final Token openParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN);
    private static final Token closeParenToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN);
    private static final Token openBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
    private static final Token closeBraceToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
    private static final Token semicolonToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
    private final ArrayList<String> streamReturns;
    private boolean headersFound = false;
    private boolean queryParamsFound = false;
    private boolean pathParametersFound = false;

    public UtilGenerator(ArrayList<String> streamReturns) {
        this.streamReturns = streamReturns;
    }

    public void setQueryParamsFound(boolean flag) {
        this.queryParamsFound = flag;
    }

    public void setHeadersFound(boolean flag) {
        this.headersFound = flag;
    }

    public void setPathParametersFound(boolean flag) {
        this.pathParametersFound = flag;
    }

    public SyntaxTree generateUtilSyntaxTree() throws IOException {
        LinkedHashSet<String> functionNameList = new LinkedHashSet<String>();
        ArrayList<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
        functionNameList.add("PipesMap");
        ImportDeclarationNode importForXLibbPipe = GeneratorUtils.getImportDeclarationNode("xlibb", "pipe");
        imports.add(importForXLibbPipe);
        if (this.queryParamsFound) {
            functionNameList.addAll(Arrays.asList(GET_ENCODED_URI, GET_PATH_FOR_QUERY_PARAM));
        }
        if (this.headersFound) {
            functionNameList.add(GET_COMBINE_HEADERS);
        }
        if (this.pathParametersFound) {
            functionNameList.add(GET_ENCODED_URI);
        }
        ArrayList<ModuleMemberDeclarationNode> memberDeclarationNodes = new ArrayList<ModuleMemberDeclarationNode>();
        this.getUtilTypeDeclarationNodes(memberDeclarationNodes);
        if (!this.streamReturns.isEmpty()) {
            for (String returnType : this.streamReturns) {
                memberDeclarationNodes.add((ModuleMemberDeclarationNode)this.createStreamGenerator(returnType));
            }
            functionNameList.add("Generator");
            functionNameList.add("StreamGeneratorsMap");
        }
        Path path = this.getResourceFilePath();
        Project project = ProjectLoader.loadProject((Path)path);
        Package currentPackage = project.currentPackage();
        DocumentId docId = (DocumentId)currentPackage.getDefaultModule().documentIds().iterator().next();
        SyntaxTree syntaxTree = currentPackage.getDefaultModule().document(docId).syntaxTree();
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        NodeList members = modulePartNode.members();
        block1: for (ModuleMemberDeclarationNode node : members) {
            if (!node.kind().equals((Object)SyntaxKind.FUNCTION_DEFINITION) && !node.kind().equals((Object)SyntaxKind.CLASS_DEFINITION) && !node.kind().equals((Object)SyntaxKind.TYPE_DEFINITION)) continue;
            for (ChildNodeEntry childNodeEntry : node.childEntries()) {
                if (!childNodeEntry.name().equals("functionName") && !childNodeEntry.name().equals("className") && !childNodeEntry.name().equals("typeName")) continue;
                if (!functionNameList.contains(((Node)childNodeEntry.node().get()).toString().trim())) continue block1;
                memberDeclarationNodes.add(node);
                continue block1;
            }
        }
        if (functionNameList.contains(GET_ENCODED_URI)) {
            ImportDeclarationNode importForUrl = GeneratorUtils.getImportDeclarationNode("ballerina", "url");
            imports.add(importForUrl);
        }
        NodeList importsList = AbstractNodeFactory.createNodeList(imports);
        ModulePartNode utilModulePartNode = NodeFactory.createModulePartNode((NodeList)importsList, (NodeList)AbstractNodeFactory.createNodeList(memberDeclarationNodes), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree utilSyntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return utilSyntaxTree.modifyWith((Node)utilModulePartNode);
    }

    private ClassDefinitionNode createStreamGenerator(String returnType) {
        ArrayList<Object> memberNodeList = new ArrayList<Object>();
        memberNodeList.addAll(this.createClassInstanceVariables());
        memberNodeList.add(this.createInitFunction());
        memberNodeList.add(this.createNextFunction(returnType));
        memberNodeList.add(this.createCloseFunction());
        MetadataNode metadataNode = this.getClassMetadataNode(returnType);
        returnType = GeneratorUtils.getStreamGeneratorName(returnType);
        IdentifierToken className = AbstractNodeFactory.createIdentifierToken((String)(returnType + "StreamGenerator"));
        NodeList classTypeQualifiers = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLIENT_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        return NodeFactory.createClassDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (NodeList)classTypeQualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLASS_KEYWORD), (Token)className, (Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(memberNodeList), (Token)closeBraceToken, null);
    }

    private List<Node> createClassInstanceVariables() {
        ArrayList<Node> fieldNodeList = new ArrayList<Node>();
        Token privateKeywordToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PRIVATE_KEYWORD);
        Token finalKeywordToken = AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD);
        ArrayList<Token> prefixTokens = new ArrayList<Token>();
        prefixTokens.add(privateKeywordToken);
        prefixTokens.add(finalKeywordToken);
        NodeList qualifierList = AbstractNodeFactory.createNodeList(prefixTokens);
        TypeReferenceNode typeReferenceNode = NodeFactory.createTypeReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"Generator")), (Token)semicolonToken);
        ObjectFieldNode pipesField = NodeFactory.createObjectFieldNode(null, null, (NodeList)qualifierList, (Node)NodeParser.parseTypeDescriptor((String)"PipesMap"), (Token)AbstractNodeFactory.createIdentifierToken((String)"pipes"), null, null, (Token)semicolonToken);
        SimpleNameReferenceNode stringType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"string"));
        IdentifierToken pipeId = AbstractNodeFactory.createIdentifierToken((String)"pipeId");
        ObjectFieldNode pipeIdField = NodeFactory.createObjectFieldNode(null, null, (NodeList)qualifierList, (Node)stringType, (Token)pipeId, null, null, (Token)semicolonToken);
        SimpleNameReferenceNode decimalType = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"decimal"));
        IdentifierToken timeout = AbstractNodeFactory.createIdentifierToken((String)"timeout");
        ObjectFieldNode timeoutField = NodeFactory.createObjectFieldNode(null, null, (NodeList)qualifierList, (Node)decimalType, (Token)timeout, null, null, (Token)semicolonToken);
        fieldNodeList.add((Node)typeReferenceNode);
        fieldNodeList.add((Node)pipesField);
        fieldNodeList.add((Node)pipeIdField);
        fieldNodeList.add((Node)timeoutField);
        return fieldNodeList;
    }

    private MetadataNode getClassMetadataNode(String returnType) {
        ArrayList classLevelAnnotationNodes = new ArrayList();
        ArrayList<MarkdownDocumentationLineNode> documentationLines = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGenerator.createAPIDescriptionDoc("Stream generator class for " + returnType + " return type", false));
        MarkdownDocumentationNode apiDoc = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(documentationLines));
        return NodeFactory.createMetadataNode((Node)apiDoc, (NodeList)AbstractNodeFactory.createNodeList(classLevelAnnotationNodes));
    }

    private FunctionDefinitionNode createNextFunction(String returnType) {
        FunctionSignatureNode functionSignatureNode = this.getNextFunctionSignatureNode(returnType);
        FunctionBodyNode functionBodyNode = this.getNextFunctionBodyNode(returnType);
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"next");
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, null, (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private FunctionDefinitionNode createCloseFunction() {
        FunctionSignatureNode functionSignatureNode = this.getCloseFunctionSignatureNode();
        FunctionBodyNode functionBodyNode = this.getCloseFunctionBodyNode();
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"close");
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, null, (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private FunctionSignatureNode getNextFunctionSignatureNode(String returnType) {
        SimpleNameReferenceNode returnTypeNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)("record {|" + returnType + " value;|}|error")));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnTypeNode);
        return NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken, (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    private FunctionSignatureNode getCloseFunctionSignatureNode() {
        SimpleNameReferenceNode returnTypeNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"error?"));
        ReturnTypeDescriptorNode returnTypeDescriptorNode = NodeFactory.createReturnTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURNS_KEYWORD), (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Node)returnTypeNode);
        return NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)closeParenToken, (ReturnTypeDescriptorNode)returnTypeDescriptorNode);
    }

    private FunctionBodyNode getCloseFunctionBodyNode() {
        ArrayList<StatementNode> assignmentNodes = new ArrayList<StatementNode>();
        assignmentNodes.add(NodeParser.parseStatement((String)"check self.pipes.removePipe(self.pipeId);"));
        NodeList statementList = AbstractNodeFactory.createNodeList(assignmentNodes);
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)statementList, (Token)closeBraceToken, null);
    }

    private FunctionBodyNode getNextFunctionBodyNode(String returnType) {
        ArrayList<Object> statements = new ArrayList<Object>();
        statements.add(NodeParser.parseStatement((String)"anydata|error? message = self.pipes.getPipe(self.pipeId).consume(self.timeout);"));
        statements.add(NodeFactory.createIfElseStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.IF_KEYWORD), (ExpressionNode)NodeParser.parseExpression((String)"message is error?"), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{NodeParser.parseStatement((String)(SyntaxKind.CONTINUE_KEYWORD.stringValue() + ";"))}), (Token)closeBraceToken), null));
        statements.add(NodeParser.parseStatement((String)String.format("%s response = check message.cloneWithType();", returnType)));
        statements.add(NodeParser.parseStatement((String)(SyntaxKind.RETURN_KEYWORD.stringValue() + " " + String.format("{%s}", "value: response") + ";")));
        WhileStatementNode whileStatementNode = NodeFactory.createWhileStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.WHILE_KEYWORD), (ExpressionNode)NodeParser.parseExpression((String)"true"), (BlockStatementNode)NodeFactory.createBlockStatementNode((Token)openBraceToken, (NodeList)AbstractNodeFactory.createNodeList(statements), (Token)closeBraceToken), null);
        NodeList statementList = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{whileStatementNode});
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)statementList, (Token)closeBraceToken, null);
    }

    private FunctionDefinitionNode createInitFunction() {
        FunctionSignatureNode functionSignatureNode = this.getStreamInitFunctionSignatureNode();
        FunctionBodyNode functionBodyNode = this.getStreamInitFunctionBodyNode();
        NodeList qualifierList = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ISOLATED_KEYWORD)});
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"init");
        return NodeFactory.createFunctionDefinitionNode((SyntaxKind)SyntaxKind.OBJECT_METHOD_DEFINITION, (MetadataNode)this.getInitDocComment(), (NodeList)qualifierList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FUNCTION_KEYWORD), (IdentifierToken)functionName, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (FunctionSignatureNode)functionSignatureNode, (FunctionBodyNode)functionBodyNode);
    }

    private MetadataNode getInitDocComment() {
        ArrayList<Object> docs = new ArrayList<Object>();
        docs.addAll(DocCommentsGenerator.createAPIDescriptionDoc("StreamGenerator", true));
        MarkdownParameterDocumentationLineNode pipeNodeDocs = DocCommentsGenerator.createAPIParamDoc("pipe", "Pipe to hold stream messages");
        docs.add(pipeNodeDocs);
        MarkdownParameterDocumentationLineNode timeoutNodeDocs = DocCommentsGenerator.createAPIParamDoc("timeout", "Waiting time");
        docs.add(timeoutNodeDocs);
        MarkdownDocumentationNode clientInitDoc = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(docs));
        return NodeFactory.createMetadataNode((Node)clientInitDoc, (NodeList)AbstractNodeFactory.createEmptyNodeList());
    }

    private FunctionSignatureNode getStreamInitFunctionSignatureNode() {
        RequiredParameterNode pipeNode = NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"PipesMap")), (Token)AbstractNodeFactory.createIdentifierToken((String)"pipes"));
        RequiredParameterNode pipeIdNode = NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"string")), (Token)AbstractNodeFactory.createIdentifierToken((String)"pipeId"));
        RequiredParameterNode decimalNode = NodeFactory.createRequiredParameterNode((NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[0]), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"decimal")), (Token)AbstractNodeFactory.createIdentifierToken((String)"timeout"));
        ArrayList<Object> parameterList = new ArrayList<Object>();
        parameterList.add(pipeNode);
        parameterList.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        parameterList.add(pipeIdNode);
        parameterList.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        parameterList.add(decimalNode);
        SeparatedNodeList parameters = AbstractNodeFactory.createSeparatedNodeList(parameterList);
        return NodeFactory.createFunctionSignatureNode((Token)openParenToken, (SeparatedNodeList)parameters, (Token)closeParenToken, null);
    }

    private FunctionBodyNode getStreamInitFunctionBodyNode() {
        ArrayList<AssignmentStatementNode> assignmentNodes = new ArrayList<AssignmentStatementNode>();
        AssignmentStatementNode selfPipes = NodeFactory.createAssignmentStatementNode((Node)AbstractNodeFactory.createIdentifierToken((String)"self.pipes"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"pipes")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        AssignmentStatementNode selfPipeId = NodeFactory.createAssignmentStatementNode((Node)AbstractNodeFactory.createIdentifierToken((String)"self.pipeId"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"pipeId")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        AssignmentStatementNode selfTimeout = NodeFactory.createAssignmentStatementNode((Node)AbstractNodeFactory.createIdentifierToken((String)"self.timeout"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"timeout")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        assignmentNodes.add(selfPipes);
        assignmentNodes.add(selfPipeId);
        assignmentNodes.add(selfTimeout);
        NodeList statementList = AbstractNodeFactory.createNodeList(assignmentNodes);
        return NodeFactory.createFunctionBodyBlockNode((Token)openBraceToken, null, (NodeList)statementList, (Token)closeBraceToken, null);
    }

    private void getUtilTypeDeclarationNodes(List<ModuleMemberDeclarationNode> memberDeclarationNodes) {
        if (this.queryParamsFound || this.headersFound) {
            memberDeclarationNodes.add((ModuleMemberDeclarationNode)this.getSimpleBasicTypeDefinitionNode());
        }
    }

    private TypeDefinitionNode getSimpleBasicTypeDefinitionNode() {
        SingletonTypeDescriptorNode typeDescriptorNode = NodeFactory.createSingletonTypeDescriptorNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"string|boolean|int|float|decimal")));
        return NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"SimpleBasicType"), (Node)typeDescriptorNode, (Token)semicolonToken);
    }

    private Path getResourceFilePath() throws IOException {
        Path path = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("templates/utils_asyncapi.bal");
        if (inputStream != null) {
            String clientSyntaxTreeString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Path tmpDir = Files.createTempDirectory(".util-tmp" + System.nanoTime(), new FileAttribute[0]);
            path = tmpDir.resolve("utils.bal");
            try (PrintWriter writer = new PrintWriter(path.toString(), StandardCharsets.UTF_8);){
                writer.print(clientSyntaxTreeString);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.deleteDirectory((File)tmpDir.toFile());
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to delete the temporary directory : " + String.valueOf(tmpDir), (Throwable)ex);
                }
            }));
        }
        return path;
    }
}

