/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators;

import io.apicurio.datamodels.models.asyncapi.v25.AsyncApi25SchemaImpl;
import io.ballerina.asyncapi.websocketscore.GeneratorUtils;
import io.ballerina.asyncapi.websocketscore.exception.BallerinaAsyncApiExceptionWs;
import io.ballerina.asyncapi.websocketscore.generators.schema.TypeGeneratorUtils;
import io.ballerina.asyncapi.websocketscore.generators.schema.ballerinatypegenerators.TypeGenerator;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;

public class PrimitiveTypeGenerator
extends TypeGenerator {
    public PrimitiveTypeGenerator(AsyncApi25SchemaImpl schema, String typeName) {
        super(schema, typeName);
    }

    @Override
    public TypeDescriptorNode generateTypeDescriptorNode() throws BallerinaAsyncApiExceptionWs {
        String typeDescriptorName = GeneratorUtils.convertAsyncAPITypeToBallerina(this.schema.getType().trim());
        if (this.schema.getType().equals("number")) {
            if (this.schema.getFormat() != null) {
                typeDescriptorName = GeneratorUtils.convertAsyncAPITypeToBallerina(this.schema.getFormat().trim());
            }
        } else if (this.schema.getType().equals("string") && this.schema.getFormat() != null && this.schema.getFormat().equals("binary")) {
            typeDescriptorName = "record {byte[] fileContent; string fileName;}";
        }
        SimpleNameReferenceNode typeDescriptorNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)typeDescriptorName));
        return TypeGeneratorUtils.getNullableType(this.schema, (TypeDescriptorNode)typeDescriptorNode);
    }
}

