/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import io.ballerina.projects.Settings;
import io.ballerina.projects.internal.model.Proxy;
import io.ballerina.projects.util.ProjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.central.client.CentralAPIClient;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.wso2.ballerinalang.util.RepoUtils;

public class CentralPackageDescriptorLoader {
    public static final LanguageServerContext.Key<CentralPackageDescriptorLoader> CENTRAL_PACKAGE_HOLDER_KEY = new LanguageServerContext.Key();
    private final List<LSPackageLoader.ModuleInfo> centralPackages = new ArrayList<LSPackageLoader.ModuleInfo>();
    private static final String GET_PACKAGES_QUERY = "{\"query\": \"{packages(orgName:\\\"%s\\\" limit: %s) {packages {name version organization}}}\"}";
    private boolean isLoaded = false;
    private final LSClientLogger clientLogger;

    public static CentralPackageDescriptorLoader getInstance(LanguageServerContext context) {
        CentralPackageDescriptorLoader centralPackageDescriptorLoader = (CentralPackageDescriptorLoader)context.get(CENTRAL_PACKAGE_HOLDER_KEY);
        if (centralPackageDescriptorLoader == null) {
            centralPackageDescriptorLoader = new CentralPackageDescriptorLoader(context);
        }
        return centralPackageDescriptorLoader;
    }

    private CentralPackageDescriptorLoader(LanguageServerContext context) {
        context.put(CENTRAL_PACKAGE_HOLDER_KEY, (Object)this);
        this.clientLogger = LSClientLogger.getInstance(context);
    }

    public CompletableFuture<List<LSPackageLoader.ModuleInfo>> getCentralPackages() {
        return CompletableFuture.supplyAsync(() -> {
            if (!this.isLoaded) {
                this.clientLogger.logTrace("Loading packages from Ballerina Central");
                this.centralPackages.addAll(this.getCentralGraphQLPackages());
                this.clientLogger.logTrace("Successfully loaded packages from Ballerina Central");
            }
            this.isLoaded = true;
            return this.centralPackages;
        });
    }

    private List<LSPackageLoader.ModuleInfo> getCentralGraphQLPackages() {
        try {
            Settings settings = RepoUtils.readSettings();
            CentralAPIClient centralAPIClient = new CentralAPIClient(RepoUtils.getRemoteRepoGraphQLURL(), ProjectUtils.initializeProxy((Proxy)settings.getProxy()), ProjectUtils.getAccessTokenOfCLI((Settings)settings));
            String query = String.format(GET_PACKAGES_QUERY, "ballerinax", 800);
            JsonElement allPackagesResponse = centralAPIClient.getCentralPackagesUsingGraphQL(query, "any", RepoUtils.getBallerinaVersion());
            CentralPackageGraphQLResponse response = (CentralPackageGraphQLResponse)new Gson().fromJson(allPackagesResponse.getAsString(), CentralPackageGraphQLResponse.class);
            return response.data.packages.packages;
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public record CentralPackageGraphQLResponse(Packages data) {
    }

    public record Packages(PackageList packages) {
    }

    public record PackageList(List<LSPackageLoader.ModuleInfo> packages) {
    }
}

