/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.langserver.Experimental;
import org.ballerinalang.langserver.commons.capability.ExperimentalClientCapabilities;
import org.ballerinalang.langserver.commons.capability.InitializationOptions;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.registration.BallerinaClientCapability;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;

public class LSClientCapabilitiesImpl
implements LSClientCapabilities {
    private final ExperimentalClientCapabilities experimentalCapabilities;
    private final InitializationOptions initializationOptions;
    private final WorkspaceClientCapabilities workspaceCapabilities;
    private final TextDocumentClientCapabilities textDocCapabilities;
    private final List<BallerinaClientCapability> ballerinaClientCapabilities;

    LSClientCapabilitiesImpl(TextDocumentClientCapabilities textDocCapabilities, WorkspaceClientCapabilities workspaceCapabilities, Map<String, Object> experimentalClientCapabilities, Map<String, Object> initializationOptionsMap) {
        this.textDocCapabilities = textDocCapabilities != null ? textDocCapabilities : new TextDocumentClientCapabilities();
        this.workspaceCapabilities = workspaceCapabilities != null ? workspaceCapabilities : new WorkspaceClientCapabilities();
        this.experimentalCapabilities = experimentalClientCapabilities != null ? this.parseCapabilities(experimentalClientCapabilities) : new ExperimentalClientCapabilitiesImpl();
        this.initializationOptions = initializationOptionsMap != null ? this.parseInitializationOptions(initializationOptionsMap) : new InitializationOptionsImpl();
        this.ballerinaClientCapabilities = new ArrayList<BallerinaClientCapability>();
    }

    public ExperimentalClientCapabilities getExperimentalCapabilities() {
        return this.experimentalCapabilities;
    }

    public InitializationOptions getInitializationOptions() {
        return this.initializationOptions;
    }

    public WorkspaceClientCapabilities getWorkspaceCapabilities() {
        return this.workspaceCapabilities;
    }

    public TextDocumentClientCapabilities getTextDocCapabilities() {
        return this.textDocCapabilities;
    }

    public void setBallerinaClientCapabilities(List<BallerinaClientCapability> capabilities) {
        if (!this.ballerinaClientCapabilities.isEmpty()) {
            throw new IllegalStateException("Cannot populate an already populated capability list");
        }
        this.ballerinaClientCapabilities.addAll(capabilities);
    }

    public List<BallerinaClientCapability> getBallerinaClientCapabilities() {
        return this.ballerinaClientCapabilities;
    }

    private ExperimentalClientCapabilities parseCapabilities(Map<String, Object> experimentalCapabilities) {
        Object introspection = experimentalCapabilities.get(Experimental.INTROSPECTION.getValue());
        boolean introspectionEnabled = introspection instanceof Boolean && (Boolean)introspection != false;
        Object showTextDocument = experimentalCapabilities.get(Experimental.SHOW_TEXT_DOCUMENT.getValue());
        boolean showTextDocumentEnabled = showTextDocument instanceof Boolean && (Boolean)showTextDocument != false;
        ExperimentalClientCapabilitiesImpl capabilities = new ExperimentalClientCapabilitiesImpl();
        capabilities.setIntrospectionEnabled(introspectionEnabled);
        capabilities.setShowTextDocumentEnabled(showTextDocumentEnabled);
        return capabilities;
    }

    private InitializationOptions parseInitializationOptions(Map<String, Object> initOptions) {
        InitializationOptionsImpl initializationOptions = new InitializationOptionsImpl();
        Object supportBalaScheme = initOptions.get("supportBalaScheme");
        boolean balaSchemeSupported = supportBalaScheme == null || Boolean.parseBoolean(String.valueOf(supportBalaScheme));
        initializationOptions.setSupportBalaScheme(balaSchemeSupported);
        Object semanticTokensSupport = initOptions.get("enableSemanticHighlighting");
        boolean enableSemanticTokens = semanticTokensSupport == null || Boolean.parseBoolean(String.valueOf(semanticTokensSupport));
        initializationOptions.setEnableSemanticTokens(enableSemanticTokens);
        Object quickPickSupport = initOptions.get("supportQuickPick");
        boolean enableQuickPickSupport = quickPickSupport != null && Boolean.parseBoolean(String.valueOf(quickPickSupport));
        initializationOptions.setSupportQuickPick(enableQuickPickSupport);
        Object lsLightWeightMode = initOptions.get("enableLightWeightMode");
        boolean enableLSLightWeightMode = lsLightWeightMode != null && Boolean.parseBoolean(String.valueOf(lsLightWeightMode));
        initializationOptions.setEnableLSLightWeightMode(enableLSLightWeightMode);
        Object positionalRenameSupport = initOptions.get("supportPositionalRenamePopup");
        boolean enablePositionalRenameSupport = positionalRenameSupport != null && Boolean.parseBoolean(String.valueOf(positionalRenameSupport));
        initializationOptions.setSupportPositionalRenamePopup(enablePositionalRenameSupport);
        Object inlayHintsSupport = initOptions.get("enableInlayHints");
        boolean enableInlayHintsSupport = inlayHintsSupport != null && Boolean.parseBoolean(String.valueOf(inlayHintsSupport));
        initializationOptions.setEnableInlayHints(enableInlayHintsSupport);
        Object indexPackages = initOptions.get("enableIndexPackages");
        boolean enableIndexPackages = indexPackages == null || Boolean.parseBoolean(String.valueOf(indexPackages));
        initializationOptions.setEnableIndexPackages(enableIndexPackages);
        Object memoryUsageMonitor = initOptions.get("enableMemoryUsageMonitor");
        boolean enableMemoryUsageMonitor = memoryUsageMonitor != null && Boolean.parseBoolean(String.valueOf(memoryUsageMonitor));
        initializationOptions.setEnableMemoryUsageMonitor(enableMemoryUsageMonitor);
        return initializationOptions;
    }

    public static class ExperimentalClientCapabilitiesImpl
    implements ExperimentalClientCapabilities {
        private boolean introspectionEnabled = false;
        private boolean showTextDocumentEnabled = false;

        public boolean isIntrospectionEnabled() {
            return this.introspectionEnabled;
        }

        public boolean isShowTextDocumentEnabled() {
            return this.showTextDocumentEnabled;
        }

        private void setIntrospectionEnabled(boolean introspectionEnabled) {
            this.introspectionEnabled = introspectionEnabled;
        }

        private void setShowTextDocumentEnabled(boolean showTextDocumentEnabled) {
            this.showTextDocumentEnabled = showTextDocumentEnabled;
        }
    }

    public static class InitializationOptionsImpl
    implements InitializationOptions {
        private boolean supportBalaScheme = false;
        private boolean enableSemanticTokens = false;
        private boolean supportQuickPick = false;
        private boolean enableLSLightWeightMode = false;
        private boolean supportPositionalRenamePopup = false;
        private boolean enableInlayHints = false;
        private boolean enableIndexPackages = false;
        private boolean enableMemoryUsageMonitor = false;

        public boolean isBalaSchemeSupported() {
            return this.supportBalaScheme;
        }

        public void setSupportBalaScheme(boolean supportBalaScheme) {
            this.supportBalaScheme = supportBalaScheme;
        }

        public boolean isEnableSemanticTokens() {
            return this.enableSemanticTokens;
        }

        public void setEnableSemanticTokens(boolean enableSemanticTokens) {
            this.enableSemanticTokens = enableSemanticTokens;
        }

        public boolean isPositionalRefactorRenameSupported() {
            return this.supportPositionalRenamePopup;
        }

        public void setSupportPositionalRenamePopup(boolean supportPositionalRenamePopup) {
            this.supportPositionalRenamePopup = supportPositionalRenamePopup;
        }

        public boolean isQuickPickSupported() {
            return this.supportQuickPick;
        }

        public void setEnableLSLightWeightMode(boolean enableLSLightWeightMode) {
            this.enableLSLightWeightMode = enableLSLightWeightMode;
        }

        public boolean isEnableLightWeightMode() {
            return this.enableLSLightWeightMode;
        }

        public void setSupportQuickPick(boolean supportQuickPick) {
            this.supportQuickPick = supportQuickPick;
        }

        public boolean isEnableInlayHints() {
            return this.enableInlayHints;
        }

        public void setEnableInlayHints(boolean enableInlayHints) {
            this.enableInlayHints = enableInlayHints;
        }

        public boolean isEnableIndexPackages() {
            return this.enableIndexPackages;
        }

        public void setEnableIndexPackages(boolean enableIndexPackages) {
            this.enableIndexPackages = enableIndexPackages;
        }

        public boolean isEnableMemoryUsageMonitor() {
            return this.enableMemoryUsageMonitor;
        }

        public void setEnableMemoryUsageMonitor(boolean enableMemoryUsageMonitor) {
            this.enableMemoryUsageMonitor = enableMemoryUsageMonitor;
        }
    }
}

