/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.CodeActionExtension;
import org.ballerinalang.langserver.commons.CodeActionResolveContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.CompletionExtension;
import org.ballerinalang.langserver.commons.DiagnosticsExtension;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.FormattingExtension;
import org.ballerinalang.langserver.commons.LanguageExtension;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.codeaction.ResolvableCodeAction;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class LangExtensionDelegator {
    private static final LangExtensionDelegator INSTANCE = new LangExtensionDelegator();
    private final List<CompletionExtension> completionExtensions = new ArrayList<CompletionExtension>();
    private final List<CodeActionExtension> codeActionsExtensions = new ArrayList<CodeActionExtension>();
    private final List<FormattingExtension> formatExtensions = new ArrayList<FormattingExtension>();
    private final List<DiagnosticsExtension> diagExtensions = new ArrayList<DiagnosticsExtension>();

    private LangExtensionDelegator() {
        ServiceLoader.load(LanguageExtension.class).forEach(languageExtension -> {
            switch (languageExtension.kind()) {
                case COMPLETION: {
                    this.completionExtensions.add((CompletionExtension)languageExtension);
                    break;
                }
                case CODEACTION: {
                    this.codeActionsExtensions.add((CodeActionExtension)languageExtension);
                    break;
                }
                case FORMAT: {
                    this.formatExtensions.add((FormattingExtension)languageExtension);
                    break;
                }
                case DIAGNOSTIC: {
                    this.diagExtensions.add((DiagnosticsExtension)languageExtension);
                    break;
                }
            }
        });
    }

    @Deprecated
    public Either<List<CompletionItem>, CompletionList> completion(CompletionParams params, CompletionContext context, LanguageServerContext serverContext) throws Throwable {
        ArrayList completionItems = new ArrayList();
        URI uri = URI.create(params.getTextDocument().getUri());
        for (CompletionExtension ext : this.completionExtensions) {
            if (!this.handleURIScheme(uri, ext.handledCustomURISchemes((Object)params, (DocumentServiceContext)context, serverContext)) || !ext.validate((Object)params)) continue;
            completionItems.addAll((Collection)ext.execute((Object)params, (DocumentServiceContext)context, serverContext));
        }
        return Either.forLeft(completionItems);
    }

    public Either<List<CompletionItem>, CompletionList> completion(CompletionParams params, CompletionContext context, LanguageServerContext serverContext, CancelChecker cancelChecker) throws Throwable {
        ArrayList completionItems = new ArrayList();
        URI uri = URI.create(params.getTextDocument().getUri());
        for (CompletionExtension ext : this.completionExtensions) {
            if (!this.handleURIScheme(uri, ext.handledCustomURISchemes((Object)params, (DocumentServiceContext)context, serverContext)) || !ext.validate((Object)params)) continue;
            completionItems.addAll((Collection)ext.execute((Object)params, (DocumentServiceContext)context, serverContext, cancelChecker));
        }
        return Either.forLeft(completionItems);
    }

    public List<? extends TextEdit> formatting(DocumentFormattingParams params, DocumentServiceContext context, LanguageServerContext serverContext) throws Throwable {
        ArrayList textEdits = new ArrayList();
        URI uri = URI.create(params.getTextDocument().getUri());
        for (FormattingExtension ext : this.formatExtensions) {
            if (!this.handleURIScheme(uri, ext.handledCustomURISchemes((Object)params, context, serverContext)) || !ext.validate((Object)params)) continue;
            textEdits.addAll((Collection)ext.execute((Object)params, context, serverContext));
        }
        return textEdits;
    }

    public List<? extends CodeAction> codeActions(CodeActionParams params, CodeActionContext context, LanguageServerContext serverContext) throws Throwable {
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        URI uri = URI.create(params.getTextDocument().getUri());
        for (CodeActionExtension ext : this.codeActionsExtensions) {
            if (!this.handleURIScheme(uri, ext.handledCustomURISchemes((Object)params, (DocumentServiceContext)context, serverContext)) || !ext.validate((Object)params)) continue;
            List codeActions = (List)ext.execute((Object)params, (DocumentServiceContext)context, serverContext);
            for (CodeAction codeAction : codeActions) {
                if (codeAction instanceof ResolvableCodeAction) {
                    ResolvableCodeAction action = (ResolvableCodeAction)codeAction;
                    action.getData().setExtName(ext.getClass().getName());
                }
                actions.add(codeAction);
            }
        }
        return actions;
    }

    public CodeAction resolveCodeAction(ResolvableCodeAction resolvableCodeAction, CodeActionResolveContext resolveContext) {
        for (CodeActionExtension ext : this.codeActionsExtensions) {
            if (!ext.getClass().getName().equals(resolvableCodeAction.getData().getExtName())) continue;
            return ext.resolve(resolvableCodeAction, resolveContext);
        }
        throw new IllegalStateException("Extension not found: " + resolvableCodeAction.getData().getExtName());
    }

    public List<PublishDiagnosticsParams> diagnostics(String uri, DocumentServiceContext context, LanguageServerContext serverContext) throws Throwable {
        ArrayList<PublishDiagnosticsParams> diagnosticsParams = new ArrayList<PublishDiagnosticsParams>();
        URI fileURI = URI.create(uri);
        for (DiagnosticsExtension ext : this.diagExtensions) {
            if (!this.handleURIScheme(fileURI, ext.handledCustomURISchemes((Object)uri, context, serverContext)) || !ext.validate((Object)uri)) continue;
            diagnosticsParams.addAll((Collection)ext.execute((Object)uri, context, serverContext));
        }
        return diagnosticsParams;
    }

    public static LangExtensionDelegator instance() {
        return INSTANCE;
    }

    private boolean handleURIScheme(URI uri, List<String> customSchemes) {
        return "file".equals(uri.getScheme()) || customSchemes.contains(uri.getScheme());
    }
}

