/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;

public class MemoryUsageMonitor {
    private final MemoryMXBean memoryMXBean;
    public static final LanguageServerContext.Key<MemoryUsageMonitor> MEMORY_USAGE_MONITOR_KEY = new LanguageServerContext.Key();

    public MemoryUsageMonitor(MemoryMXBean memoryMXBean) {
        this.memoryMXBean = memoryMXBean;
    }

    public MemoryUsageMonitor() {
        this.memoryMXBean = ManagementFactory.getMemoryMXBean();
    }

    public static MemoryUsageMonitor getInstance(LanguageServerContext context) {
        MemoryUsageMonitor memoryUsageMonitor = (MemoryUsageMonitor)context.get(MEMORY_USAGE_MONITOR_KEY);
        if (memoryUsageMonitor == null) {
            memoryUsageMonitor = new MemoryUsageMonitor();
            context.put(MEMORY_USAGE_MONITOR_KEY, (Object)memoryUsageMonitor);
        }
        return memoryUsageMonitor;
    }

    public void start(LanguageClient client) {
        Thread.startVirtualThread(() -> {
            while (true) {
                try {
                    while (true) {
                        long maxMemory;
                        MemoryUsage heapMemoryUsage;
                        if ((heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage()) == null) {
                            return;
                        }
                        long usedMemory = heapMemoryUsage.getUsed();
                        if ((double)usedMemory >= (double)(maxMemory = heapMemoryUsage.getMax()) * 0.9) {
                            client.showMessage(new MessageParams(MessageType.Error, "Memory usage is high. Some features may become unresponsive. Please reload the window or increase the memory allocated for Ballerina"));
                        }
                        Thread.sleep(60000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
    }
}

